/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.internal.url;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.gemini.web.core.InstallationOptions;
import org.eclipse.gemini.web.core.WebBundleManifestTransformer;
import org.eclipse.gemini.web.internal.WebContainerUtils;
import org.eclipse.gemini.web.internal.url.WebBundleScanner;
import org.eclipse.gemini.web.internal.url.WebBundleScannerCallback;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.eclipse.virgo.util.osgi.manifest.BundleSymbolicName;
import org.eclipse.virgo.util.osgi.manifest.ImportedPackage;
import org.osgi.framework.Version;

public final class DefaultsWebBundleManifestTransformer
implements WebBundleManifestTransformer {
    private static final int MINIMUM_BUNDLE_MANIFEST_VERSION = 2;
    private static final String WEB_INF_CLASSES = "WEB-INF/classes";

    @Override
    public void transform(BundleManifest manifest, URL sourceURL, InstallationOptions options, boolean webBundle) throws IOException {
        if (!webBundle || options.getDefaultWABHeaders()) {
            this.applyDefaultBundleSymbolicName(sourceURL, manifest);
            this.applyDefaultBundleManifestVersion(manifest);
            this.applyBundleClassPath(sourceURL, manifest);
            this.applyImportPackage(manifest);
        }
    }

    private void applyImportPackage(BundleManifest manifest) {
        this.addImportInNecessary("javax.servlet", new Version("2.5"), manifest);
        this.addImportInNecessary("javax.servlet.annotation", new Version("2.6"), manifest);
        this.addImportInNecessary("javax.servlet.descriptor", new Version("2.6"), manifest);
        this.addImportInNecessary("javax.servlet.http", new Version("2.5"), manifest);
        this.addImportInNecessary("javax.servlet.jsp", new Version("2.1"), manifest);
        this.addImportInNecessary("javax.servlet.jsp.el", new Version("2.1"), manifest);
        this.addImportInNecessary("javax.servlet.jsp.tagext", new Version("2.1"), manifest);
        this.addImportInNecessary("javax.el", new Version("1.0"), manifest);
        this.addImportInNecessary("javax.websocket", new Version("1.0"), manifest);
        this.addImportInNecessary("javax.websocket.server", new Version("1.0"), manifest);
    }

    private void addImportInNecessary(String packageName, Version version, BundleManifest manifest) {
        List pkgs = manifest.getImportPackage().getImportedPackages();
        for (ImportedPackage pkg : pkgs) {
            if (!pkg.getPackageName().equals(packageName)) continue;
            return;
        }
        ImportedPackage packageImport = manifest.getImportPackage().addImportedPackage(packageName);
        packageImport.getAttributes().put("version", version.toString());
    }

    private void applyBundleClassPath(URL source, BundleManifest manifest) throws IOException {
        List bundleClassPath = manifest.getBundleClasspath();
        if (!bundleClassPath.contains(WEB_INF_CLASSES)) {
            bundleClassPath.add(0, WEB_INF_CLASSES);
        }
        final ArrayList entries = new ArrayList();
        WebBundleScanner scanner = new WebBundleScanner(source, new WebBundleScannerCallback(){

            @Override
            public void classFound(String entry) {
            }

            @Override
            public void jarFound(String entry) {
                entries.add(entry);
            }
        });
        scanner.scanWar();
        for (String entry : entries) {
            if (bundleClassPath.contains(entry)) continue;
            bundleClassPath.add(entry);
        }
    }

    private void applyDefaultBundleManifestVersion(BundleManifest manifest) {
        if (manifest.getBundleManifestVersion() < 2) {
            manifest.setBundleManifestVersion(2);
        }
    }

    private void applyDefaultBundleSymbolicName(URL source, BundleManifest manifest) {
        BundleSymbolicName bsn = manifest.getBundleSymbolicName();
        if (bsn.getSymbolicName() == null) {
            bsn.setSymbolicName(WebContainerUtils.createDefaultBundleSymbolicName(source));
        }
    }
}

