/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.runtime.data.random;

import org.eclipse.escet.chi.runtime.ChiCoordinator;
import org.eclipse.escet.chi.runtime.ChiSimulatorException;
import org.eclipse.escet.chi.runtime.data.random.DoubleDistribution;
import org.eclipse.escet.chi.runtime.data.random.RandomGenerator;
import org.eclipse.escet.common.java.Strings;

public class DoubleUniformDistribution
extends DoubleDistribution {
    private RandomGenerator randGen;
    private double low;
    private double high;

    public DoubleUniformDistribution(ChiCoordinator chiCoordinator, double low, double high) {
        super(chiCoordinator);
        if (low >= high) {
            String msg = Strings.fmt((String)"The real Uniform distribution expects the lower bound to be less than the higher bound, found interval [%s..%s) instead.", (Object[])new Object[]{low, high});
            throw new ChiSimulatorException(msg);
        }
        this.low = low;
        this.high = high;
        this.randGen = chiCoordinator.getFreshGenerator();
    }

    @Override
    public double sample() {
        return DoubleUniformDistribution.drawDoubleUniform(this.randGen, this.low, this.high);
    }

    public static double drawDoubleUniform(RandomGenerator randGen, double low, double up) {
        double range = up - low;
        return low + range * randGen.draw();
    }
}

