/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.java;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.eclipse.escet.common.java.Strings;

public final class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static <T> T getFieldValue(Object obj, String fieldName) {
        return ReflectionUtils.getFieldValue(obj, obj.getClass(), fieldName);
    }

    public static <T> T getFieldValue(Object obj, Class<?> cls, String fieldName) {
        Object value;
        Field field;
        try {
            field = cls.getDeclaredField(fieldName);
        }
        catch (SecurityException e) {
            String msg = Strings.fmt("Failed to retrieve field \"%s\" from object: %s", fieldName, obj);
            throw new IllegalArgumentException(msg, e);
        }
        catch (NoSuchFieldException e) {
            Class<?> superCls = cls.getSuperclass();
            if (superCls == null) {
                String msg = Strings.fmt("Failed to retrieve field \"%s\" from object: %s", fieldName, obj);
                throw new IllegalArgumentException(msg, e);
            }
            return ReflectionUtils.getFieldValue(obj, superCls, fieldName);
        }
        field.setAccessible(true);
        try {
            value = field.get(obj);
        }
        catch (IllegalArgumentException e) {
            String msg = Strings.fmt("Failed to retrieve value of field \"%s\" from object: %s", fieldName, obj);
            throw new IllegalArgumentException(msg, e);
        }
        catch (IllegalAccessException e) {
            String msg = Strings.fmt("Failed to retrieve value of field \"%s\" from object: %s", fieldName, obj);
            throw new IllegalArgumentException(msg, e);
        }
        if (value == null) {
            return null;
        }
        Object rslt = value;
        return (T)rslt;
    }

    public static void runMain(Class<?> cls, String[] args) {
        Method m;
        try {
            m = cls.getMethod("main", args.getClass());
        }
        catch (SecurityException e) {
            String msg = "Failed to obtain 'main' method for class: " + String.valueOf(cls);
            throw new RuntimeException(msg, e);
        }
        catch (NoSuchMethodException e) {
            String msg = "Could not find 'main' method for class: " + String.valueOf(cls);
            throw new RuntimeException(msg, e);
        }
        m.setAccessible(true);
        int mods = m.getModifiers();
        if (m.getReturnType() != Void.TYPE || !Modifier.isStatic(mods) || !Modifier.isPublic(mods)) {
            String msg = "The 'main' method is not 'public static void' for class: " + String.valueOf(cls);
            throw new RuntimeException(msg);
        }
        try {
            m.invoke(null, new Object[]{args});
        }
        catch (IllegalAccessException e) {
            String msg = "Failed to invoke 'main' method for class: " + String.valueOf(cls);
            throw new RuntimeException(msg, e);
        }
        catch (IllegalArgumentException e) {
            String msg = "Failed to invoke 'main' method for class: " + String.valueOf(cls);
            throw new RuntimeException(msg, e);
        }
        catch (InvocationTargetException e) {
            String msg = "Failed to invoke 'main' method for class: " + String.valueOf(cls);
            throw new RuntimeException(msg, e);
        }
    }
}

