/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.checkers.checks;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.escet.cif.checkers.CifCheck;
import org.eclipse.escet.cif.checkers.CifCheckViolations;
import org.eclipse.escet.cif.metamodel.cif.annotations.AnnotatedObject;
import org.eclipse.escet.cif.metamodel.cif.annotations.Annotation;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class AnnoNoSpecificAnnosCheck
extends CifCheck {
    private final Set<String> disalloweds;

    public AnnoNoSpecificAnnosCheck(NoSpecificAnno ... disalloweds) {
        this(EnumSet.copyOf(Arrays.asList(disalloweds)));
    }

    public AnnoNoSpecificAnnosCheck(Set<NoSpecificAnno> disalloweds) {
        this.disalloweds = Collections.unmodifiableSet(disalloweds.stream().map(disallow -> disallow.name).collect(Collectors.toSet()));
    }

    protected void preprocessAnnotatedObject(AnnotatedObject obj, CifCheckViolations violations) {
        for (Annotation anno : obj.getAnnotations()) {
            if (!this.disalloweds.contains(anno.getName())) continue;
            violations.add((PositionObject)anno, "An annotation with name \"%s\" is used", anno.getName());
        }
    }

    public static enum NoSpecificAnno {
        CONTROLLER_PROPERTIES("controller:properties"),
        DOC("doc"),
        PARTIAL_SPEC("partial"),
        REQUIREMENT_REACHABLE("requirement:reachable"),
        STATE("state");

        private final String name;

        private NoSpecificAnno(String name) {
            this.name = name;
        }
    }
}

