/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.metamodel.chi;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum UnaryOperators implements Enumerator
{
    INVERSE(0, "Inverse", "Inverse"),
    NEGATE(1, "Negate", "Negate"),
    SAMPLE(3, "Sample", "Sample"),
    PLUS(4, "Plus", "Plus");

    public static final int INVERSE_VALUE = 0;
    public static final int NEGATE_VALUE = 1;
    public static final int SAMPLE_VALUE = 3;
    public static final int PLUS_VALUE = 4;
    private static final UnaryOperators[] VALUES_ARRAY;
    public static final List<UnaryOperators> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new UnaryOperators[]{INVERSE, NEGATE, SAMPLE, PLUS};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static UnaryOperators get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            UnaryOperators result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static UnaryOperators getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            UnaryOperators result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static UnaryOperators get(int value) {
        switch (value) {
            case 0: {
                return INVERSE;
            }
            case 1: {
                return NEGATE;
            }
            case 3: {
                return SAMPLE;
            }
            case 4: {
                return PLUS;
            }
        }
        return null;
    }

    private UnaryOperators(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

