/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.app.framework.options;

import java.util.Locale;
import org.eclipse.escet.common.app.framework.options.Option;
import org.eclipse.escet.common.app.framework.options.OptionGroup;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InvalidOptionException;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;

public abstract class BooleanOption
extends Option<Boolean> {
    protected final boolean defaultValue;
    protected final String optDialogDescr;
    protected final String optDialogCheckboxText;

    public BooleanOption(String name, String description, Character cmdShort, String cmdLong, String cmdValue, boolean defaultValue, boolean showInDialog, String optDialogDescr, String optDialogCheckboxText) {
        super(name, description, cmdShort, cmdLong, cmdValue, showInDialog);
        Assert.check((!cmdLong.equals("*") ? 1 : 0) != 0);
        Assert.check((cmdValue == null || cmdValue.equals("BOOL") ? 1 : 0) != 0);
        Assert.ifAndOnlyIf((boolean)showInDialog, (optDialogDescr != null ? 1 : 0) != 0);
        Assert.ifAndOnlyIf((boolean)showInDialog, (optDialogCheckboxText != null ? 1 : 0) != 0);
        this.defaultValue = defaultValue;
        this.optDialogDescr = optDialogDescr;
        this.optDialogCheckboxText = optDialogCheckboxText;
    }

    @Override
    public Boolean getDefault() {
        return this.defaultValue;
    }

    public static String getOptionValue(boolean boolValue) {
        return boolValue ? "yes" : "no";
    }

    @Override
    public Boolean parseValue(String optName, String value) {
        if (this.cmdValue == null) {
            Assert.check((value == null ? 1 : 0) != 0);
            return !this.defaultValue;
        }
        Assert.notNull((Object)value);
        String v = value.toLowerCase(Locale.US);
        if (v.equals("yes") || v.equals("true") || v.equals("on") || v.equals("1")) {
            return true;
        }
        if (v.equals("no") || v.equals("false") || v.equals("off") || v.equals("0")) {
            return false;
        }
        String msg = Strings.fmt((String)"\"%s\" is not a valid value for a boolean option.", (Object[])new Object[]{value});
        throw new InvalidOptionException(msg);
    }

    @Override
    public String[] getCmdLine(Object value) {
        boolean v = (Boolean)value;
        String s = v ? "yes" : "no";
        return new String[]{"--" + this.cmdLong + "=" + s};
    }

    @Override
    public OptionGroup<Boolean> createOptionGroup(Composite page) {
        Assert.check((boolean)this.showInDialog);
        return new OptionGroup<Boolean>(page, (Option)this){
            Button enabledButton;

            @Override
            protected void addComponents(Group group) {
                this.enabledButton = new Button((Composite)group, 32);
                this.enabledButton.setText(BooleanOption.this.optDialogCheckboxText);
                this.layoutVertical(new Control[]{this.enabledButton});
            }

            @Override
            public String getDescription() {
                return BooleanOption.this.optDialogDescr;
            }

            @Override
            public void setToValue(Boolean value) {
                this.enabledButton.setSelection(value.booleanValue());
            }

            @Override
            public String[] getCmdLine() {
                boolean value = this.enabledButton.getSelection();
                if (BooleanOption.this.cmdValue == null) {
                    String[] stringArray;
                    if (value != BooleanOption.this.defaultValue) {
                        String[] stringArray2 = new String[1];
                        stringArray = stringArray2;
                        stringArray2[0] = "--" + BooleanOption.this.cmdLong;
                    } else {
                        stringArray = new String[]{};
                    }
                    return stringArray;
                }
                String valueTxt = value ? "yes" : "no";
                return new String[]{"--" + BooleanOption.this.cmdLong + "=" + valueTxt};
            }
        };
    }
}

