/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.controllercheck.checks.finiteresponse;

import java.util.List;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.controllercheck.checks.CheckConclusion;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.common.java.output.DebugNormalOutput;
import org.eclipse.escet.common.java.output.WarnOutput;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class FiniteResponseCheckConclusion
implements CheckConclusion {
    private final List<Event> unprovenEvents;
    private final boolean printControlLoops;

    public FiniteResponseCheckConclusion(List<Event> orderedEvents, boolean printControlLoops) {
        this.unprovenEvents = orderedEvents;
        this.printControlLoops = printControlLoops;
    }

    @Override
    public boolean propertyHolds() {
        return this.unprovenEvents.isEmpty();
    }

    @Override
    public boolean hasDetails() {
        return !this.propertyHolds();
    }

    @Override
    public void printResult(DebugNormalOutput out, WarnOutput warn) {
        if (this.propertyHolds()) {
            out.line("[OK] The specification has finite response.");
        } else {
            out.line("[ERROR] The specification may NOT have finite response:");
            out.line();
            out.inc();
            out.line("At least one controllable-event loop was found.");
            if (this.printControlLoops) {
                out.line("The following events might still occur in a controllable-event loop:");
                out.inc();
                for (Event event : this.unprovenEvents) {
                    out.line("- %s", new Object[]{CifTextUtils.getAbsName((PositionObject)event)});
                }
                out.dec();
            }
            out.dec();
        }
    }
}

