/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.generators;

import java.util.List;
import java.util.Map;
import org.eclipse.escet.cif.common.CifDocAnnotationFormatter;
import org.eclipse.escet.cif.common.CifEvalException;
import org.eclipse.escet.cif.common.CifEvalUtils;
import org.eclipse.escet.cif.common.StateInitVarOrderer;
import org.eclipse.escet.cif.metamodel.cif.annotations.AnnotatedObject;
import org.eclipse.escet.cif.metamodel.cif.declarations.Constant;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.plcgen.conversion.PlcFunctionAppls;
import org.eclipse.escet.cif.plcgen.conversion.expressions.CifDataProvider;
import org.eclipse.escet.cif.plcgen.conversion.expressions.ExprGenerator;
import org.eclipse.escet.cif.plcgen.conversion.expressions.ExprValueResult;
import org.eclipse.escet.cif.plcgen.generators.DocumentingSupport;
import org.eclipse.escet.cif.plcgen.generators.NameGenerator;
import org.eclipse.escet.cif.plcgen.generators.PlcVariablePurpose;
import org.eclipse.escet.cif.plcgen.generators.TypeGenerator;
import org.eclipse.escet.cif.plcgen.generators.VariableStorage;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcBasicVariable;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcDataVariable;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcExpression;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcVarExpression;
import org.eclipse.escet.cif.plcgen.model.statements.PlcAssignmentStatement;
import org.eclipse.escet.cif.plcgen.model.statements.PlcCommentBlock;
import org.eclipse.escet.cif.plcgen.model.statements.PlcCommentLine;
import org.eclipse.escet.cif.plcgen.model.types.PlcElementaryType;
import org.eclipse.escet.cif.plcgen.model.types.PlcType;
import org.eclipse.escet.cif.plcgen.options.ConvertEnums;
import org.eclipse.escet.cif.plcgen.targets.PlcTarget;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class DefaultVariableStorage
implements VariableStorage {
    private final PlcTarget target;
    private final NameGenerator nameGenerator;
    private final TypeGenerator typeGenerator;
    private final PlcFunctionAppls funcAppls;
    private final Map<Declaration, PlcBasicVariable> variables = Maps.map();

    public DefaultVariableStorage(PlcTarget target, NameGenerator nameGenerator, TypeGenerator typeGenerator) {
        this.target = target;
        this.nameGenerator = nameGenerator;
        this.typeGenerator = typeGenerator;
        this.funcAppls = new PlcFunctionAppls(target);
    }

    @Override
    public void addStateVariable(Declaration decl, CifType type) {
        PlcType varType = this.typeGenerator.convertType(type);
        String varName = this.nameGenerator.generateGlobalName((PositionObject)decl);
        PlcDataVariable plcVar = this.target.getCodeStorage().addStateVariable(varName, varType);
        this.variables.put(decl, plcVar);
    }

    @Override
    public void addConstant(Constant constant) {
        Expression expr;
        try {
            Object rslt = CifEvalUtils.eval((Expression)constant.getValue(), (boolean)true);
            expr = CifEvalUtils.valueToExpr((Object)rslt, (CifType)constant.getType());
        }
        catch (CifEvalException ex) {
            throw new AssertionError("Constant cannot be statically evaluated.", ex);
        }
        ExprGenerator exprGen = this.target.getCodeStorage().getExprGenerator();
        ExprValueResult exprResult = exprGen.convertValue(expr);
        Assert.check((!exprResult.hasCode() && !exprResult.hasCodeVariables() && !exprResult.hasValueVariables() ? 1 : 0) != 0);
        PlcExpression value = exprResult.value;
        if (value instanceof PlcVarExpression) {
            PlcVarExpression varRefValue = (PlcVarExpression)value;
            Assert.areEqual((Object)((Object)this.target.getActualEnumerationsConversion()), (Object)((Object)ConvertEnums.CONSTS));
            Assert.check((boolean)varRefValue.projections.isEmpty());
            Assert.check((boolean)PlcElementaryType.isBitStringType(varRefValue.type));
            Assert.check((boolean)(varRefValue.variable instanceof PlcDataVariable));
            PlcDataVariable dataVarValue = (PlcDataVariable)varRefValue.variable;
            Assert.areEqual((Object)dataVarValue.address, null);
            Assert.notNull((Object)dataVarValue.value);
            value = dataVarValue.value;
        }
        String varName = this.nameGenerator.generateGlobalName((PositionObject)constant);
        String targetText = this.target.getUsageVariableText(PlcVariablePurpose.CONSTANT, varName);
        PlcType varType = this.typeGenerator.convertType(constant.getType());
        PlcDataVariable plcVar = new PlcDataVariable(targetText, varName, varType, null, value);
        this.target.getCodeStorage().addConstant(plcVar);
        this.variables.put((Declaration)constant, plcVar);
    }

    @Override
    public void process() {
        ExprGenerator exprGen = this.target.getCodeStorage().getExprGenerator();
        StateInitVarOrderer varOrderer = new StateInitVarOrderer();
        for (Declaration decl : this.variables.keySet()) {
            if (!(decl instanceof DiscVariable) && !(decl instanceof ContVariable)) continue;
            varOrderer.addObject((Object)decl);
        }
        List statements = Lists.list();
        CifDocAnnotationFormatter varInitFormatter = new CifDocAnnotationFormatter(null, List.of(""), null, null, null);
        statements.add(new PlcCommentLine("Initialize the state variables."));
        for (Declaration decl : varOrderer.computeOrder(true)) {
            ContVariable assignedContVar;
            ExprValueResult exprResult;
            String commentText = Strings.fmt((String)"Initialize %s.", (Object[])new Object[]{DocumentingSupport.getDescription((PositionObject)decl)});
            if (!varInitFormatter.hasDocs((AnnotatedObject)decl)) {
                statements.add(new PlcCommentLine(commentText));
            } else {
                statements.add(new PlcCommentBlock(Lists.concat((Object)commentText, (List)varInitFormatter.formatDocs((AnnotatedObject)decl))));
            }
            if (decl instanceof DiscVariable) {
                DiscVariable discVar = (DiscVariable)decl;
                exprResult = exprGen.convertValue((Expression)Lists.first((List)discVar.getValue().getValues()));
                assignedContVar = null;
            } else if (decl instanceof ContVariable) {
                ContVariable contVar = (ContVariable)decl;
                exprResult = exprGen.convertValue(contVar.getValue());
                assignedContVar = contVar;
            } else {
                throw new AssertionError((Object)("Unexpected kind of variable " + String.valueOf(decl)));
            }
            statements.addAll(exprResult.code);
            exprGen.releaseScratchVariables(exprResult.codeVariables);
            PlcVarExpression lhs = new PlcVarExpression(this.variables.get(decl), new PlcVarExpression.PlcProjection[0]);
            statements.add(new PlcAssignmentStatement(lhs, exprResult.value));
            exprGen.releaseScratchVariables(exprResult.valueVariables);
            if (assignedContVar == null) continue;
            statements.addAll(this.target.getContinuousVariablesGenerator().getPlcTimerCodeGen(assignedContVar).generateAssignPreset());
        }
        this.target.getCodeStorage().addStateInitialization(statements);
    }

    @Override
    public CifDataProvider getCifDataProvider() {
        return new CifDataProvider(){

            @Override
            public PlcExpression getValueForConstant(Constant constant) {
                PlcBasicVariable plcConstantVar = DefaultVariableStorage.this.variables.get(constant);
                Assert.notNull((Object)plcConstantVar);
                return new PlcVarExpression(plcConstantVar, new PlcVarExpression.PlcProjection[0]);
            }

            @Override
            public PlcExpression getValueForDiscVar(DiscVariable variable) {
                PlcBasicVariable plcDiscvar = DefaultVariableStorage.this.variables.get(variable);
                Assert.notNull((Object)plcDiscvar);
                return new PlcVarExpression(plcDiscvar, new PlcVarExpression.PlcProjection[0]);
            }

            @Override
            public PlcVarExpression getAddressableForDiscVar(DiscVariable variable) {
                PlcBasicVariable plcDiscvar = DefaultVariableStorage.this.variables.get(variable);
                Assert.notNull((Object)plcDiscvar);
                return new PlcVarExpression(plcDiscvar, new PlcVarExpression.PlcProjection[0]);
            }

            @Override
            public PlcExpression getValueForContvar(ContVariable variable, boolean getDerivative) {
                if (getDerivative) {
                    return DefaultVariableStorage.this.funcAppls.negateFuncAppl(DefaultVariableStorage.this.target.makeStdReal("1.0"));
                }
                PlcBasicVariable plcContVar = DefaultVariableStorage.this.variables.get(variable);
                Assert.notNull((Object)plcContVar);
                return new PlcVarExpression(plcContVar, new PlcVarExpression.PlcProjection[0]);
            }

            @Override
            public PlcVarExpression getAddressableForContvar(ContVariable variable) {
                PlcBasicVariable plcContVar = DefaultVariableStorage.this.variables.get(variable);
                Assert.notNull((Object)plcContVar);
                return new PlcVarExpression(plcContVar, new PlcVarExpression.PlcProjection[0]);
            }

            @Override
            public PlcExpression getValueForInputVar(InputVariable variable) {
                PlcBasicVariable plcInpvar = DefaultVariableStorage.this.variables.get(variable);
                Assert.notNull((Object)plcInpvar);
                return new PlcVarExpression(plcInpvar, new PlcVarExpression.PlcProjection[0]);
            }

            @Override
            public PlcVarExpression getAddressableForInputVar(InputVariable variable) {
                PlcBasicVariable plcInpvar = DefaultVariableStorage.this.variables.get(variable);
                Assert.notNull((Object)plcInpvar);
                return new PlcVarExpression(plcInpvar, new PlcVarExpression.PlcProjection[0]);
            }
        };
    }
}

