/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.core.subinterfaces;

import com.google.common.base.Optional;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.internal.common.model.util.FileUtil;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.core.subinterfaces.Messages;
import org.eclipse.emf.emfstore.internal.server.model.versioning.ChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.FileBasedChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.VersioningFactory;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.server.ESCloseableIterable;
import org.eclipse.emf.emfstore.server.exceptions.ESException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangePackageFragmentUploadAdapter
extends AdapterImpl {
    private final Map<String, FileBasedChangePackage> proxyIdToChangePackageFragments = new LinkedHashMap<String, FileBasedChangePackage>();
    private final Map<String, FileBasedChangePackage> proxyIdToCompletedChangePackages = new LinkedHashMap<String, FileBasedChangePackage>();

    public void addFragment(String proxyId, List<AbstractOperation> fragment) throws ESException {
        FileBasedChangePackage fileBasedChangePackage = this.proxyIdToChangePackageFragments.get(proxyId);
        if (fileBasedChangePackage == null) {
            fileBasedChangePackage = VersioningFactory.eINSTANCE.createFileBasedChangePackage();
            fileBasedChangePackage.initialize(FileUtil.createLocationForTemporaryChangePackage());
            this.proxyIdToChangePackageFragments.put(proxyId, fileBasedChangePackage);
        }
        fileBasedChangePackage.addAll(fragment);
        try {
            fileBasedChangePackage.save();
        }
        catch (IOException ex) {
            throw new ESException(Messages.ChangePackageFragmentAdapter_SaveChangePackageFailed, ex);
        }
    }

    public void markAsComplete(String proxyId) throws ESException {
        FileBasedChangePackage possiblyCompletedChangePackage = this.proxyIdToCompletedChangePackages.get(proxyId);
        FileBasedChangePackage fileBasedChangePackage = this.proxyIdToChangePackageFragments.get(proxyId);
        if (possiblyCompletedChangePackage != null) {
            throw new ESException(Messages.ChangePackageFragmentUploadAdapter_ChangePackageAlreadyComplete);
        }
        if (fileBasedChangePackage == null) {
            throw new ESException(MessageFormat.format(Messages.ChangePackageFragmentUploadAdapter_NoChangePackageFragmentsFound, proxyId));
        }
        this.proxyIdToCompletedChangePackages.put(proxyId, fileBasedChangePackage);
        this.proxyIdToChangePackageFragments.remove(proxyId);
    }

    public Optional<ChangePackage> getCompletedChangePackage(String proxyId) {
        FileBasedChangePackage fileBasedChangePackage = this.proxyIdToCompletedChangePackages.get(proxyId);
        if (fileBasedChangePackage == null) {
            return Optional.absent();
        }
        ESCloseableIterable operationsHandle = fileBasedChangePackage.operations();
        ChangePackage changePackage = VersioningFactory.eINSTANCE.createChangePackage();
        try {
            for (AbstractOperation operation : operationsHandle.iterable()) {
                changePackage.add((AbstractOperation)ModelUtil.clone((EObject)operation));
            }
        }
        finally {
            operationsHandle.close();
        }
        return Optional.of((Object)changePackage);
    }

    public void clearCompleted(String proxyId) {
        this.proxyIdToCompletedChangePackages.remove(proxyId);
    }
}

