/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.model.versioning.operations.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementId;
import org.eclipse.emf.emfstore.internal.common.model.provider.IdentifiableElementItemProvider;
import org.eclipse.emf.emfstore.internal.server.model.provider.ServerEditPlugin;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.OperationsPackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.provider.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractOperationItemProvider
extends IdentifiableElementItemProvider {
    public static final String NAME_CLASS_TAG_SEPARATOR = "&&&";
    public static final String NAME_TAG__SEPARATOR = "%%%";
    public static final String REFERENCE_TYPE_TAG_SEPARATOR = "#REFERENCE_TYPE_NAME#";

    public AbstractOperationItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public Collection<?> getChildren(Object object) {
        if (object instanceof AbstractOperation) {
            AbstractOperation operation = (AbstractOperation)object;
            ArrayList<ModelElementId> result = new ArrayList<ModelElementId>();
            ModelElementId modelElementId = operation.getModelElementId();
            if (modelElementId != null) {
                result.add(modelElementId);
            }
            result.addAll(operation.getOtherInvolvedModelElements());
            return result;
        }
        return super.getChildren(object);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addModelElementIdPropertyDescriptor(object);
            this.addAcceptedPropertyDescriptor(object);
            this.addClientDatePropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addModelElementIdPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_AbstractOperation_modelElementId_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_AbstractOperation_modelElementId_feature", "_UI_AbstractOperation_type"), (EStructuralFeature)OperationsPackage.Literals.ABSTRACT_OPERATION__MODEL_ELEMENT_ID, true, false, true, null, null, null));
    }

    protected void addAcceptedPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_AbstractOperation_accepted_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_AbstractOperation_accepted_feature", "_UI_AbstractOperation_type"), (EStructuralFeature)OperationsPackage.Literals.ABSTRACT_OPERATION__ACCEPTED, true, false, false, ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE, null, null));
    }

    protected void addClientDatePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_AbstractOperation_clientDate_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_AbstractOperation_clientDate_feature", "_UI_AbstractOperation_type"), (EStructuralFeature)OperationsPackage.Literals.ABSTRACT_OPERATION__CLIENT_DATE, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/AbstractOperation"));
    }

    public String getText(Object object) {
        String label = ((AbstractOperation)object).getIdentifier();
        return label == null || label.length() == 0 ? this.getString("_UI_AbstractOperation_type") : String.valueOf(this.getString("_UI_AbstractOperation_type")) + " " + label;
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(AbstractOperation.class)) {
            case 2: 
            case 3: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

    public ResourceLocator getResourceLocator() {
        return ServerEditPlugin.INSTANCE;
    }

    public static String getModelElementName(ModelElementId modelElementId) {
        return NAME_TAG__SEPARATOR + modelElementId.getId() + NAME_TAG__SEPARATOR;
    }

    public static String getModelElementNames(List<ModelElementId> modelElementIds) {
        StringBuilder builder = new StringBuilder();
        for (ModelElementId modelElementId : modelElementIds) {
            builder.append(NAME_TAG__SEPARATOR);
            builder.append(modelElementId.getId());
            builder.append(NAME_TAG__SEPARATOR);
            builder.append(", ");
        }
        if (modelElementIds.size() > 0) {
            builder.replace(builder.lastIndexOf("%%%, "), builder.length(), NAME_TAG__SEPARATOR);
        }
        if (modelElementIds.size() > 1) {
            builder.replace(builder.lastIndexOf("%%%, "), builder.lastIndexOf("%%%, ") + 3, "%%% and ");
        }
        return builder.toString();
    }

    public static String getModelElementClassAndName(ModelElementId modelElementId) {
        if (modelElementId == null) {
            return "(Unkown Element)";
        }
        return NAME_CLASS_TAG_SEPARATOR + modelElementId.getId() + NAME_CLASS_TAG_SEPARATOR;
    }

    public static String getModelElementClassesAndNames(EList<ModelElementId> idList, String typeName) {
        StringBuilder sb = new StringBuilder();
        if (idList.size() > 2) {
            return String.valueOf(idList.size()) + " " + typeName + "s";
        }
        int i = 0;
        while (i < idList.size()) {
            if (i > 0 && i == idList.size() - 1) {
                sb.append(Messages.AbstractOperationItemProvider_And);
            } else if (i > 0) {
                sb.append(", ");
            }
            ModelElementId id = (ModelElementId)idList.get(i);
            sb.append(AbstractOperationItemProvider.getModelElementClassAndName(id));
            ++i;
        }
        return sb.toString();
    }

    protected String trim(Object object) {
        if (object == null) {
            return "(null)";
        }
        String string = object.toString();
        String result = string.trim();
        if (result.length() == 0) {
            return "(empty)";
        }
        return result;
    }
}

