/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gymnast.runtime.core.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gymnast.runtime.core.parser.ParseContext;
import org.eclipse.gymnast.runtime.core.parser.ParseError;
import org.eclipse.gymnast.runtime.core.parser.ParseMessage;
import org.eclipse.gymnast.runtime.core.parser.ParseWarning;

public class MarkerUtil {
    public static void updateMarkers(IFile file, ParseContext parseContext) {
        MarkerUtil.clearMarkers(file);
        MarkerUtil.placeMarkers(file, parseContext);
    }

    public static String getMarkerType() {
        return "org.eclipse.core.resources.problemmarker";
    }

    public static void clearMarkers(IFile file) {
        try {
            file.deleteMarkers(MarkerUtil.getMarkerType(), true, 2);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void placeMarkers(IFile file, ParseContext parseContext) {
        try {
            ParseMessage[] parseMessages = parseContext.getMessages();
            int i = 0;
            while (i < parseMessages.length) {
                MarkerUtil.createMarker(file, parseMessages[i]);
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void createMarker(IFile file, ParseMessage message) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        int offset = message.getOffset();
        int length = message.getLength();
        map.put("message", message.getMessage());
        if (message instanceof ParseError) {
            map.put("severity", new Integer(2));
        } else if (message instanceof ParseWarning) {
            map.put("severity", new Integer(1));
        } else {
            map.put("severity", new Integer(0));
        }
        map.put("charStart", new Integer(offset));
        map.put("charEnd", new Integer(offset + length));
        map.put("transient", new Boolean(true));
        try {
            MarkerUtil.createMarker((IResource)file, map, MarkerUtil.getMarkerType());
        }
        catch (CoreException ex) {
            ex.printStackTrace();
        }
    }

    protected static void createMarker(final IResource resource, final Map attributes, final String markerType) throws CoreException {
        IWorkspaceRunnable r = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IMarker marker = resource.createMarker(markerType);
                marker.setAttributes(attributes);
            }
        };
        resource.getWorkspace().run(r, null, 1, null);
    }
}

