/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfatic.ui;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.emfatic.ui.redsquiggles.EmfaticRedSquiggler;
import org.eclipse.emf.emfatic.ui.templates.EmfaticContextType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.editors.text.templates.ContributionContextTypeRegistry;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class EmfaticUIPlugin
extends AbstractUIPlugin {
    private static EmfaticUIPlugin plugin;
    private ResourceBundle resourceBundle;
    private IResourceChangeListener redSquiggler;
    private TemplateStore emfaticTemplateStore;
    private ContributionContextTypeRegistry emfaticTypeRegistry = null;
    private static final String CUSTOM_TEMPLATES_EMFATIC_KEY = "EmfaticTemplates";
    private HashMap<String, Image> imageRegistry = new HashMap();

    public EmfaticUIPlugin() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.eclipse.emf.emfatic.ui.EmfaticUIPluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
        this.redSquiggler = new EmfaticRedSquiggler();
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.redSquiggler, 1);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    public static EmfaticUIPlugin getDefault() {
        return plugin;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = EmfaticUIPlugin.getDefault().getResourceBundle();
        try {
            return bundle == null ? key : bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public TemplateStore getEmfaticTemplateStore() {
        if (this.emfaticTemplateStore == null) {
            this.emfaticTemplateStore = new ContributionTemplateStore(this.getEmfaticContextTypeRegistry(), this.getPreferenceStore(), CUSTOM_TEMPLATES_EMFATIC_KEY);
            try {
                this.emfaticTemplateStore.load();
            }
            catch (IOException e) {
                EmfaticUIPlugin.log("Loading Emfatic template store", e);
                throw new RuntimeException(e);
            }
        }
        return this.emfaticTemplateStore;
    }

    public ContextTypeRegistry getEmfaticContextTypeRegistry() {
        if (this.emfaticTypeRegistry == null) {
            this.emfaticTypeRegistry = new ContributionContextTypeRegistry();
            this.emfaticTypeRegistry.addContextType((TemplateContextType)new EmfaticContextType());
        }
        return this.emfaticTypeRegistry;
    }

    public static void log(String msg, Throwable t) {
        EmfaticUIPlugin.log(msg, t, 4);
    }

    public static void log(String msg, Throwable t, int level) {
        Status stat = new Status(level, EmfaticUIPlugin.getPluginId(), level, msg, t);
        EmfaticUIPlugin.getDefault().getLog().log((IStatus)stat);
    }

    public static String getPluginId() {
        return EmfaticUIPlugin.getDefault().getBundle().getSymbolicName();
    }

    public static Image getImage(String name) {
        return EmfaticUIPlugin.getDefault().getCachedImage(name);
    }

    protected Image getCachedImage(String key) {
        if (key == null) {
            return null;
        }
        Image g = this.imageRegistry.get(key);
        if (g != null) {
            return g;
        }
        ImageDescriptor d = ImageDescriptor.createFromURL((URL)this.getBundle().getEntry("icons/" + key + ".gif"));
        if (d == null) {
            return null;
        }
        if (d.equals(ImageDescriptor.getMissingImageDescriptor())) {
            return null;
        }
        g = d.createImage();
        this.imageRegistry.put(key, g);
        return g;
    }

    public static ImageDescriptor getImageDescriptor(String name) {
        String iconPath = "icons/";
        try {
            URL installURL = EmfaticUIPlugin.getDefault().getBundle().getEntry("/");
            URL url = new URL(installURL, String.valueOf(iconPath) + name + ".gif");
            return ImageDescriptor.createFromURL((URL)url);
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }
}

