/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p3order;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.p3order.GraphInfoHolder;
import org.eclipse.elk.alg.layered.p3order.counting.IInitializable;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.options.PortSide;

public class LayerSweepTypeDecider
implements IInitializable {
    private NodeInfo[][] nodeInfo;
    private GraphInfoHolder graphData;

    public LayerSweepTypeDecider(GraphInfoHolder graphData) {
        this.graphData = graphData;
        this.nodeInfo = new NodeInfo[graphData.currentNodeOrder().length][];
    }

    public boolean useBottomUp() {
        double normalized;
        double boundary = (Double)this.graphData.lGraph().getProperty(LayeredOptions.CROSSING_MINIMIZATION_HIERARCHICAL_SWEEPINESS);
        if (this.bottomUpForced(boundary) || this.rootNode() || this.fixedPortOrder() || this.fewerThanTwoInOutEdges()) {
            return true;
        }
        if (this.graphData.crossMinDeterministic()) {
            return false;
        }
        int pathsToRandom = 0;
        int pathsToHierarchical = 0;
        ArrayList<LNode> nsPortDummies = new ArrayList<LNode>();
        LNode[][] lNodeArray = this.graphData.currentNodeOrder();
        int n = lNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            LNode[] layer;
            LNode[] lNodeArray2 = layer = lNodeArray[n2];
            int n3 = layer.length;
            int n4 = 0;
            while (n4 < n3) {
                LNode node = lNodeArray2[n4];
                if (this.isNorthSouthDummy(node)) {
                    nsPortDummies.add(node);
                } else {
                    NodeInfo currentNode = this.nodeInfoFor(node);
                    if (this.isExternalPortDummy(node)) {
                        currentNode.hierarchicalInfluence = 1;
                        if (this.isEasternDummy(node)) {
                            pathsToHierarchical += currentNode.connectedEdges;
                        }
                    } else if (this.hasNoWesternPorts(node)) {
                        currentNode.randomInfluence = 1;
                    } else if (this.hasNoEasternPorts(node)) {
                        pathsToRandom += currentNode.connectedEdges;
                    }
                    for (LEdge edge : node.getOutgoingEdges()) {
                        pathsToRandom += currentNode.randomInfluence;
                        pathsToHierarchical += currentNode.hierarchicalInfluence;
                        this.transferInfoToTarget(currentNode, edge);
                    }
                    Iterable northSouthPorts = Iterables.concat(node.getPortSideView(PortSide.NORTH), node.getPortSideView(PortSide.SOUTH));
                    for (LPort port : northSouthPorts) {
                        LNode nsDummy = (LNode)((Object)port.getProperty(InternalProperties.PORT_DUMMY));
                        if (nsDummy == null) continue;
                        pathsToRandom += currentNode.randomInfluence;
                        pathsToHierarchical += currentNode.hierarchicalInfluence;
                        this.transferInfoTo(currentNode, nsDummy);
                    }
                }
                ++n4;
            }
            for (LNode node : nsPortDummies) {
                NodeInfo currentNode = this.nodeInfoFor(node);
                for (LEdge edge : node.getOutgoingEdges()) {
                    pathsToRandom += currentNode.randomInfluence;
                    pathsToHierarchical += currentNode.hierarchicalInfluence;
                    this.transferInfoToTarget(currentNode, edge);
                }
            }
            nsPortDummies.clear();
            ++n2;
        }
        double allPaths = pathsToRandom + pathsToHierarchical;
        double d = normalized = allPaths == 0.0 ? Double.POSITIVE_INFINITY : (double)(pathsToRandom - pathsToHierarchical) / allPaths;
        return normalized >= boundary;
    }

    private boolean fixedPortOrder() {
        return ((PortConstraints)this.graphData.parent().getProperty(LayeredOptions.PORT_CONSTRAINTS)).isOrderFixed();
    }

    private void transferInfoToTarget(NodeInfo currentNode, LEdge edge) {
        LNode target = this.targetNode(edge);
        this.transferInfoTo(currentNode, target);
    }

    private void transferInfoTo(NodeInfo currentNode, LNode target) {
        NodeInfo targetNodeInfo = this.nodeInfoFor(target);
        targetNodeInfo.transfer(currentNode);
        ++targetNodeInfo.connectedEdges;
    }

    private boolean fewerThanTwoInOutEdges() {
        return this.graphData.parent().getPortSideView(PortSide.EAST).size() < 2 && this.graphData.parent().getPortSideView(PortSide.WEST).size() < 2;
    }

    private boolean rootNode() {
        return !this.graphData.hasParent();
    }

    private boolean bottomUpForced(double boundary) {
        return boundary < -1.0;
    }

    private LNode targetNode(LEdge edge) {
        return edge.getTarget().getNode();
    }

    private boolean hasNoEasternPorts(LNode node) {
        List<LPort> eastPorts = node.getPortSideView(PortSide.EAST);
        return eastPorts.isEmpty() || !Iterables.any(eastPorts, p -> p.getConnectedEdges().iterator().hasNext());
    }

    private boolean hasNoWesternPorts(LNode node) {
        List<LPort> westPorts = node.getPortSideView(PortSide.WEST);
        return westPorts.isEmpty() || !Iterables.any(westPorts, p -> p.getConnectedEdges().iterator().hasNext());
    }

    private boolean isExternalPortDummy(LNode node) {
        return node.getType() == LNode.NodeType.EXTERNAL_PORT;
    }

    private boolean isNorthSouthDummy(LNode node) {
        return node.getType() == LNode.NodeType.NORTH_SOUTH_PORT;
    }

    private boolean isEasternDummy(LNode node) {
        return this.originPort(node).getSide() == PortSide.EAST;
    }

    private LPort originPort(LNode node) {
        return (LPort)((Object)node.getProperty(InternalProperties.ORIGIN));
    }

    private NodeInfo nodeInfoFor(LNode n) {
        return this.nodeInfo[n.getLayer().id][n.id];
    }

    @Override
    public void initAtLayerLevel(int l, LNode[][] nodeOrder) {
        nodeOrder[l][0].getLayer().id = l;
        this.nodeInfo[l] = new NodeInfo[nodeOrder[l].length];
    }

    @Override
    public void initAtNodeLevel(int l, int n, LNode[][] nodeOrder) {
        LNode node = nodeOrder[l][n];
        node.id = n;
        this.nodeInfo[l][n] = new NodeInfo();
    }

    static class NodeInfo {
        private int connectedEdges;
        private int hierarchicalInfluence;
        private int randomInfluence;

        NodeInfo() {
        }

        public void transfer(NodeInfo nodeInfo) {
            this.hierarchicalInfluence += nodeInfo.hierarchicalInfluence;
            this.randomInfluence += nodeInfo.randomInfluence;
            this.connectedEdges += nodeInfo.connectedEdges;
        }

        public String toString() {
            return "NodeInfo [connectedEdges=" + this.connectedEdges + ", hierarchicalInfluence=" + this.hierarchicalInfluence + ", randomInfluence=" + this.randomInfluence + "]";
        }
    }
}

