/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.radial.p2routing;

import org.eclipse.elk.alg.radial.InternalProperties;
import org.eclipse.elk.alg.radial.RadialLayoutPhases;
import org.eclipse.elk.core.alg.ILayoutPhase;
import org.eclipse.elk.core.alg.LayoutProcessorConfiguration;
import org.eclipse.elk.core.math.ElkMath;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.graph.ElkConnectableShape;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkEdgeSection;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.ElkPort;
import org.eclipse.elk.graph.util.ElkGraphUtil;

public class StraightLineEdgeRouter
implements ILayoutPhase<RadialLayoutPhases, ElkNode> {
    public void process(ElkNode graph, IElkProgressMonitor progressMonitor) {
        ElkNode root = (ElkNode)graph.getProperty(InternalProperties.ROOT_NODE);
        this.routeEdges(root);
    }

    public void routeEdges(ElkNode node) {
        for (ElkEdge edge : ElkGraphUtil.allOutgoingEdges((ElkNode)node)) {
            if (edge.getSources().get(0) instanceof ElkPort) continue;
            ElkNode target = ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)((ElkConnectableShape)edge.getTargets().get(0)));
            if (edge.isHierarchical()) continue;
            double sourceX = node.getX() + node.getWidth() / 2.0;
            double sourceY = node.getY() + node.getHeight() / 2.0;
            double targetX = target.getX() + target.getWidth() / 2.0;
            double targetY = target.getY() + target.getHeight() / 2.0;
            KVector vector = new KVector();
            vector.x = targetX - sourceX;
            vector.y = targetY - sourceY;
            KVector sourceClip = new KVector(vector.x, vector.y);
            ElkMath.clipVector((KVector)sourceClip, (double)node.getWidth(), (double)node.getHeight());
            vector.x -= sourceClip.x;
            vector.y -= sourceClip.y;
            sourceX = targetX - vector.x;
            sourceY = targetY - vector.y;
            KVector targetClip = new KVector(vector.x, vector.y);
            ElkMath.clipVector((KVector)targetClip, (double)target.getWidth(), (double)target.getHeight());
            vector.x -= targetClip.x;
            vector.y -= targetClip.y;
            targetX = sourceX + vector.x;
            targetY = sourceY + vector.y;
            ElkEdgeSection section = ElkGraphUtil.firstEdgeSection((ElkEdge)edge, (boolean)true, (boolean)true);
            section.setStartLocation(sourceX, sourceY);
            section.setEndLocation(targetX, targetY);
            this.routeEdges(target);
        }
    }

    public LayoutProcessorConfiguration<RadialLayoutPhases, ElkNode> getLayoutProcessorConfiguration(ElkNode graph) {
        return null;
    }
}

