/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate.preserveorder;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.OrderingStrategy;
import org.eclipse.elk.core.options.PortSide;

public class ModelOrderPortComparator
implements Comparator<LPort> {
    private final Map<LNode, Integer> targetNodeModelOrder;
    private boolean portModelOrder;
    private LNode[] previousLayer;
    private OrderingStrategy strategy;
    private HashMap<LPort, HashSet<LPort>> biggerThan = new HashMap();
    private HashMap<LPort, HashSet<LPort>> smallerThan = new HashMap();

    public ModelOrderPortComparator(Layer previousLayer, OrderingStrategy strategy, Map<LNode, Integer> targetNodeModelOrder, boolean portModelOrder) {
        this.previousLayer = new LNode[previousLayer.getNodes().size()];
        this.strategy = strategy;
        previousLayer.getNodes().toArray(this.previousLayer);
        this.targetNodeModelOrder = targetNodeModelOrder;
        this.portModelOrder = portModelOrder;
    }

    public ModelOrderPortComparator(LNode[] previousLayer, OrderingStrategy strategy, Map<LNode, Integer> targetNodeModelOrder, boolean portModelOrder) {
        this.previousLayer = previousLayer;
        this.strategy = strategy;
        this.targetNodeModelOrder = targetNodeModelOrder;
        this.portModelOrder = portModelOrder;
    }

    @Override
    public int compare(LPort originalP1, LPort originalP2) {
        LPort p1 = originalP1;
        LPort p2 = originalP2;
        if (!this.biggerThan.containsKey((Object)p1)) {
            this.biggerThan.put(p1, new HashSet());
        } else if (this.biggerThan.get((Object)p1).contains((Object)p2)) {
            return 1;
        }
        if (!this.biggerThan.containsKey((Object)p2)) {
            this.biggerThan.put(p2, new HashSet());
        } else if (this.biggerThan.get((Object)p2).contains((Object)p1)) {
            return -1;
        }
        if (!this.smallerThan.containsKey((Object)p1)) {
            this.smallerThan.put(p1, new HashSet());
        } else if (this.smallerThan.get((Object)p1).contains((Object)p2)) {
            return -1;
        }
        if (!this.smallerThan.containsKey((Object)p2)) {
            this.smallerThan.put(p2, new HashSet());
        } else if (this.biggerThan.get((Object)p2).contains((Object)p1)) {
            return 1;
        }
        if (p1.getSide() != p2.getSide()) {
            int result = new PortSideComparator().compare(p1.getSide(), p2.getSide());
            if (result > 0) {
                this.updateBiggerAndSmallerAssociations(p1, p2, 1);
            } else {
                this.updateBiggerAndSmallerAssociations(p2, p1, 1);
            }
            return result;
        }
        int reverseOrder = 1;
        if (!p1.getIncomingEdges().isEmpty() && !p2.getIncomingEdges().isEmpty()) {
            int result;
            Layer previousLayer;
            int inPreviousLayer;
            LNode p2Node;
            if (p1.getSide() == PortSide.WEST && p2.getSide() == PortSide.WEST || p1.getSide() == PortSide.NORTH && p2.getSide() == PortSide.NORTH || p1.getSide() == PortSide.SOUTH && p2.getSide() == PortSide.SOUTH) {
                reverseOrder = -reverseOrder;
            }
            LPort p1SourcePort = p1.getIncomingEdges().get(0).getSource();
            LPort p2SourcePort = p2.getIncomingEdges().get(0).getSource();
            LNode p1Node = p1SourcePort.getNode();
            if (((Object)((Object)p1Node)).equals((Object)(p2Node = p2SourcePort.getNode()))) {
                for (LPort port : p1Node.getPorts()) {
                    if (((Object)((Object)p1SourcePort)).equals((Object)port)) {
                        this.updateBiggerAndSmallerAssociations(p2, p1, reverseOrder);
                        return -reverseOrder;
                    }
                    if (!((Object)((Object)p2SourcePort)).equals((Object)port)) continue;
                    this.updateBiggerAndSmallerAssociations(p1, p2, reverseOrder);
                    return reverseOrder;
                }
            }
            if (p1SourcePort.getNode().getType() == LNode.NodeType.LONG_EDGE && p2SourcePort.getNode().getType() == LNode.NodeType.LONG_EDGE && p1Node.getLayer().id == p2Node.getLayer().id && p1Node.getLayer().id == p1.getNode().getLayer().id && (inPreviousLayer = this.checkReferenceLayer(previousLayer = p1Node.getLayer(), p1Node, p2Node, p1, p2)) != 0) {
                if (p1.getSide() == PortSide.EAST && p2.getSide() == PortSide.EAST) {
                    reverseOrder = -reverseOrder;
                }
                if (inPreviousLayer > 0) {
                    this.updateBiggerAndSmallerAssociations(p1, p2, reverseOrder);
                    return reverseOrder;
                }
                this.updateBiggerAndSmallerAssociations(p2, p1, reverseOrder);
                return -reverseOrder;
            }
            int inPreviousLayer2 = this.checkReferenceLayer(Arrays.stream(this.previousLayer).collect(Collectors.toList()), p1Node, p2Node, p1, p2);
            if (inPreviousLayer2 != 0) {
                if (inPreviousLayer2 > 0) {
                    this.updateBiggerAndSmallerAssociations(p1, p2, reverseOrder);
                    return reverseOrder;
                }
                this.updateBiggerAndSmallerAssociations(p2, p1, reverseOrder);
                return -reverseOrder;
            }
            if (this.portModelOrder && (result = this.checkPortModelOrder(p1, p2)) != 0) {
                if (result > 0) {
                    this.updateBiggerAndSmallerAssociations(p1, p2, reverseOrder);
                    return reverseOrder;
                }
                this.updateBiggerAndSmallerAssociations(p2, p1, reverseOrder);
                return -reverseOrder;
            }
        }
        if (!p1.getOutgoingEdges().isEmpty() && !p2.getOutgoingEdges().isEmpty()) {
            int result;
            if (p1.getSide() == PortSide.WEST && p2.getSide() == PortSide.WEST || p1.getSide() == PortSide.SOUTH && p2.getSide() == PortSide.SOUTH) {
                reverseOrder = -reverseOrder;
            }
            LNode p1TargetNode = (LNode)((Object)p1.getProperty(InternalProperties.LONG_EDGE_TARGET_NODE));
            LNode p2TargetNode = (LNode)((Object)p2.getProperty(InternalProperties.LONG_EDGE_TARGET_NODE));
            if (this.strategy == OrderingStrategy.PREFER_NODES && p1TargetNode != null && p2TargetNode != null && p1TargetNode.hasProperty(InternalProperties.MODEL_ORDER) && p2TargetNode.hasProperty(InternalProperties.MODEL_ORDER)) {
                int p2MO;
                int p1MO = (Integer)p1TargetNode.getProperty(InternalProperties.MODEL_ORDER);
                if (p1MO > (p2MO = ((Integer)p2TargetNode.getProperty(InternalProperties.MODEL_ORDER)).intValue())) {
                    this.updateBiggerAndSmallerAssociations(p1, p2, reverseOrder);
                    return reverseOrder;
                }
                this.updateBiggerAndSmallerAssociations(p2, p1, reverseOrder);
                return -reverseOrder;
            }
            if (this.portModelOrder && (result = this.checkPortModelOrder(p1, p2)) != 0) {
                if (result > 0) {
                    this.updateBiggerAndSmallerAssociations(p1, p2, reverseOrder);
                    return reverseOrder;
                }
                this.updateBiggerAndSmallerAssociations(p2, p1, reverseOrder);
                return -reverseOrder;
            }
            int p1Order = 0;
            int p2Order = 0;
            if (p1.getOutgoingEdges().get(0).hasProperty(InternalProperties.MODEL_ORDER)) {
                p1Order = (Integer)p1.getOutgoingEdges().get(0).getProperty(InternalProperties.MODEL_ORDER);
            }
            if (p2.getOutgoingEdges().get(0).hasProperty(InternalProperties.MODEL_ORDER)) {
                p2Order = (Integer)p2.getOutgoingEdges().get(0).getProperty(InternalProperties.MODEL_ORDER);
            }
            if (p1TargetNode != null && ((Object)((Object)p1TargetNode)).equals((Object)p2TargetNode)) {
                if (p1Order > p2Order) {
                    this.updateBiggerAndSmallerAssociations(p1, p2, reverseOrder);
                    return reverseOrder;
                }
                this.updateBiggerAndSmallerAssociations(p2, p1, reverseOrder);
                return -reverseOrder;
            }
            if (this.targetNodeModelOrder != null) {
                if (this.targetNodeModelOrder.containsKey((Object)p1TargetNode)) {
                    p1Order = this.targetNodeModelOrder.get((Object)p1TargetNode);
                }
                if (this.targetNodeModelOrder.containsKey((Object)p2TargetNode)) {
                    p2Order = this.targetNodeModelOrder.get((Object)p2TargetNode);
                }
            }
            if (p1Order > p2Order) {
                this.updateBiggerAndSmallerAssociations(p1, p2, reverseOrder);
                return reverseOrder;
            }
            this.updateBiggerAndSmallerAssociations(p2, p1, reverseOrder);
            return -reverseOrder;
        }
        if (!p1.getIncomingEdges().isEmpty() && !p2.getOutgoingEdges().isEmpty()) {
            this.updateBiggerAndSmallerAssociations(p1, p2, reverseOrder);
            return 1;
        }
        if (!p1.getOutgoingEdges().isEmpty() && !p2.getIncomingEdges().isEmpty()) {
            this.updateBiggerAndSmallerAssociations(p2, p1, reverseOrder);
            return -1;
        }
        if (p1.hasProperty(InternalProperties.MODEL_ORDER) && p2.hasProperty(InternalProperties.MODEL_ORDER)) {
            int p1MO = (Integer)p1.getProperty(InternalProperties.MODEL_ORDER);
            int p2MO = (Integer)p2.getProperty(InternalProperties.MODEL_ORDER);
            if (p1.getSide() == PortSide.WEST && p2.getSide() == PortSide.WEST || p1.getSide() == PortSide.SOUTH && p2.getSide() == PortSide.SOUTH) {
                reverseOrder = -reverseOrder;
            }
            if (p1MO > p2MO) {
                this.updateBiggerAndSmallerAssociations(p1, p2, reverseOrder);
                return reverseOrder;
            }
            this.updateBiggerAndSmallerAssociations(p2, p1, reverseOrder);
            return -reverseOrder;
        }
        this.updateBiggerAndSmallerAssociations(p2, p1, reverseOrder);
        return -reverseOrder;
    }

    public int checkPortModelOrder(LPort p1, LPort p2) {
        if (p1.hasProperty(InternalProperties.MODEL_ORDER) && p2.hasProperty(InternalProperties.MODEL_ORDER)) {
            return Integer.compare((Integer)p1.getProperty(InternalProperties.MODEL_ORDER), (Integer)p2.getProperty(InternalProperties.MODEL_ORDER));
        }
        return 0;
    }

    private void updateBiggerAndSmallerAssociations(LPort biggerOri, LPort smallerOri, int reverseOrder) {
        LPort bigger = biggerOri;
        LPort smaller = smallerOri;
        if (reverseOrder < 0) {
            bigger = smallerOri;
            smaller = biggerOri;
        }
        HashSet<LPort> biggerPortBiggerThan = this.biggerThan.get((Object)bigger);
        HashSet<LPort> smallerPortBiggerThan = this.biggerThan.get((Object)smaller);
        HashSet<LPort> biggerPortSmallerThan = this.smallerThan.get((Object)bigger);
        HashSet<LPort> smallerPortSmallerThan = this.smallerThan.get((Object)smaller);
        biggerPortBiggerThan.add(smaller);
        smallerPortSmallerThan.add(bigger);
        for (LPort verySmall : smallerPortBiggerThan) {
            biggerPortBiggerThan.add(verySmall);
            this.smallerThan.get((Object)verySmall).add(bigger);
            this.smallerThan.get((Object)verySmall).addAll(biggerPortSmallerThan);
        }
        for (LPort veryBig : biggerPortSmallerThan) {
            smallerPortSmallerThan.add(veryBig);
            this.biggerThan.get((Object)veryBig).add(smaller);
            this.biggerThan.get((Object)veryBig).addAll(smallerPortBiggerThan);
        }
    }

    private int checkReferenceLayer(Iterable<LNode> layer, LNode p1Node, LNode p2Node, LPort p1, LPort p2) {
        for (LNode node : layer) {
            if (((Object)((Object)node)).equals((Object)p1Node)) {
                return -1;
            }
            if (!((Object)((Object)node)).equals((Object)p2Node)) continue;
            return 1;
        }
        return 0;
    }

    public void clearTransitiveOrdering() {
        this.biggerThan = new HashMap();
        this.smallerThan = new HashMap();
    }

    private class PortSideComparator
    implements Comparator<PortSide> {
        private PortSideComparator() {
        }

        @Override
        public int compare(PortSide ps1, PortSide ps2) {
            return Integer.compare(ps1.ordinal(), ps2.ordinal());
        }
    }
}

