/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.compare;

import org.eclipse.egerrit.internal.model.RevisionInfo;
import org.eclipse.egerrit.internal.ui.EGerritImages;
import org.eclipse.egerrit.internal.ui.compare.GerritMultipleInput;
import org.eclipse.egerrit.internal.ui.utils.UIUtils;
import org.eclipse.jface.action.Action;

class SwitchPatchAction
extends Action {
    private GerritMultipleInput input;
    private boolean leftSide;
    private String inputToSwitchTo;

    SwitchPatchAction(GerritMultipleInput gerritMultipleInput, RevisionInfo revision, boolean left) {
        this.input = gerritMultipleInput;
        this.leftSide = left;
        this.inputToSwitchTo = revision.getId();
        boolean hasComments = revision.isCommented();
        this.setText(UIUtils.revisionToString(revision));
        if (hasComments) {
            this.setImageDescriptor(EGerritImages.getDescriptor("icons/showComments.gif"));
        }
    }

    SwitchPatchAction(GerritMultipleInput gerritMultipleInput, String target, boolean left) {
        super(target);
        this.input = gerritMultipleInput;
        this.leftSide = left;
        this.inputToSwitchTo = target;
    }

    public void run() {
        if (this.leftSide) {
            this.input.switchInputs(this.inputToSwitchTo, null);
        } else {
            this.input.switchInputs(null, this.inputToSwitchTo);
        }
    }
}

