/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.dashboard.ui.views;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egerrit.internal.core.EGerritCorePlugin;
import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.core.GerritCredentials;
import org.eclipse.egerrit.internal.core.GerritFactory;
import org.eclipse.egerrit.internal.core.GerritRepository;
import org.eclipse.egerrit.internal.core.GerritServerInformation;
import org.eclipse.egerrit.internal.core.ServersStore;
import org.eclipse.egerrit.internal.core.command.ChangeOption;
import org.eclipse.egerrit.internal.core.command.ChangeStatus;
import org.eclipse.egerrit.internal.core.command.QueryChangesCommand;
import org.eclipse.egerrit.internal.core.exception.EGerritException;
import org.eclipse.egerrit.internal.dashboard.core.GerritQueryException;
import org.eclipse.egerrit.internal.dashboard.ui.GerritUi;
import org.eclipse.egerrit.internal.dashboard.ui.completion.SearchContentProposalAdapter;
import org.eclipse.egerrit.internal.dashboard.ui.completion.SearchContentProposalProvider;
import org.eclipse.egerrit.internal.dashboard.ui.model.UIReviewTable;
import org.eclipse.egerrit.internal.dashboard.ui.preferences.Utils;
import org.eclipse.egerrit.internal.dashboard.ui.utils.SelectionDialog;
import org.eclipse.egerrit.internal.dashboard.ui.utils.UIUtils;
import org.eclipse.egerrit.internal.dashboard.ui.views.AddOneServerDialog;
import org.eclipse.egerrit.internal.dashboard.ui.views.ChangeIdExtractor;
import org.eclipse.egerrit.internal.dashboard.ui.views.Messages;
import org.eclipse.egerrit.internal.dashboard.ui.views.VoteToolTipHandler;
import org.eclipse.egerrit.internal.dashboard.utils.GerritServerUtility;
import org.eclipse.egerrit.internal.model.ChangeInfo;
import org.eclipse.egerrit.internal.model.ModelFactory;
import org.eclipse.egerrit.internal.model.Reviews;
import org.eclipse.egerrit.internal.ui.editors.ChangeDetailEditor;
import org.eclipse.egerrit.internal.ui.editors.model.ChangeDetailEditorInput;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GerritTableView
extends ViewPart {
    private static Logger logger = LoggerFactory.getLogger(GerritTableView.class);
    public static final String VIEW_ID = "org.eclipse.egerrit.dashboard.ui.views.GerritTableView";
    private static final int SEARCH_WIDTH = 350;
    private static final int SEARCH_SIZE_MENU_LIST = 4;
    private static final String TITLE = "Gerrit Server ";
    private static final String CHECKED_IMAGE = "personSignIn.png";
    private static final String ANONYMOUS_IMAGE = "personAnonymous.png";
    private static final String INVALID_IMAGE = "personInvalid.png";
    private static final String JOB_FAMILY = "DASHBOARD_UI";
    private AddOneServerDialog fAddOneServerDialog = null;
    private static ImageRegistry fImageRegistry = new ImageRegistry();
    private Composite fTopComposite = null;
    private GerritServerInformation defaultServerInfo = null;
    private static GerritTableView rtv;
    private CLabel fRepositoryVersionResulLabel;
    private Label fReviewsTotalLabel;
    private Combo fSearchTextBox;
    private Button fSearchRequestBtn;
    private Set<String> fRequestList = new LinkedHashSet<String>();
    private TableViewer fViewer;
    private GerritServerUtility fServerUtil = GerritServerUtility.getInstance();
    private List<GerritServerInformation> fMapRepoServer = null;
    private Action doubleClickAction;
    private final LinkedHashSet<Job> fJobs = new LinkedHashSet();
    private GerritClient gerritClient = null;
    private Composite parentComposite;
    private Composite searchSection;
    private UIReviewTable reviewTable;
    private SearchContentProposalProvider searchProposalProvider = new SearchContentProposalProvider(() -> {
        this.initializeDefaultServer();
        if (this.defaultServerInfo != null) {
            this.connectToServer(this.defaultServerInfo);
        }
    });

    static {
        String iconPath = "icons/view16/";
        fImageRegistry.put(CHECKED_IMAGE, GerritUi.getImageDescriptor(String.valueOf(iconPath) + CHECKED_IMAGE));
        fImageRegistry.put(ANONYMOUS_IMAGE, GerritUi.getImageDescriptor(String.valueOf(iconPath) + ANONYMOUS_IMAGE));
        fImageRegistry.put(INVALID_IMAGE, GerritUi.getImageDescriptor(String.valueOf(iconPath) + INVALID_IMAGE));
        rtv = null;
    }

    public GerritTableView() {
        rtv = this;
    }

    public void dispose() {
        this.cleanJobs();
        if (this.reviewTable != null) {
            this.reviewTable.dispose();
        }
        rtv = null;
    }

    private void cleanJobs() {
        for (Job job : this.fJobs) {
            job.sleep();
            job.cancel();
        }
        this.fJobs.clear();
    }

    private void refresh(Reviews reviews) {
        Display.getDefault().asyncExec(() -> {
            if (!this.fViewer.getTable().isDisposed()) {
                this.fViewer.setInput((Object)reviews);
                this.setReviewsTotalResultLabel(Integer.toString(reviews.getAllReviews().size()));
                this.searchSection.layout(true);
            }
        });
    }

    public void createPartControl(Composite aParent) {
        this.parentComposite = aParent;
        if (this.fServerUtil.getLastSavedGerritServer() == null) {
            this.createEmptyPage(ServersStore.getAllServers().isEmpty());
        } else {
            this.createReviewList(null);
        }
    }

    private void createEmptyPage(boolean enterNewServer) {
        this.removeExistingWidgets();
        Color background = this.parentComposite.getDisplay().getSystemColor(25);
        Composite composite = new Composite(this.parentComposite, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setBackground(background);
        Link link = new Link(composite, 0);
        if (enterNewServer) {
            link.setText(Messages.Welcome_No_Server);
            link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    GerritTableView.this.addOrChangeServerThenLoad();
                }
            });
        } else {
            link.setText(Messages.Welcome_Pick_Server);
            link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    GerritServerInformation server = GerritTableView.this.askUserToSelectRepo(ServersStore.getAllServers());
                    if (server != null) {
                        GerritTableView.this.fServerUtil.saveLastGerritServer(server);
                        GerritTableView.this.processCommands(ChangeStatus.OPEN.getValue());
                    }
                }
            });
        }
        link.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
        link.setBackground(background);
    }

    private void createReviewList(String[] voteColumns) {
        String[] reviewVoteColumns = voteColumns == null ? new String[]{} : (String[])voteColumns.clone();
        this.removeExistingWidgets();
        this.fTopComposite = new Composite(this.parentComposite, 0);
        this.fTopComposite.setLayout((Layout)new GridLayout(1, true));
        this.searchSection = this.createSearchSection(this.fTopComposite);
        this.searchSection.setLayoutData((Object)new GridData(4, 128, true, false));
        this.createTable(reviewVoteColumns);
    }

    private void createTable(String[] voteColumns) {
        if (this.fViewer != null) {
            this.fViewer.getControl().dispose();
            this.fViewer = null;
        }
        Display.getDefault().syncExec(() -> {
            this.reviewTable = new UIReviewTable();
            this.reviewTable.createTableViewerSection(this.fTopComposite, voteColumns).setLayoutData((Object)new GridData(4, 4, true, true));
            this.fViewer = this.reviewTable.getViewer();
            this.getSite().setSelectionProvider((ISelectionProvider)this.fViewer);
            this.makeActions();
            this.hookDoubleClickAction();
            this.parentComposite.layout(true);
            VoteToolTipHandler voteHandler = new VoteToolTipHandler(this.fTopComposite.getShell(), rtv);
            voteHandler.connect();
        });
    }

    private void removeExistingWidgets() {
        Control[] controlArray = this.parentComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
    }

    private Composite createSearchSection(Composite aParent) {
        Composite searchComposite = new Composite(aParent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        layout.marginTop = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.makeColumnsEqualWidth = false;
        searchComposite.setLayout((Layout)layout);
        this.fRepositoryVersionResulLabel = new CLabel(searchComposite, 0x2000000);
        GridData labelGridData = new GridData(16384, 0x1000000, false, false);
        this.fRepositoryVersionResulLabel.setLayoutData((Object)labelGridData);
        this.fRepositoryVersionResulLabel.addMouseListener((MouseListener)this.connectToServerListener());
        this.fReviewsTotalLabel = new Label(searchComposite, 0);
        GridData totalLabelGridData = new GridData(16384, 0x1000000, false, false);
        totalLabelGridData.horizontalIndent = 10;
        this.fReviewsTotalLabel.setLayoutData((Object)totalLabelGridData);
        this.fSearchTextBox = new Combo(searchComposite, 0);
        new SearchContentProposalAdapter(this.fSearchTextBox, this.searchProposalProvider);
        GridData searchGridData = new GridData(131072, 0x1000000, true, false);
        searchGridData.widthHint = 350;
        searchGridData.minimumWidth = 100;
        this.fSearchTextBox.setLayoutData((Object)searchGridData);
        this.fSearchTextBox.setToolTipText(Messages.GerritTableView_tooltipSearch);
        this.fRequestList = this.fServerUtil.getListLastCommands();
        this.setSearchText("");
        this.fSearchTextBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Object obj = e.getSource();
                if (obj instanceof Combo) {
                    Combo combo = (Combo)obj;
                    GerritTableView.this.processCommands(combo.getText());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                if (GerritTableView.this.fSearchTextBox.getText().trim().length() > 0) {
                    GerritTableView.this.processCommands(GerritTableView.this.fSearchTextBox.getText());
                }
            }
        });
        this.fSearchRequestBtn = new Button(searchComposite, 0);
        this.fSearchRequestBtn.setText(Messages.GerritTableView_search);
        this.fSearchRequestBtn.setLayoutData((Object)new GridData(131072, 0, false, false));
        this.fSearchRequestBtn.addListener(13, event -> this.processCommands(this.fSearchTextBox.getText()));
        this.adaptSearchSectionLayout(searchComposite);
        return searchComposite;
    }

    private void adaptSearchSectionLayout(final Composite composite) {
        composite.addControlListener(new ControlListener(){
            boolean searchOnly = false;

            public void controlResized(ControlEvent e) {
                Rectangle size = composite.getClientArea();
                if (size.width > 300 && this.searchOnly) {
                    ((GridData)((GerritTableView)GerritTableView.this).fRepositoryVersionResulLabel.getLayoutData()).exclude = false;
                    ((GridData)((GerritTableView)GerritTableView.this).fReviewsTotalLabel.getLayoutData()).exclude = false;
                    ((GridData)((GerritTableView)GerritTableView.this).fSearchRequestBtn.getLayoutData()).exclude = false;
                    GerritTableView.this.fRepositoryVersionResulLabel.setVisible(true);
                    GerritTableView.this.fReviewsTotalLabel.setVisible(true);
                    GerritTableView.this.fSearchRequestBtn.setVisible(true);
                    this.searchOnly = false;
                    composite.layout(true);
                    return;
                }
                if (size.width < 300 && !this.searchOnly) {
                    ((GridData)((GerritTableView)GerritTableView.this).fRepositoryVersionResulLabel.getLayoutData()).exclude = true;
                    ((GridData)((GerritTableView)GerritTableView.this).fReviewsTotalLabel.getLayoutData()).exclude = true;
                    ((GridData)((GerritTableView)GerritTableView.this).fSearchRequestBtn.getLayoutData()).exclude = true;
                    GerritTableView.this.fRepositoryVersionResulLabel.setVisible(false);
                    GerritTableView.this.fReviewsTotalLabel.setVisible(false);
                    GerritTableView.this.fSearchRequestBtn.setVisible(false);
                    this.searchOnly = true;
                    composite.layout(true);
                    return;
                }
            }

            public void controlMoved(ControlEvent e) {
            }
        });
    }

    private MouseAdapter connectToServerListener() {
        return new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (GerritTableView.this.gerritClient == null || GerritTableView.this.gerritClient.getRepository().getServerInfo().isAnonymous()) {
                    GerritTableView.this.addOrChangeServerThenLoad();
                }
            }
        };
    }

    private void makeActions() {
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection selection = GerritTableView.this.fViewer.getSelection();
                if (!(selection instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                this.verifySelectionToOpen(structuredSelection);
            }

            private void verifySelectionToOpen(IStructuredSelection structuredSelection) {
                for (Object element : structuredSelection) {
                    if (!(element instanceof ChangeInfo)) continue;
                    this.openEditorWithInfo((ChangeInfo)element);
                }
            }

            private void openEditorWithInfo(ChangeInfo changeInfo) {
                IWorkbenchPage page = this.getActivePage();
                if (page != null) {
                    try {
                        ChangeDetailEditorInput input = new ChangeDetailEditorInput(GerritTableView.this.gerritClient, changeInfo);
                        IEditorPart reusedEditor = page.findEditor((IEditorInput)input);
                        page.openEditor((IEditorInput)input, "org.eclipse.egerrit.ui.editors.ChangeDetailEditor");
                        if (reusedEditor instanceof ChangeDetailEditor) {
                            ((ChangeDetailEditor)reusedEditor).refreshStatus();
                        }
                    }
                    catch (PartInitException e) {
                        EGerritCorePlugin.logError((String)(GerritTableView.this.gerritClient != null ? String.valueOf(GerritTableView.this.gerritClient.getRepository().formatGerritVersion()) + e.getMessage() : e.getMessage()));
                    }
                }
            }

            private IWorkbenchPage getActivePage() {
                IWorkbench workbench = GerritUi.getDefault().getWorkbench();
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                IWorkbenchPage page = null;
                if (window != null) {
                    page = workbench.getActiveWorkbenchWindow().getActivePage();
                }
                return page;
            }
        };
    }

    private void hookDoubleClickAction() {
        this.fViewer.addDoubleClickListener(event -> this.doubleClickAction.run());
    }

    public void setFocus() {
        this.parentComposite.setFocus();
    }

    public TableViewer getTableViewer() {
        return this.fViewer;
    }

    public static GerritTableView getActiveView(boolean forceOpen) {
        IViewPart viewPart = null;
        if (rtv != null) {
            return rtv;
        }
        if (!forceOpen) {
            return null;
        }
        IWorkbench workbench = GerritUi.getDefault().getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage page = null;
        if (window != null) {
            page = workbench.getActiveWorkbenchWindow().getActivePage();
        }
        if (page != null && (viewPart = page.findView(VIEW_ID)) == null) {
            try {
                viewPart = page.showView(VIEW_ID, null, 3);
            }
            catch (PartInitException e) {
                logger.warn(e.getMessage());
            }
            logger.debug("getActiveView() SHOULD (JUST) CREATED A NEW Table:" + viewPart);
        }
        return (GerritTableView)viewPart;
    }

    public void openView() {
        IWorkbench workbench = GerritUi.getDefault().getWorkbench();
        IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
        IViewPart viewPart = page.findView(VIEW_ID);
        if (viewPart == null) {
            try {
                page.showView(VIEW_ID);
            }
            catch (PartInitException e) {
                logger.warn(e.getMessage());
            }
        } else if (!page.isPartVisible((IWorkbenchPart)viewPart)) {
            page.bringToTop((IWorkbenchPart)viewPart);
        }
    }

    public void processCommands(String aQuery) {
        logger.debug("Process command :   " + aQuery);
        this.defaultServerInfo = null;
        String httpQuery = this.handleHttpInQuery(aQuery);
        this.initializeDefaultServer();
        if (this.defaultServerInfo == null) {
            UIUtils.showNoServerMessage();
            if (this.fAddOneServerDialog == null) {
                this.fAddOneServerDialog = new AddOneServerDialog();
                Display.getDefault().syncExec(() -> this.fAddOneServerDialog.promptForNewServer(true));
                this.defaultServerInfo = this.fAddOneServerDialog.getServer();
                this.fAddOneServerDialog = null;
                if (this.defaultServerInfo == null) {
                    logger.debug("No new server entered by the user. ");
                    return;
                }
            }
        }
        if (httpQuery != null && !"".equals(httpQuery)) {
            this.updateTable(this.defaultServerInfo, httpQuery);
        }
    }

    private void initializeDefaultServer() {
        GerritServerInformation lastServer;
        if (this.defaultServerInfo == null && (lastServer = this.fServerUtil.getLastSavedGerritServer()) != null) {
            this.defaultServerInfo = lastServer;
        }
        if (this.defaultServerInfo == null) {
            this.fMapRepoServer = ServersStore.getAllServers();
            if (this.fMapRepoServer.size() == 1) {
                this.defaultServerInfo = this.fMapRepoServer.get(0);
            } else if (this.fMapRepoServer.size() > 1) {
                this.defaultServerInfo = this.askUserToSelectRepo(ServersStore.getAllServers());
            }
        }
        if (this.defaultServerInfo != null) {
            this.fServerUtil.saveLastGerritServer(this.defaultServerInfo);
        }
    }

    private String handleHttpInQuery(String aQuery) {
        String latestQuery = aQuery;
        ChangeIdExtractor extractedData = new ChangeIdExtractor(aQuery);
        if (extractedData.getServer() != null) {
            this.selectServer(extractedData.getServer());
            latestQuery = extractedData.getChangeId() != null ? "change:" + extractedData.getChangeId() : ChangeStatus.OPEN.getValue();
        }
        return latestQuery;
    }

    private void selectServer(GerritServerInformation server) {
        List<GerritServerInformation> matches = this.findOrAddMatchingServers(server);
        if (matches.size() == 1) {
            this.defaultServerInfo = matches.get(0);
            return;
        }
        this.defaultServerInfo = this.askUserToSelectRepo(matches);
    }

    private List<GerritServerInformation> findOrAddMatchingServers(GerritServerInformation searched) {
        List knownServers = ServersStore.getAllServers();
        ArrayList<GerritServerInformation> matches = new ArrayList<GerritServerInformation>();
        ArrayList<GerritServerInformation> bestMatches = new ArrayList<GerritServerInformation>();
        for (GerritServerInformation candidate : knownServers) {
            if (!candidate.getServerURI().equals(searched.getServerURI())) continue;
            if (candidate.getUserName().equals(searched.getUserName())) {
                bestMatches.add(0, candidate);
                continue;
            }
            matches.add(candidate);
        }
        if (!bestMatches.isEmpty()) {
            return bestMatches;
        }
        if (matches.isEmpty()) {
            knownServers.add(searched);
            ServersStore.saveServers((List)knownServers);
            matches.add(searched);
        }
        return matches;
    }

    public void setStarred(ChangeInfo changeInfo, boolean starred) throws CoreException {
        if (this.defaultServerInfo == null) {
            UIUtils.showNoServerMessage();
        } else if (starred) {
            CompletableFuture.runAsync(() -> {
                try {
                    this.gerritClient.starChange(changeInfo).call();
                }
                catch (EGerritException e) {
                    EGerritCorePlugin.logInfo((String)(String.valueOf(this.gerritClient.getRepository().formatGerritVersion()) + e.getMessage()));
                }
            });
        } else {
            CompletableFuture.runAsync(() -> {
                try {
                    this.gerritClient.unstarChange(changeInfo).call();
                }
                catch (EGerritException e) {
                    EGerritCorePlugin.logError((String)(String.valueOf(this.gerritClient.getRepository().formatGerritVersion()) + e.getMessage()));
                }
            });
        }
    }

    private Version getlastGerritServerVersion() {
        Version version = null;
        GerritServerInformation lastSaved = this.fServerUtil.getLastSavedGerritServer();
        if (lastSaved != null) {
            this.defaultServerInfo = lastSaved;
        }
        if (this.defaultServerInfo == null) {
            Iterator<GerritServerInformation> iterator;
            this.fMapRepoServer = ServersStore.getAllServers();
            if (this.fMapRepoServer.size() == 1 && (iterator = this.fMapRepoServer.iterator()).hasNext()) {
                GerritServerInformation key;
                this.defaultServerInfo = key = iterator.next();
                this.fServerUtil.saveLastGerritServer(key);
            }
        }
        return version;
    }

    public boolean isGerritVersionBefore_2_5() {
        boolean ret = false;
        Version version = this.getlastGerritServerVersion();
        if (version != null && version.getMajor() >= 2 && version.getMinor() < 5) {
            ret = true;
        }
        return ret;
    }

    private void updateTable(final GerritServerInformation server, final String aQueryType) {
        this.createReviewList(null);
        String cmdMessage = NLS.bind((String)Messages.GerritTableView_commandMessage, (Object)server.getServerURI(), (Object)aQueryType);
        Job job = new Job(cmdMessage){

            public boolean belongsTo(Object aFamily) {
                return GerritTableView.JOB_FAMILY.equals(aFamily);
            }

            public IStatus run(IProgressMonitor aMonitor) {
                IStatus status = null;
                try {
                    status = GerritTableView.this.getReviews(server, aQueryType);
                    if (status.isOK()) {
                        Display.getDefault().syncExec(() -> GerritTableView.this.setSearchText(aQueryType));
                    }
                    status = Status.OK_STATUS;
                }
                catch (GerritQueryException e) {
                    status = e.getStatus();
                    logger.error(e.getMessage());
                }
                aMonitor.done();
                GerritTableView.this.fJobs.remove((Object)this);
                return status;
            }
        };
        this.cleanJobs();
        this.fJobs.add(job);
        job.setUser(true);
        job.schedule();
    }

    private void setSearchText(String aSt) {
        if (!this.fSearchTextBox.isDisposed()) {
            if (aSt != null && aSt != "") {
                String[] ar = this.fSearchTextBox.getItems();
                int index = this.findSearchBoxIndexCombo(aSt, ar);
                this.removeElementSearchComboList(ar, index);
                this.fRequestList.add(aSt.trim());
                this.fServerUtil.saveLastCommandList(this.fRequestList);
            }
            this.adjustSearchBox(aSt);
        }
    }

    private void removeElementSearchComboList(String[] ar, int index) {
        if (index != -1) {
            this.fRequestList.remove(ar[index]);
        } else if (this.fRequestList.size() > 4) {
            String obj = this.fRequestList.iterator().next();
            this.fRequestList.remove(obj);
        }
    }

    private int findSearchBoxIndexCombo(String aSt, String[] ar) {
        int index = -1;
        int i = 0;
        while (i < ar.length) {
            if (ar[i].equals(aSt.trim())) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    private void adjustSearchBox(String aSt) {
        this.fSearchTextBox.setItems(this.reverseOrder(this.fRequestList.toArray(new String[0])));
        if (aSt != null && aSt != "") {
            this.fSearchTextBox.select(0);
        } else {
            this.fSearchTextBox.setText("");
        }
    }

    private String[] reverseOrder(String[] aList) {
        int size = aList.length;
        int index = size - 1;
        String[] rev = new String[size];
        int i = 0;
        while (i < size) {
            rev[i] = aList[index--];
            ++i;
        }
        return rev;
    }

    private void displayInformation(String server, String st) {
        Display.getDefault().syncExec(() -> MessageDialog.openInformation(null, (String)NLS.bind((String)Messages.GerritTableView_information, (Object)server), (String)st));
    }

    private IStatus getReviews(GerritServerInformation repository, String queryType) throws GerritQueryException {
        if (!this.connectToServer(repository)) {
            return Status.CANCEL_STATUS;
        }
        if (!this.isQueryAuthorized(queryType)) {
            this.displayInformation(repository.getServerURI(), NLS.bind((String)Messages.GerritTableView_informationAnonymous, (Object)queryType));
            return Status.CANCEL_STATUS;
        }
        String queryString = queryType;
        IStatus ret = Status.OK_STATUS;
        Reviews shownReviews = ModelFactory.eINSTANCE.createReviews();
        if (this.gerritClient != null) {
            ChangeInfo[] loadedReviews = this.getReviewList(queryString);
            String[] columns = this.extractColumnNames(loadedReviews);
            Display.getDefault().syncExec(() -> this.createReviewList(columns));
            if (loadedReviews != null) {
                ChangeInfo[] changeInfoArray = loadedReviews;
                int n = loadedReviews.length;
                int n2 = 0;
                while (n2 < n) {
                    ChangeInfo review = changeInfoArray[n2];
                    shownReviews.getAllReviews().add((Object)review);
                    ++n2;
                }
            } else {
                shownReviews.getAllReviews().clear();
                ret = new Status(4, "org.eclipse.egerrit.core", "Error");
            }
            this.setRepositoryVersionLabel(this.defaultServerInfo.getName(), this.gerritClient.getRepository().getVersion().toString());
        } else {
            shownReviews.getAllReviews().clear();
            this.fServerUtil.resetLastGerritServer();
            this.setRepositoryVersionLabel(Messages.Invalid_server, Messages.No_Connection);
            ret = new Status(4, "org.eclipse.egerrit.core", "Error");
        }
        if (shownReviews.getAllReviews() != null) {
            this.refresh(shownReviews);
        }
        return ret;
    }

    private boolean connectToServer(GerritServerInformation repository) {
        URI uri = null;
        try {
            if (!repository.getServerURI().isEmpty()) {
                uri = new URI(repository.getServerURI());
            }
        }
        catch (URISyntaxException e) {
            EGerritCorePlugin.logError((String)(this.gerritClient != null ? String.valueOf(this.gerritClient.getRepository().formatGerritVersion()) + e.getMessage() : e.getMessage()));
        }
        if (uri != null) {
            String scheme = uri.getScheme();
            String host = uri.getHost();
            int port = uri.getPort();
            String path = uri.getPath();
            String user = repository.getUserName();
            String passwd = repository.getPassword();
            GerritCredentials creds = new GerritCredentials(user, passwd);
            GerritRepository gerritRepository = new GerritRepository(scheme, host, port, path);
            gerritRepository.setCredentials(creds);
            gerritRepository.setServerInfo(repository);
            gerritRepository.acceptSelfSignedCerts(repository.getSelfSigned());
            this.gerritClient = gerritRepository.instantiateGerrit();
            this.searchProposalProvider.setGerritClient(this.gerritClient);
            boolean connect = gerritRepository.connect();
            if (connect) {
                return this.showVersionError(gerritRepository);
            }
            if (gerritRepository.getStatus() == 401) {
                UIUtils.showErrorDialog(Messages.Server_connection_401_title, NLS.bind((String)Messages.Server_connection_401, (Object)gerritRepository.getPath()));
                return false;
            }
            return connect;
        }
        return false;
    }

    private boolean showVersionError(GerritRepository gerritRepository) {
        Version version = gerritRepository.getVersion();
        if (version == null) {
            UIUtils.showErrorDialog(Messages.Invalid_Credentials, "Server " + this.defaultServerInfo.getServerURI());
            return false;
        }
        if (version.equals((Object)GerritRepository.NO_VERSION)) {
            UIUtils.showErrorDialog(Messages.Unsupported_server_version_title, NLS.bind((String)Messages.Unsupported_server_version, (Object)GerritFactory.MINIMAL_VERSION));
            return false;
        }
        if (version.compareTo(GerritFactory.MINIMAL_VERSION) < 0) {
            UIUtils.showErrorDialog(Messages.Unsupported_Server_Version, NLS.bind((String)Messages.Unsupported_server_version, (Object)GerritFactory.MINIMAL_VERSION));
            return false;
        }
        return true;
    }

    private ChangeInfo[] getReviewList(String aQuery) throws GerritQueryException {
        ChangeInfo[] reviews = null;
        try {
            reviews = this.performQuery(aQuery, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (MalformedURLException e) {
            EGerritCorePlugin.logError((String)(this.gerritClient != null ? String.valueOf(this.gerritClient.getRepository().formatGerritVersion()) + e.getMessage() : e.getMessage()));
        }
        return reviews;
    }

    private ChangeInfo[] performQuery(String query, IProgressMonitor monitor) throws MalformedURLException {
        try {
            monitor.beginTask("Executing query", -1);
            ChangeInfo[] res = null;
            QueryChangesCommand command = this.gerritClient.queryChanges();
            command.addOption(new ChangeOption[]{ChangeOption.LABELS});
            command.addOption(new ChangeOption[]{ChangeOption.DETAILED_LABELS});
            command.addOption(new ChangeOption[]{ChangeOption.DETAILED_ACCOUNTS});
            command.addOption(new ChangeOption[]{ChangeOption.MESSAGES});
            command.addOption(new ChangeOption[]{ChangeOption.CURRENT_REVISION});
            command.addOption(new ChangeOption[]{ChangeOption.CURRENT_COMMIT});
            command.addOption(new ChangeOption[]{ChangeOption.CURRENT_ACTIONS});
            try {
                command.addQuery(query);
                res = command.call();
            }
            catch (EGerritException e) {
                Utils.displayInformation(null, TITLE, e.getLocalizedMessage());
            }
            ChangeInfo[] changeInfoArray = res;
            return changeInfoArray;
        }
        finally {
            monitor.done();
        }
    }

    private boolean isQueryAuthorized(String query) {
        return query.isEmpty() || !this.gerritClient.getRepository().getServerInfo().isAnonymous() || !query.contains(":self") && !query.contains(":owner") && !query.contains("is:reviewer") && !query.contains("is:starred") && !query.contains(":draft");
    }

    private void setRepositoryVersionLabel(String aRepo, String aVersion) {
        Display.getDefault().asyncExec(() -> {
            if (!this.fRepositoryVersionResulLabel.isDisposed()) {
                this.fRepositoryVersionResulLabel.setText(aRepo);
                if (this.gerritClient == null) {
                    this.fRepositoryVersionResulLabel.setImage(fImageRegistry.get(INVALID_IMAGE));
                    this.fRepositoryVersionResulLabel.setToolTipText(Messages.GerritTableView_tooltipInvalid);
                } else if (this.gerritClient.getRepository().getServerInfo().isAnonymous()) {
                    this.fRepositoryVersionResulLabel.setImage(fImageRegistry.get(ANONYMOUS_IMAGE));
                    this.fRepositoryVersionResulLabel.setToolTipText(String.valueOf(Messages.GerritTableView_tooltipAnonymous) + '\n' + NLS.bind((String)Messages.GerritTableView_gerritVersion, (Object)aVersion));
                } else {
                    this.fRepositoryVersionResulLabel.setImage(fImageRegistry.get(CHECKED_IMAGE));
                    this.fRepositoryVersionResulLabel.setToolTipText(String.valueOf(NLS.bind((String)Messages.GerritTableView_tooltipLoggedOnAs, (Object)this.gerritClient.getRepository().getServerInfo().getUserName())) + '\n' + NLS.bind((String)Messages.GerritTableView_gerritVersion, (Object)aVersion));
                }
            }
        });
    }

    private void setReviewsTotalResultLabel(String aSt) {
        if (!this.fReviewsTotalLabel.isDisposed()) {
            this.fReviewsTotalLabel.setText(String.valueOf(Messages.GerritTableView_totalReview) + aSt);
        }
    }

    private GerritServerInformation askUserToSelectRepo(List<GerritServerInformation> servers) {
        GerritServerInformation selection = null;
        SelectionDialog taskSelection = new SelectionDialog(null, servers);
        if (taskSelection.open() == 0) {
            selection = taskSelection.getSelection();
        }
        if (selection != null) {
            this.createReviewList(null);
        }
        return selection;
    }

    private void addOrChangeServerThenLoad() {
        if (this.fAddOneServerDialog == null) {
            this.fAddOneServerDialog = new AddOneServerDialog();
            this.fAddOneServerDialog.promptToModifyServer(this.defaultServerInfo, true);
            GerritServerInformation serverInfo = this.fAddOneServerDialog.getServer();
            this.fAddOneServerDialog = null;
            if (serverInfo == null) {
                logger.debug("No new server entered by the user.");
                return;
            }
            this.defaultServerInfo = serverInfo;
            if (this.fSearchTextBox == null || this.fSearchTextBox.getText().isEmpty()) {
                this.processCommands(ChangeStatus.OPEN.getValue());
            } else {
                this.processCommands(this.fSearchTextBox.getText());
            }
        }
    }

    public void update() {
        rtv.processCommands(this.fSearchTextBox.getText());
    }

    public void update(String query) {
        rtv.processCommands(query);
    }

    public GerritClient getGerritClient() {
        return this.gerritClient;
    }

    public void resetDefault() {
        this.reviewTable.resetDefault();
    }

    private String[] extractColumnNames(ChangeInfo[] reviews) {
        TreeSet allLabels = new TreeSet();
        if (reviews == null || reviews.length == 0) {
            return new String[0];
        }
        ChangeInfo[] changeInfoArray = reviews;
        int n = reviews.length;
        int n2 = 0;
        while (n2 < n) {
            ChangeInfo changeinfo = changeInfoArray[n2];
            allLabels.addAll(changeinfo.getLabels().keySet());
            ++n2;
        }
        return allLabels.toArray(new String[allLabels.size()]);
    }

    public UIReviewTable getReviewTable() {
        return this.reviewTable;
    }
}

