/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.tabs;

import java.text.SimpleDateFormat;
import java.util.Iterator;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.egerrit.internal.core.EGerritCorePlugin;
import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.core.command.ChangeCommitMsgCommand;
import org.eclipse.egerrit.internal.core.command.PublishChangeEditCommand;
import org.eclipse.egerrit.internal.core.exception.EGerritException;
import org.eclipse.egerrit.internal.core.rest.ChangeEditMessageInput;
import org.eclipse.egerrit.internal.model.ChangeInfo;
import org.eclipse.egerrit.internal.model.CommitInfo;
import org.eclipse.egerrit.internal.model.ModelPackage;
import org.eclipse.egerrit.internal.ui.editors.ModelLoader;
import org.eclipse.egerrit.internal.ui.tabs.ObservableCollector;
import org.eclipse.egerrit.internal.ui.utils.DataConverter;
import org.eclipse.egerrit.internal.ui.utils.LinkDashboard;
import org.eclipse.egerrit.internal.ui.utils.Messages;
import org.eclipse.egerrit.internal.ui.utils.UIUtils;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class MessageTabView {
    private Text msgTextData;
    private Link msgAuthorData;
    private Label msgDatePushData;
    private Link msgCommitterData;
    private Label msgDatecommitterData;
    private Link msgCommitidData;
    private Label msgParentIdData;
    private Link msgChangeIdData;
    private final SimpleDateFormat formatTimeOut = new SimpleDateFormat("MMM d, yyyy  hh:mm a");
    private GerritClient fGerritClient;
    private Boolean fShowExtraInfo = true;
    private DataBindingContext bindingContext = new DataBindingContext();
    private ObservableCollector observableCollector;

    public void create(GerritClient gerritClient, Composite tabFolder, ChangeInfo changeInfo) {
        this.fGerritClient = gerritClient;
        this.createControls(tabFolder, changeInfo);
    }

    private boolean isEditingAllowed() {
        return !this.fGerritClient.getRepository().getServerInfo().isAnonymous();
    }

    private Composite createAsTabfolder(Composite tabFolder) {
        TabItem tabMessages = new TabItem((TabFolder)tabFolder, 0);
        tabMessages.setText(Messages.MessageTabView_1);
        Composite messagesComposite = new Composite(tabFolder, 0);
        tabMessages.setControl((Control)messagesComposite);
        messagesComposite.setLayout((Layout)new GridLayout(4, false));
        return messagesComposite;
    }

    private Composite createAsComposite(Composite parent) {
        final ScrolledComposite scrollComposite = new ScrolledComposite(parent, 768);
        final Composite messagesComposite = new Composite((Composite)scrollComposite, 0);
        messagesComposite.setLayout((Layout)new GridLayout(4, false));
        scrollComposite.setContent((Control)messagesComposite);
        scrollComposite.setExpandVertical(true);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                scrollComposite.setMinSize(messagesComposite.computeSize(-1, -1));
            }
        });
        this.fShowExtraInfo = false;
        return messagesComposite;
    }

    private void createControls(Composite composite, final ChangeInfo changeInfo) {
        Composite messagesComposite = composite instanceof TabFolder ? this.createAsTabfolder(composite) : this.createAsComposite(composite);
        this.msgTextData = new Text(messagesComposite, 2626);
        GridData gridData = new GridData(4, 4, true, true, 4, 1);
        Point fontsize = UIUtils.computeFontSize(messagesComposite);
        gridData.minimumHeight = fontsize.y * 3;
        this.msgTextData.setLayoutData((Object)gridData);
        this.msgTextData.setEditable(this.isEditingAllowed());
        final Button btnCancel = new Button(messagesComposite, 0);
        GridData gd_btnCancel = new GridData(16384, 0x1000000, false, false, 1, 1);
        btnCancel.setLayoutData((Object)gd_btnCancel);
        btnCancel.setText(Messages.MessageTabView_2);
        btnCancel.setEnabled(false);
        final Button fBtnSave = new Button(messagesComposite, 0);
        GridData gd_btnSave_1 = new GridData(16384, 128, false, false, 3, 1);
        fBtnSave.setLayoutData((Object)gd_btnSave_1);
        fBtnSave.setText(Messages.MessageTabView_3);
        fBtnSave.setEnabled(false);
        if (this.isEditingAllowed()) {
            btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MessageTabView.this.msgTextData.setText(changeInfo.getUserSelectedRevision().getCommit().getMessage());
                    fBtnSave.setEnabled(false);
                    btnCancel.setEnabled(false);
                }
            });
        }
        if (this.isEditingAllowed()) {
            ModifyListener textModifiedListener = new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                    if (changeInfo.getUserSelectedRevision() != null && changeInfo.getUserSelectedRevision().getCommit().getMessage().compareTo(MessageTabView.this.msgTextData.getText()) != 0) {
                        fBtnSave.setEnabled(true);
                        btnCancel.setEnabled(true);
                    } else {
                        fBtnSave.setEnabled(false);
                        btnCancel.setEnabled(false);
                    }
                }
            };
            this.msgTextData.addModifyListener(textModifiedListener);
        }
        if (this.fShowExtraInfo.booleanValue()) {
            Label lblAuthor = new Label(messagesComposite, 0);
            lblAuthor.setText(Messages.MessageTabView_4);
            lblAuthor.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
            this.msgAuthorData = new Link(messagesComposite, 0);
            this.msgAuthorData.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
            this.msgAuthorData.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    LinkDashboard linkDash = new LinkDashboard(MessageTabView.this.fGerritClient);
                    linkDash.invokeRefreshDashboardCommand("owner", "\"" + e.text + "\"" + " status:open");
                }
            });
            this.msgDatePushData = new Label(messagesComposite, 0);
            this.msgDatePushData.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 2, 1));
            Label lblCommitter = new Label(messagesComposite, 0);
            lblCommitter.setText(Messages.MessageTabView_5);
            lblCommitter.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
            this.msgCommitterData = new Link(messagesComposite, 0);
            this.msgCommitterData.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
            this.msgCommitterData.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    LinkDashboard linkDash = new LinkDashboard(MessageTabView.this.fGerritClient);
                    linkDash.invokeRefreshDashboardCommand("owner", "\"" + e.text + "\"" + " status:open");
                }
            });
            this.msgDatecommitterData = new Label(messagesComposite, 0);
            GridData gd_DateCommitter = new GridData(131072, 0x1000000, false, false, 2, 1);
            this.msgDatecommitterData.setLayoutData((Object)gd_DateCommitter);
            Label lblCommit = new Label(messagesComposite, 0);
            lblCommit.setText(Messages.MessageTabView_6);
            lblCommit.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
            this.msgCommitidData = new Link(messagesComposite, 0);
            this.msgCommitidData.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    LinkDashboard linkDash = new LinkDashboard(MessageTabView.this.fGerritClient);
                    linkDash.invokeRefreshDashboardCommand("", e.text);
                }
            });
            this.msgCommitidData.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 3, 1));
            Label lblParents = new Label(messagesComposite, 0);
            lblParents.setText(Messages.MessageTabView_8);
            lblParents.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
            this.msgParentIdData = new Label(messagesComposite, 0);
            this.msgParentIdData.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
            Label lblChangeid = new Label(messagesComposite, 0);
            lblChangeid.setText(Messages.MessageTabView_9);
            lblChangeid.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
            this.msgChangeIdData = new Link(messagesComposite, 0);
            this.msgChangeIdData.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
            this.msgChangeIdData.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    LinkDashboard linkDash = new LinkDashboard(MessageTabView.this.fGerritClient);
                    linkDash.invokeRefreshDashboardCommand("", e.text);
                }
            });
        }
        if (this.isEditingAllowed()) {
            fBtnSave.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    super.widgetSelected(e);
                    ChangeCommitMsgCommand editMessageCmd = MessageTabView.this.fGerritClient.editMessage(changeInfo.getId());
                    ChangeEditMessageInput changeEditMessageInput = new ChangeEditMessageInput();
                    changeEditMessageInput.setMessage(MessageTabView.this.msgTextData.getText());
                    editMessageCmd.setCommandInput((Object)changeEditMessageInput);
                    PublishChangeEditCommand publishChangeEditCmd = MessageTabView.this.fGerritClient.publishChangeEdit(changeInfo.getId());
                    try {
                        editMessageCmd.call();
                        publishChangeEditCmd.call();
                    }
                    catch (EGerritException e3) {
                        EGerritCorePlugin.logError((String)(String.valueOf(MessageTabView.this.fGerritClient.getRepository().formatGerritVersion()) + e3.getMessage()));
                    }
                    fBtnSave.setEnabled(false);
                    btnCancel.setEnabled(false);
                    ModelLoader loader = ModelLoader.initialize(MessageTabView.this.fGerritClient, changeInfo);
                    loader.loadBasicInformation();
                    loader.dispose();
                }
            });
        }
        if (this.fShowExtraInfo.booleanValue()) {
            new Label(messagesComposite, 0);
        }
        this.msgTabDataBindings(changeInfo);
    }

    protected void msgTabDataBindings(ChangeInfo changeInfo) {
        FeaturePath commitMessage = FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ModelPackage.Literals.CHANGE_INFO__REVISION, ModelPackage.Literals.REVISION_INFO__COMMIT, ModelPackage.Literals.COMMIT_INFO__MESSAGE});
        IObservableValue msgTextDataValue = EMFProperties.value((FeaturePath)commitMessage).observe((Object)changeInfo);
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)this.msgTextData), msgTextDataValue, null, null);
        if (!this.fShowExtraInfo.booleanValue()) {
            this.observableCollector = new ObservableCollector(this.bindingContext);
            return;
        }
        FeaturePath authorName = FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ModelPackage.Literals.CHANGE_INFO__REVISION, ModelPackage.Literals.REVISION_INFO__COMMIT, ModelPackage.Literals.COMMIT_INFO__AUTHOR});
        IObservableValue msgAuthorDataValue = EMFProperties.value((FeaturePath)authorName).observe((Object)changeInfo);
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)this.msgAuthorData), msgAuthorDataValue, null, new UpdateValueStrategy().setConverter(DataConverter.gitPersonConverter()));
        FeaturePath commitDate = FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ModelPackage.Literals.CHANGE_INFO__REVISION, ModelPackage.Literals.REVISION_INFO__COMMIT, ModelPackage.Literals.COMMIT_INFO__AUTHOR, ModelPackage.Literals.GIT_PERSON_INFO__DATE});
        IObservableValue msgAuthorDateDataValue = EMFProperties.value((FeaturePath)commitDate).observe((Object)changeInfo);
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)this.msgDatePushData), msgAuthorDateDataValue, null, new UpdateValueStrategy().setConverter(DataConverter.gerritTimeConverter(this.formatTimeOut)));
        FeaturePath committerName = FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ModelPackage.Literals.CHANGE_INFO__REVISION, ModelPackage.Literals.REVISION_INFO__COMMIT, ModelPackage.Literals.COMMIT_INFO__COMMITTER});
        IObservableValue msgCommitterDataValue = EMFProperties.value((FeaturePath)committerName).observe((Object)changeInfo);
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)this.msgCommitterData), msgCommitterDataValue, null, new UpdateValueStrategy().setConverter(DataConverter.gitPersonConverter()));
        FeaturePath commiterDate = FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ModelPackage.Literals.CHANGE_INFO__REVISION, ModelPackage.Literals.REVISION_INFO__COMMIT, ModelPackage.Literals.COMMIT_INFO__COMMITTER, ModelPackage.Literals.GIT_PERSON_INFO__DATE});
        IObservableValue msgCommitterDateDataValue = EMFProperties.value((FeaturePath)commiterDate).observe((Object)changeInfo);
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)this.msgDatecommitterData), msgCommitterDateDataValue, null, new UpdateValueStrategy().setConverter(DataConverter.gerritTimeConverter(this.formatTimeOut)));
        FeaturePath commitId = FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ModelPackage.Literals.CHANGE_INFO__REVISION, ModelPackage.Literals.REVISION_INFO__COMMIT, ModelPackage.Literals.COMMIT_INFO__COMMIT});
        IObservableValue msgCommitidDataValue = EMFProperties.value((FeaturePath)commitId).observe((Object)changeInfo);
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)this.msgCommitidData), msgCommitidDataValue, null, new UpdateValueStrategy().setConverter(DataConverter.linkText()));
        FeaturePath commitParents = FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ModelPackage.Literals.CHANGE_INFO__REVISION, ModelPackage.Literals.REVISION_INFO__COMMIT, ModelPackage.Literals.COMMIT_INFO__PARENTS});
        final IObservableList parents = EMFProperties.list((FeaturePath)commitParents).observe((Object)changeInfo);
        ComputedValue<String> parentCommitsAsString = new ComputedValue<String>(){

            protected String calculate() {
                Iterator it = parents.iterator();
                String result = "";
                while (it.hasNext()) {
                    CommitInfo info = (CommitInfo)it.next();
                    result = String.valueOf(result) + info.getCommit() + " ";
                }
                return result;
            }
        };
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)this.msgParentIdData), (IObservableValue)parentCommitsAsString, null, null);
        IObservableValue msgChangeIdDataValue = EMFObservables.observeValue((EObject)changeInfo, (EStructuralFeature)ModelPackage.Literals.CHANGE_INFO__CHANGE_ID);
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)this.msgChangeIdData), msgChangeIdDataValue, null, new UpdateValueStrategy().setConverter(DataConverter.linkText()));
        this.observableCollector = new ObservableCollector(this.bindingContext);
    }

    public void dispose() {
        this.observableCollector.dispose();
        this.bindingContext.dispose();
    }
}

