/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.table.model;

import org.eclipse.egerrit.internal.model.impl.ChangeMessageInfoImpl;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TreeItem;

public class HistoryTableSorter
extends ViewerSorter {
    private int fColumnIndex = 0;

    public HistoryTableSorter(int columnIndex) {
        this.fColumnIndex = columnIndex;
    }

    public int compare(Viewer viewer, Object item1, Object item2) {
        int result;
        int sortDirection;
        block10: {
            block9: {
                sortDirection = 0;
                if (viewer instanceof TableViewer) {
                    sortDirection = ((TableViewer)viewer).getTable().getSortDirection();
                } else if (viewer instanceof TreeViewer) {
                    sortDirection = ((TreeViewer)viewer).getTree().getSortDirection();
                }
                result = 0;
                if (!(viewer instanceof TableViewer) || !(item1 instanceof ChangeMessageInfoImpl) || !(item2 instanceof ChangeMessageInfoImpl)) break block9;
                ChangeMessageInfoImpl changeInfo1 = (ChangeMessageInfoImpl)item1;
                ChangeMessageInfoImpl changeInfo2 = (ChangeMessageInfoImpl)item2;
                String val1 = null;
                String val2 = null;
                switch (this.fColumnIndex) {
                    case 0: {
                        result = Boolean.toString(changeInfo1.isComment()).compareTo(Boolean.toString(changeInfo2.isComment()));
                        break;
                    }
                    case 1: {
                        val1 = changeInfo1.getDate();
                        val2 = changeInfo2.getDate();
                        if (val1 != null && val2 != null) {
                            result = val1.compareTo(val2);
                            break;
                        }
                        break block10;
                    }
                    default: {
                        result = this.defaultCompare(viewer, item1, item2);
                        break;
                    }
                }
                break block10;
            }
            result = this.defaultCompare(viewer, item1, item2);
        }
        if (sortDirection != 128) {
            result = -result;
        }
        return result;
    }

    private int defaultCompare(Viewer aViewer, Object aE1, Object aE2) {
        if (aViewer instanceof TableViewer) {
            TableViewer tv = (TableViewer)aViewer;
            tv.getTable().setSortColumn(tv.getTable().getColumn(this.fColumnIndex));
            int idx1 = -1;
            int idx2 = -1;
            int i = 0;
            while (i < tv.getTable().getItemCount()) {
                Object obj = tv.getElementAt(i);
                if (obj.equals(aE1)) {
                    idx1 = i;
                } else if (obj.equals(aE2)) {
                    idx2 = i;
                }
                if (idx1 != -1 && idx2 != -1) break;
                ++i;
            }
            int order = 0;
            if (idx1 > -1 && idx2 > -1) {
                String str1 = tv.getTable().getItems()[idx1].getText(this.fColumnIndex);
                String str2 = tv.getTable().getItems()[idx2].getText(this.fColumnIndex);
                order = str1.compareTo(str2);
            }
            return order;
        }
        if (aViewer instanceof TreeViewer) {
            TreeViewer tv = (TreeViewer)aViewer;
            tv.getTree().setSortColumn(tv.getTree().getColumn(this.fColumnIndex));
            int idx1 = -1;
            int idx2 = -1;
            TreeItem[] listObj = tv.getTree().getItems();
            int i = 0;
            while (i < listObj.length) {
                Object obj = listObj[i].getData();
                listObj[i].setExpanded(true);
                if (obj != null) {
                    if (obj.equals(aE1)) {
                        idx1 = i;
                    } else if (obj.equals(aE2)) {
                        idx2 = i;
                    }
                    if (idx1 > 0 && idx2 > 0) break;
                }
                ++i;
            }
            int order = 0;
            if (idx1 > -1 && idx2 > -1) {
                String str1 = tv.getTree().getItems()[idx1].getText(this.fColumnIndex);
                String str2 = tv.getTree().getItems()[idx2].getText(this.fColumnIndex);
                order = str1.compareTo(str2);
            }
            return order;
        }
        return 0;
    }

    public static void bind(final TableViewer aTableViewer) {
        int i = 0;
        while (i < aTableViewer.getTable().getColumnCount()) {
            final int columnNum = i;
            TableColumn column = aTableViewer.getTable().getColumn(i);
            column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    HistoryTableSorter sorter = new HistoryTableSorter(columnNum);
                    Table table = aTableViewer.getTable();
                    TableColumn currentColumn = (TableColumn)e.widget;
                    table.setSortColumn(currentColumn);
                    table.setSortDirection(table.getSortDirection() == 128 ? 1024 : 128);
                    aTableViewer.setComparator((ViewerComparator)sorter);
                }
            });
            ++i;
        }
    }
}

