/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.editors;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.egerrit.internal.core.EGerritCorePlugin;
import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.model.CommentInfo;
import org.eclipse.egerrit.internal.model.ModelHelpers;
import org.eclipse.egerrit.internal.ui.EGerritImages;
import org.eclipse.egerrit.internal.ui.editors.EGerritCommentMarkers;
import org.eclipse.egerrit.internal.ui.editors.EGerritQuickFix;
import org.eclipse.egerrit.internal.ui.editors.QueryHelpers;
import org.eclipse.egerrit.internal.ui.utils.Messages;
import org.eclipse.egerrit.internal.ui.utils.UIUtils;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class QuickFixModifyDraft
extends EGerritQuickFix {
    QuickFixModifyDraft(String label, String completeMessage) {
        super(label, completeMessage);
    }

    public void run(IMarker marker) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        try {
            GerritClient gerritClient = (GerritClient)marker.getAttribute(EGerritCommentMarkers.ATTR_GERRIT_CLIENT);
            CommentInfo existingComment = (CommentInfo)marker.getAttribute(EGerritCommentMarkers.ATTR_COMMENT_INFO);
            InputDialog replyDialog = new InputDialog(shell, Messages.QuickFixModifyDraft_0, String.valueOf(Messages.QuickFixModifyDraft_1) + UIUtils.getPatchSetString(existingComment), existingComment.getMessage(), null){

                protected int getInputTextStyle() {
                    return 2562;
                }

                protected Control createDialogArea(Composite parent) {
                    Control res = super.createDialogArea(parent);
                    ((GridData)this.getText().getLayoutData()).heightHint = 100;
                    return res;
                }
            };
            replyDialog.open();
            if (replyDialog.getReturnCode() == 0) {
                UIUtils.postReply(gerritClient, existingComment, replyDialog.getValue(), ModelHelpers.getRevision((CommentInfo)existingComment).getId());
                QueryHelpers.deleteDraft(gerritClient, existingComment);
            }
        }
        catch (CoreException e) {
            EGerritCorePlugin.logError((String)e.getMessage());
            return;
        }
    }

    public Image getImage() {
        return EGerritImages.get("icons/edit.gif");
    }
}

