/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2.regionaccess.internal;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.xtext.formatting2.regionaccess.IComment;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegion;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegionPart;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegionPartMerger;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.IWhitespace;

public class HiddenRegionPartMerger
implements IHiddenRegionPartMerger {
    protected int getIndex(List<IHiddenRegionPart> parts) {
        for (int i = 0; i < parts.size(); ++i) {
            IHiddenRegionPart part = parts.get(i);
            if (!part.isMultiline()) continue;
            return i + 1;
        }
        return parts.size();
    }

    protected int getIndexFirstInFile(List<IHiddenRegionPart> parts) {
        IHiddenRegionPart part;
        int i;
        for (i = parts.size() - 1; i >= 0; --i) {
            part = parts.get(i);
            if (!(part instanceof IWhitespace) || part.getLineCount() <= 2) continue;
            return i + 1;
        }
        for (i = parts.size() - 1; i >= 0; --i) {
            part = parts.get(i);
            if (!(part instanceof IComment)) continue;
            return i;
        }
        return parts.size();
    }

    @Override
    public List<IHiddenRegionPart> merge(ITextRegionAccess b, IHiddenRegion first, IHiddenRegion last, boolean del) {
        int i;
        List<IHiddenRegionPart> parts1 = first.getParts();
        List<IHiddenRegionPart> parts2 = last.getParts();
        boolean firstInFile1 = first.getPreviousSemanticRegion() == null;
        boolean firstInFile2 = last.getPreviousSemanticRegion() == null;
        int index1 = firstInFile1 ? this.getIndexFirstInFile(parts1) : this.getIndex(parts1);
        int index2 = firstInFile2 ? this.getIndexFirstInFile(parts2) : this.getIndex(parts2);
        ArrayList result = Lists.newArrayList();
        if (del && !first.isMultiline()) {
            result.addAll(parts1);
        } else {
            for (i = 0; i < index1; ++i) {
                result.add(parts1.get(i));
            }
        }
        if (del && !last.isMultiline()) {
            result.addAll(parts2);
        } else {
            for (i = index2; i < parts2.size(); ++i) {
                result.add(parts2.get(i));
            }
        }
        return result;
    }
}

