/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.formatting2;

import com.google.common.base.Objects;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.TypeRef;
import org.eclipse.xtext.formatting2.AbstractFormatter2;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.generator.IInheriting;
import org.eclipse.xtext.generator.Naming;
import org.eclipse.xtext.generator.grammarAccess.GrammarAccessUtil;
import org.eclipse.xtext.generator.serializer.JavaEMFFile;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Pure;

@FinalFieldsConstructor
public class FormatterStubGenerator {
    private final Service service;
    private final Grammar grammar;

    public String getStubSimpleName() {
        StringConcatenation _builder = new StringConcatenation();
        String _name = this.grammar.getName();
        String _simpleName = this.service.naming.toSimpleName(_name);
        _builder.append((Object)_simpleName, "");
        _builder.append((Object)"Formatter");
        return _builder.toString();
    }

    public String getStubPackageName() {
        StringConcatenation _builder = new StringConcatenation();
        String _name = this.grammar.getName();
        String _packageName = this.service.naming.toPackageName(_name);
        _builder.append((Object)_packageName, "");
        _builder.append((Object)".formatting2");
        return _builder.toString();
    }

    public String getStubQualifiedName() {
        StringConcatenation _builder = new StringConcatenation();
        String _stubPackageName = this.getStubPackageName();
        _builder.append((Object)_stubPackageName, "");
        _builder.append((Object)".");
        String _stubSimpleName = this.getStubSimpleName();
        _builder.append((Object)_stubSimpleName, "");
        return _builder.toString();
    }

    public String getStubFileName() {
        StringConcatenation _builder = new StringConcatenation();
        String _stubQualifiedName = this.getStubQualifiedName();
        String _asPath = this.service.naming.asPath(_stubQualifiedName);
        _builder.append((Object)_asPath, "");
        _builder.append((Object)".xtend");
        return _builder.toString();
    }

    public String getStubSuperClassName() {
        boolean _notEquals;
        Grammar superGrammar = IInheriting.Util.getNonTerminalsSuperGrammar(this.grammar);
        boolean bl = _notEquals = !Objects.equal((Object)superGrammar, null);
        if (_notEquals) {
            FormatterStubGenerator _createGenerator = this.service.createGenerator(superGrammar);
            return _createGenerator.getStubQualifiedName();
        }
        return AbstractFormatter2.class.getName();
    }

    protected void getLocallyAssignedContainmentReferences(Grammar grammar, Multimap<EClass, EReference> type2ref) {
        List _containedAssignments = GrammarUtil.containedAssignments((EObject)grammar);
        for (Assignment assignment : _containedAssignments) {
            String _feature;
            EStructuralFeature feature;
            EClassifier type = GrammarUtil.findCurrentType((AbstractElement)assignment);
            if (!(type instanceof EClass) || !((feature = ((EClass)type).getEStructuralFeature(_feature = assignment.getFeature())) instanceof EReference) || !((EReference)feature).isContainment()) continue;
            type2ref.put((Object)((EClass)type), (Object)((EReference)feature));
        }
        List _containedActions = GrammarUtil.containedActions((EObject)grammar);
        for (Action action : _containedActions) {
            EStructuralFeature feature;
            TypeRef _type;
            EClassifier type;
            boolean _notEquals;
            String featureName = action.getFeature();
            boolean bl = _notEquals = !Objects.equal((Object)featureName, null);
            if (!_notEquals || !((type = (_type = action.getType()).getClassifier()) instanceof EClass) || !((feature = ((EClass)type).getEStructuralFeature(featureName)) instanceof EReference) || !((EReference)feature).isContainment()) continue;
            type2ref.put((Object)((EClass)type), (Object)((EReference)feature));
        }
    }

    protected void getInheritedContainmentReferences(Grammar grammar, Multimap<EClass, EReference> type2ref, Set<Grammar> visitedGrammars) {
        visitedGrammars.add(grammar);
        EList _usedGrammars = grammar.getUsedGrammars();
        for (Grammar usedGrammar : _usedGrammars) {
            boolean _not;
            boolean _contains = visitedGrammars.contains(usedGrammar);
            boolean bl = _not = !_contains;
            if (!_not) continue;
            this.getLocallyAssignedContainmentReferences(usedGrammar, type2ref);
            this.getInheritedContainmentReferences(usedGrammar, type2ref, visitedGrammars);
        }
    }

    public String generateStubFileContents() {
        Resource _eResource = this.grammar.eResource();
        ResourceSet _resourceSet = _eResource.getResourceSet();
        String _stubPackageName = this.getStubPackageName();
        String _fileHeader = this.service.naming.fileHeader();
        JavaEMFFile file = new JavaEMFFile(_resourceSet, _stubPackageName, _fileHeader);
        file.imported(IFormattableDocument.class);
        LinkedHashMultimap type2ref = LinkedHashMultimap.create();
        this.getLocallyAssignedContainmentReferences(this.grammar, (Multimap<EClass, EReference>)type2ref);
        LinkedHashMultimap inheritedTypes = LinkedHashMultimap.create();
        HashSet _newHashSet = CollectionLiterals.newHashSet((Object[])new Grammar[0]);
        this.getInheritedContainmentReferences(this.grammar, (Multimap<EClass, EReference>)inheritedTypes, _newHashSet);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"class ");
        String _stubSimpleName = this.getStubSimpleName();
        _builder.append((Object)_stubSimpleName, "");
        _builder.append((Object)" extends ");
        String _stubSuperClassName = this.getStubSuperClassName();
        String _imported = file.imported(_stubSuperClassName);
        _builder.append((Object)_imported, "");
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@");
        String _imported_1 = file.imported(Inject.class);
        _builder.append((Object)_imported_1, "\t");
        _builder.append((Object)" extension ");
        String _grammarAccessFQName = GrammarAccessUtil.getGrammarAccessFQName(this.grammar, this.service.naming);
        String _imported_2 = file.imported(_grammarAccessFQName);
        _builder.append((Object)_imported_2, "\t");
        _builder.newLineIfNotEmpty();
        Set _keySet = type2ref.keySet();
        for (EClass type : _keySet) {
            _builder.newLine();
            _builder.append((Object)"\t");
            Set _get = type2ref.get((Object)type);
            boolean _containsKey = inheritedTypes.containsKey((Object)type);
            CharSequence _generateFormatMethod = this.generateFormatMethod(type, file, _get, _containsKey);
            _builder.append((Object)_generateFormatMethod, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"}");
        _builder.newLine();
        file.setBody(_builder.toString());
        return file.toString();
    }

    protected String toName(EClass clazz) {
        String _name = clazz.getName();
        return _name.toLowerCase();
    }

    protected CharSequence generateFormatMethod(EClass clazz, @Extension JavaEMFFile file, Collection<EReference> containmentRefs, boolean isOverriding) {
        StringConcatenation _builder = new StringConcatenation();
        if (isOverriding) {
            _builder.append((Object)"override");
        } else {
            _builder.append((Object)"def");
        }
        _builder.append((Object)" dispatch void format(");
        String _importedGenTypeName = file.importedGenTypeName(clazz);
        _builder.append((Object)_importedGenTypeName, "");
        _builder.append((Object)" ");
        String _name = this.toName(clazz);
        _builder.append((Object)_name, "");
        _builder.append((Object)", extension IFormattableDocument document) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"// TODO: format HiddenRegions around keywords, attributes, cross references, etc. ");
        _builder.newLine();
        for (EReference ref : containmentRefs) {
            boolean _isMany = ref.isMany();
            if (_isMany) {
                _builder.append((Object)"\t");
                _builder.append((Object)"for (");
                EClass _eReferenceType = ref.getEReferenceType();
                String _importedGenTypeName_1 = file.importedGenTypeName(_eReferenceType);
                _builder.append((Object)_importedGenTypeName_1, "\t");
                _builder.append((Object)" ");
                String _name_1 = ref.getName();
                _builder.append((Object)_name_1, "\t");
                _builder.append((Object)" : ");
                String _name_2 = this.toName(clazz);
                _builder.append((Object)_name_2, "\t");
                _builder.append((Object)".");
                String _getAccessor = file.getGetAccessor((EStructuralFeature)ref);
                _builder.append((Object)_getAccessor, "\t");
                _builder.append((Object)"()) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"format(");
                String _name_3 = ref.getName();
                _builder.append((Object)_name_3, "\t\t");
                _builder.append((Object)", document);");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                continue;
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"format(");
            String _name_4 = this.toName(clazz);
            _builder.append((Object)_name_4, "\t");
            _builder.append((Object)".");
            String _getAccessor_1 = file.getGetAccessor((EStructuralFeature)ref);
            _builder.append((Object)_getAccessor_1, "\t");
            _builder.append((Object)"(), document);");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public FormatterStubGenerator(Service service, Grammar grammar) {
        this.service = service;
        this.grammar = grammar;
    }

    @Accessors(value={AccessorType.PUBLIC_GETTER})
    public static class Service {
        @Inject
        private Naming naming;

        public FormatterStubGenerator createGenerator(Grammar grammar) {
            return new FormatterStubGenerator(this, grammar);
        }

        @Pure
        public Naming getNaming() {
            return this.naming;
        }
    }
}

