/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator;

import com.google.inject.Inject;
import java.io.CharArrayWriter;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.formatting.IWhitespaceInformationProvider;
import org.eclipse.xtext.generator.IFilePostProcessor;
import org.eclipse.xtext.generator.trace.ITraceRegionProvider;

public class LineSeparatorHarmonizer
implements IFilePostProcessor {
    @Inject
    private IWhitespaceInformationProvider whitespaceInformationProvider;

    @Override
    public CharSequence postProcess(URI fileURI, CharSequence content) {
        if (content instanceof ITraceRegionProvider) {
            return content;
        }
        String lineSeparator = this.whitespaceInformationProvider.getLineSeparatorInformation(fileURI).getLineSeparator();
        return this.replaceLineSeparators(content, lineSeparator);
    }

    protected String replaceLineSeparators(CharSequence content, String newLineSeparator) {
        CharArrayWriter writer = new CharArrayWriter(content.length());
        boolean isLookahead = false;
        int ignoreNext = 0;
        block4: for (int i = 0; i < content.length(); ++i) {
            int c = content.charAt(i);
            if (isLookahead) {
                isLookahead = false;
                if (c == ignoreNext) continue;
            }
            switch (c) {
                case 10: {
                    writer.append(newLineSeparator);
                    isLookahead = true;
                    ignoreNext = 13;
                    continue block4;
                }
                case 13: {
                    writer.append(newLineSeparator);
                    isLookahead = true;
                    ignoreNext = 10;
                    continue block4;
                }
                default: {
                    writer.append((char)c);
                }
            }
        }
        return writer.toString();
    }

    protected IWhitespaceInformationProvider getWhitespaceInformationProvider() {
        return this.whitespaceInformationProvider;
    }
}

