/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.utils.installer;

import com.sun.jck.utils.installer.Node;
import com.sun.jck.utils.installer.Root;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class MegaZipFile {
    private File m_archiveFile;
    private int m_verbosity = 1;
    private int m_mode = 0;
    private PrintStream m_log;
    private int m_maxSubzipEntries = 65534;
    private long m_subzipSize = 0L;
    private long m_maxSubzipSize = 0L;
    private String m_mainClass;
    private HashSet m_exportClasses = new HashSet();
    private HashSet m_topLevelEntries = new HashSet();
    private int m_totalNumberOfFiles = 0;
    private File m_tempDirectory;
    private File m_copyRightFile;
    private int m_errorHandleMode = 1;
    private HashMap m_errorsMap = new HashMap();
    private boolean m_deleteTempDir = true;
    private boolean m_unZipSucceeded = true;
    private boolean m_zipSucceeded = true;
    public static final String MANIFEST = "META-INF/MANIFEST.MF";
    public static final int ON_ERROR_IGNORE = 0;
    public static final int ON_ERROR_REPORT = 1;
    public static final int ON_ERROR_FAIL = 2;
    public static final int VERBOSE_QUIET = 0;
    public static final int VERBOSE_NORMAL = 1;
    public static final int VERBOSE_LOUD = 2;
    public static final int MODE_EXECUTE = 0;
    public static final int MODE_LIST = 1;
    public static final int MEGAZIP_MAX_ENTRIES = 65534;
    public static final int MEGAZIP_MAX_FILES = Integer.MAX_VALUE;

    private MegaZipFile() {
    }

    public MegaZipFile(String string) throws Fault {
        this(new File(string), System.out);
    }

    public MegaZipFile(String string, PrintStream printStream) throws Fault {
        this(new File(string), printStream);
    }

    public MegaZipFile(File file) throws Fault {
        this(file, System.out);
    }

    public MegaZipFile(File file, PrintStream printStream) throws Fault {
        this.m_archiveFile = file;
        this.m_log = printStream;
    }

    public void setVerbosity(int n) throws IllegalArgumentException {
        switch (n) {
            case 2: {
                if (this.m_verbosity == 2) {
                    this.m_log.println("Setting Verbosity to Loud");
                }
                this.m_verbosity = 2;
                break;
            }
            case 1: {
                if (this.m_verbosity == 2) {
                    this.m_log.println("Setting Verbosity to Normal");
                }
                this.m_verbosity = 1;
                break;
            }
            case 0: {
                if (this.m_verbosity == 2) {
                    this.m_log.println("Setting Verbosity to Quiet");
                }
                this.m_verbosity = 0;
                break;
            }
            default: {
                if (this.m_verbosity == 2) {
                    this.m_log.println("Attempt to set verbosity to unkown level");
                }
                throw new IllegalArgumentException("Unkown verbosity level");
            }
        }
    }

    public int getVerbosity() {
        return this.m_verbosity;
    }

    public void setLog(PrintStream printStream) {
        this.m_log = printStream;
        if (this.m_verbosity == 2) {
            this.m_log.println("Log set to " + this.m_log.toString());
        }
    }

    public PrintStream getLog() {
        return this.m_log;
    }

    public void setSubZipSize(long l) throws IllegalArgumentException {
        if (l < 0L) {
            throw new IllegalArgumentException("subZip Size value must be greater than 0");
        }
        this.m_maxSubzipSize = l;
        if (this.m_verbosity == 2) {
            this.m_log.println("SubZip Maximum size set to " + this.m_maxSubzipSize);
        }
    }

    public void setSubZipEntries(int n) throws IllegalArgumentException {
        if (n > 65534) {
            throw new IllegalArgumentException("The number of Zip Entries can not exceed 65534");
        }
        this.m_maxSubzipEntries = n;
        if (this.m_verbosity == 2) {
            this.m_log.println("SubZip Maximum number of entries to " + this.m_maxSubzipEntries);
        }
    }

    public void setMainClass(String string) {
        this.m_mainClass = string;
        if (this.m_verbosity == 2) {
            this.m_log.println("Main class set to " + this.m_mainClass);
        }
        this.m_exportClasses.add(this.m_mainClass);
    }

    public String getMainClass() {
        return this.m_mainClass;
    }

    public void setExportClasses(File file) throws IllegalArgumentException, Fault {
        if (!file.exists()) {
            throw new IllegalStateException("Can not find " + file.getPath());
        }
        if (!file.isFile()) {
            throw new IllegalStateException(file.getPath() + " is not a regular file.");
        }
        if (!file.canRead()) {
            throw new IllegalStateException("Do not have permission to read " + file.getPath());
        }
        try {
            this.m_exportClasses.addAll(this.generateClassList(file));
        }
        catch (IOException iOException) {
            throw new Fault("An error occured while processing export-class file.\n" + iOException.getMessage());
        }
    }

    public HashSet getExportClasses() {
        return this.m_exportClasses;
    }

    public void addTopLevelEntry(File[] fileArray) throws IllegalArgumentException {
        for (int i = 0; i < fileArray.length; ++i) {
            this.addTopLevelEntry(fileArray[i]);
        }
    }

    public void addTopLevelEntry(File file) throws IllegalArgumentException {
        if (!file.exists()) {
            throw new IllegalStateException("Can not find " + file.getPath());
        }
        if (!file.canRead()) {
            throw new IllegalStateException("Do not have permission to read " + file.getPath());
        }
        this.m_topLevelEntries.add(file);
        if (this.m_verbosity == 2) {
            this.m_log.println(file.getAbsolutePath() + " was added to list of top level entries");
        }
    }

    public void setCopyRightFile(File file) throws IllegalArgumentException {
        if (!file.exists()) {
            throw new IllegalStateException("Can not find " + file.getPath());
        }
        if (!file.canRead()) {
            throw new IllegalStateException("Do not have permission to read " + file.getPath());
        }
        this.m_copyRightFile = file;
        if (this.m_verbosity == 2) {
            this.m_log.println(this.m_copyRightFile.getAbsolutePath() + " was added a copyRight file");
        }
    }

    public File getCopyRightFile() {
        return this.m_copyRightFile;
    }

    public void setTempDir(File file) throws IllegalArgumentException, IOException {
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("The temporary directory " + file.getAbsolutePath() + "does not exist or is not a directory");
        }
        if (!file.canWrite()) {
            throw new IllegalArgumentException("The temporary directory " + file.getAbsolutePath() + "is not writable.");
        }
        this.m_tempDirectory = file;
        this.m_deleteTempDir = false;
        if (this.m_verbosity == 2) {
            this.m_log.println("Temproray Directory set to " + this.m_tempDirectory.getAbsolutePath());
        }
    }

    public File getTempDir() {
        return this.m_tempDirectory;
    }

    public void setErrorMode(int n) throws IllegalArgumentException {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("Invalid Error Handeling Mode");
        }
        this.m_errorHandleMode = n;
    }

    public int getErrorMode() {
        return this.m_errorHandleMode;
    }

    public Map getErrors() {
        return this.m_errorsMap;
    }

    public boolean zip(File[] fileArray) throws IllegalStateException, IOException, Fault {
        Node node2 = null;
        if (this.m_archiveFile.exists()) {
            throw new IOException("Zip file " + this.m_archiveFile.getAbsolutePath() + " already exists.");
        }
        JarOutputStream jarOutputStream = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(this.m_archiveFile)));
        Manifest manifest = new Manifest();
        try {
            if (this.m_copyRightFile != null) {
                try {
                    this.deflate((ZipOutputStream)jarOutputStream, this.m_copyRightFile, this.m_copyRightFile.getName(), 0);
                }
                catch (DeflateFault deflateFault) {
                    this.m_zipSucceeded = false;
                }
            }
            if (this.m_topLevelEntries.size() != 0) {
                for (File file : this.m_topLevelEntries) {
                    try {
                        this.deflate((ZipOutputStream)jarOutputStream, file, file.getName(), 8);
                    }
                    catch (DeflateFault deflateFault) {
                        this.m_zipSucceeded = false;
                    }
                }
            }
            ArrayList arrayList = this.generateSubzips(this.generateEntries(fileArray));
            for (Node node2 : arrayList) {
                File file = node2.getFile();
                try {
                    this.deflate((ZipOutputStream)jarOutputStream, file, file.getName(), 8);
                }
                catch (DeflateFault deflateFault) {
                    this.m_zipSucceeded = false;
                }
                if (!node2.getFile().delete()) {
                    if (this.m_verbosity < 1) continue;
                    this.m_log.println("Unable to delete temporary zip file " + file.getAbsolutePath());
                    continue;
                }
                if (this.m_verbosity != 2) continue;
                this.m_log.println("Deleted temporary zip file " + file.getAbsolutePath());
            }
            Attributes attributes = manifest.getMainAttributes();
            attributes.put(Attributes.Name.MANIFEST_VERSION, "1");
            if (this.m_mainClass != null) {
                if (this.exportClasses(jarOutputStream)) {
                    attributes.put(Attributes.Name.MAIN_CLASS, this.m_mainClass);
                } else {
                    this.m_zipSucceeded = false;
                }
            }
            try {
                jarOutputStream.putNextEntry(new ZipEntry(MANIFEST));
                manifest.write(jarOutputStream);
                jarOutputStream.closeEntry();
            }
            catch (IOException iOException) {
                this.m_zipSucceeded = false;
                this.handleEntryError(MANIFEST, iOException);
            }
            if (this.m_deleteTempDir && !this.m_tempDirectory.delete()) {
                this.m_log.println("Unable to delete temporary directory " + this.m_tempDirectory);
            }
            jarOutputStream.close();
        }
        catch (Root.Fault fault) {
            throw new Fault("Fault thrown while generating master zip\n" + fault.getMessage());
        }
        if (this.m_verbosity == 2) {
            if (this.m_zipSucceeded) {
                this.m_log.println("Master Zip file " + this.m_archiveFile.getAbsolutePath() + " completed with no errors");
            } else {
                this.m_log.println("Master Zip file " + this.m_archiveFile.getAbsolutePath() + " completed with errors");
            }
        }
        this.m_log.flush();
        return this.m_zipSucceeded;
    }

    public boolean unzip(File file) throws IllegalStateException, IOException, Fault {
        ZipFile zipFile;
        if (this.m_archiveFile == null) {
            throw new Fault("The archive file to be unzipped has not been set.");
        }
        try {
            zipFile = new ZipFile(this.m_archiveFile);
        }
        catch (ZipException zipException) {
            throw new IOException(this.m_archiveFile.getAbsolutePath() + "does not appear to be a zip or jar file");
        }
        if (this.m_mode != 1) {
            if (file == null) {
                throw new Fault("The target directory can not be null");
            }
            if (!file.isDirectory()) {
                throw new IllegalStateException("Target directory " + file.getAbsolutePath() + " does not appear to be a directory ");
            }
            if (!file.canWrite()) {
                throw new IllegalStateException("Target directory " + file.getAbsolutePath() + "is not writable.");
            }
        }
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            try {
                ZipEntry zipEntry = enumeration.nextElement();
                if (this.m_verbosity == 2) {
                    this.m_log.println("Examining " + zipEntry.getName() + " for sub-entries.");
                }
                try {
                    if (this.inflate(new ZipInputStream(zipFile.getInputStream(zipEntry)), file)) continue;
                    this.m_unZipSucceeded = false;
                }
                catch (IOException iOException) {
                    this.m_unZipSucceeded = false;
                    this.handleEntryError(zipEntry.getName(), iOException);
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new Fault("No such element thrown while unzipping entries.");
            }
        }
        this.m_log.flush();
        return this.m_unZipSucceeded;
    }

    public boolean list() throws IllegalStateException, IOException, Fault {
        this.m_mode = 1;
        return this.unzip(null);
    }

    private Iterator generateEntries(File[] fileArray) throws IllegalStateException, IOException, Root.Fault {
        TreeMap treeMap = new TreeMap();
        for (int i = 0; i < fileArray.length; ++i) {
            treeMap.putAll(new Root(fileArray[i]).getNodes());
        }
        this.m_totalNumberOfFiles = treeMap.size();
        return treeMap.entrySet().iterator();
    }

    private ArrayList generateSubzips(Iterator iterator) throws IllegalStateException, IOException, Fault {
        BigInteger[] bigIntegerArray;
        int n;
        Node node = null;
        Node node2 = null;
        ZipOutputStream zipOutputStream = null;
        int n2 = 0;
        BigInteger bigInteger = BigInteger.valueOf(this.m_totalNumberOfFiles);
        BigInteger bigInteger2 = BigInteger.valueOf(this.m_maxSubzipEntries);
        boolean bl = true;
        boolean bl2 = false;
        long l = 0L;
        if (this.m_tempDirectory == null) {
            long l2 = System.currentTimeMillis();
            File file = new File(System.getProperty("java.io.tmpdir"));
            this.m_tempDirectory = new File(file, MessageFormat.format("megazip-{0,date,yyMMdd-HHmmss}-{1}.dir", new Long(l2), new Long(l2 % 1000L)));
            if (!this.m_tempDirectory.mkdir()) {
                throw new IOException("Unable to create tempory directory " + this.m_tempDirectory.getAbsolutePath());
            }
        }
        if ((n = (bigIntegerArray = bigInteger.divideAndRemainder(bigInteger2))[1].compareTo(BigInteger.ZERO) > 0 ? bigIntegerArray[0].intValue() + 1 : bigIntegerArray[0].intValue()) > 65534) {
            throw new IllegalStateException("The current subzip file limit will result in the creation of more subzip files than can exist in megazip file");
        }
        ArrayList<Node> arrayList = new ArrayList<Node>(n);
        while (iterator.hasNext()) {
            if (bl) {
                bl2 = false;
                n2 = 0;
                this.m_subzipSize = 0L;
                bl = false;
                node = new Node(this.m_tempDirectory.getAbsolutePath(), new File(this.m_tempDirectory, "Data" + String.valueOf(arrayList.size() + 1) + ".zip"));
                zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(node.getFile())));
                if (this.m_verbosity == 2) {
                    this.m_log.println("Opening SubZip " + node.getRelativePath());
                }
            }
            Map.Entry entry = (Map.Entry)iterator.next();
            node2 = (Node)entry.getValue();
            try {
                l = this.deflate(zipOutputStream, node2, 8);
                if (l == -1L && this.m_maxSubzipSize > 0L) {
                    throw new Fault("Unable to determine compressed size of entry " + node2.getRelativePath());
                }
                if (this.m_verbosity == 2) {
                    this.m_log.println("   Added Entry " + node2.getRelativePath() + " to subZip " + node.getAbsolutePath());
                }
                if (++n2 == this.m_maxSubzipEntries || this.exceedsSizeMax(l)) {
                    bl = true;
                    zipOutputStream.close();
                    bl2 = true;
                    arrayList.add(node);
                    if (this.m_verbosity == 2) {
                        this.m_log.println("Closing SubZip " + node.getRelativePath() + "with " + n2 + " entries");
                    }
                }
            }
            catch (DeflateFault deflateFault) {
                this.m_zipSucceeded = false;
            }
            catch (IOException iOException) {
                throw new IOException("An IOException was thrown while attempting to add " + node2.getRelativePath() + " to subzip " + node.getAbsolutePath() + "\n" + iOException.getMessage());
            }
            iterator.remove();
        }
        if (!bl2) {
            bl = true;
            zipOutputStream.close();
            bl2 = true;
            arrayList.add(node);
            if (this.m_verbosity == 2) {
                this.m_log.println("Closing SubZip " + node.getRelativePath() + "with " + n2 + " entries");
            }
        }
        return arrayList;
    }

    private long deflate(ZipOutputStream zipOutputStream, Node node, int n) throws IOException, DeflateFault {
        return this.deflate(zipOutputStream, node.getFile(), node.getRelativePath(), n);
    }

    private long deflate(ZipOutputStream zipOutputStream, File file, String string, int n) throws IOException, DeflateFault {
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        }
        catch (IOException iOException) {
            this.handleEntryError(string, iOException);
            throw new DeflateFault("A fault was encountered while deflating " + string);
        }
        return this.deflate(zipOutputStream, bufferedInputStream, string, n);
    }

    private long deflate(ZipOutputStream zipOutputStream, InputStream inputStream, String string, int n) throws IOException, DeflateFault {
        long l = 0L;
        boolean bl = true;
        ZipEntry zipEntry = null;
        try {
            zipEntry = new ZipEntry(string);
            if (this.m_verbosity >= 1) {
                this.m_log.println("Deflating " + string);
            }
            if (n == 0) {
                int n2;
                byte[] byArray = new byte[]{};
                byte[] byArray2 = new byte[4096];
                byte[] byArray3 = null;
                while ((n2 = inputStream.read(byArray2, 0, byArray2.length)) != -1) {
                    byArray3 = new byte[n2 + byArray.length];
                    System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
                    System.arraycopy(byArray2, 0, byArray3, byArray.length, n2);
                    byArray = byArray3;
                }
                CRC32 cRC32 = new CRC32();
                cRC32.update(byArray);
                zipEntry.setMethod(0);
                zipEntry.setCrc(cRC32.getValue());
                zipEntry.setSize(byArray.length);
                inputStream = new BufferedInputStream(new ByteArrayInputStream(byArray));
            }
            zipOutputStream.putNextEntry(zipEntry);
            l = this.copyBytes(inputStream, zipOutputStream);
            zipEntry.setSize(l);
            zipEntry.setTime(System.currentTimeMillis());
            inputStream.close();
            zipOutputStream.closeEntry();
        }
        catch (IOException iOException) {
            bl = false;
            this.handleEntryError(string, iOException);
        }
        if (bl) {
            if (this.m_verbosity == 2) {
                this.m_log.println(zipEntry.getName() + " deflated");
            }
            return zipEntry.getCompressedSize();
        }
        throw new DeflateFault("A fault was encountered while deflating " + string);
    }

    private boolean inflate(ZipInputStream zipInputStream, File file) throws IOException {
        boolean bl = true;
        ZipEntry zipEntry;
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            String string = zipEntry.getName();
            if (this.m_mode == 1) {
                this.m_log.println(string);
                continue;
            }
            try {
                File file2 = new File(file, string);
                File file3 = new File(file2.getParent());
                if (!file3.exists() && !file3.mkdirs()) {
                    bl = false;
                    throw new IOException("Unable to make parent directories for zip entry " + zipEntry.getName() + " in the target directory " + file.getAbsolutePath());
                }
                if (zipEntry.isDirectory()) {
                    if (!file2.mkdir()) {
                        bl = false;
                    }
                    throw new IOException("Unable to generate directory for zip entry " + zipEntry.getName() + " in the target directory " + file.getAbsolutePath());
                }
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
                this.copyBytes(zipInputStream, bufferedOutputStream);
                if (this.m_verbosity >= 1) {
                    this.m_log.println("Inflated " + zipEntry.getName());
                }
                bufferedOutputStream.close();
                zipInputStream.closeEntry();
                if (file2.isDirectory() || file2.setReadOnly()) continue;
                throw new IOException("Unable to set " + file2.getAbsolutePath() + " file permissions to read only.");
            }
            catch (IOException iOException) {
                bl = false;
                this.handleEntryError(string, iOException);
                continue;
            }
            break;
        }
        return bl;
    }

    private boolean exceedsSizeMax(long l) {
        if (this.m_maxSubzipSize == 0L) {
            return false;
        }
        this.m_subzipSize += l;
        return this.m_subzipSize >= this.m_maxSubzipSize;
    }

    private boolean exportClasses(JarOutputStream jarOutputStream) throws IOException, Fault {
        String string = System.getProperty("file.separator");
        String string2 = System.getProperty("path.separator");
        String string3 = System.getProperty("java.class.path");
        Iterator iterator = this.m_exportClasses.iterator();
        boolean bl = true;
        String string4 = null;
        String string5 = null;
        while (iterator.hasNext()) {
            StringTokenizer stringTokenizer = new StringTokenizer(string3, string2);
            boolean bl2 = false;
            InputStream inputStream = null;
            string4 = (String)iterator.next();
            string5 = string4.replace('.', string.charAt(0));
            try {
                if (this.m_verbosity == 2) {
                    this.m_log.println("looking for " + string5 + " on classpath");
                }
                while (stringTokenizer.hasMoreElements()) {
                    File file = new File((String)stringTokenizer.nextElement());
                    if (!file.exists()) continue;
                    if (file.isDirectory()) {
                        File file2 = new File(file, string5 + ".class");
                        if (!file2.exists()) continue;
                        bl2 = true;
                        inputStream = new BufferedInputStream(new FileInputStream(file2));
                        break;
                    }
                    JarFile jarFile = new JarFile(file);
                    JarEntry jarEntry = (JarEntry)jarFile.getEntry(string5 + ".class");
                    if (jarEntry == null) continue;
                    bl2 = true;
                    inputStream = jarFile.getInputStream(jarEntry);
                    break;
                }
                if (bl2) {
                    try {
                        this.deflate((ZipOutputStream)jarOutputStream, inputStream, string5 + ".class", 8);
                    }
                    catch (DeflateFault deflateFault) {
                        bl = false;
                    }
                    continue;
                }
                throw new IOException("Unable to find main or supporting class " + string4 + " on the class path.");
            }
            catch (IOException iOException) {
                bl = false;
                this.handleEntryError(string4, iOException);
            }
        }
        return bl;
    }

    private ArrayList generateClassList(File file) throws IOException {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        while ((string = bufferedReader.readLine()) != null) {
            arrayList.add(string);
            if (this.m_verbosity != 2) continue;
            this.m_log.println(string + " was added to list of classes to be exported");
        }
        return arrayList;
    }

    private long copyBytes(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        long l = 0L;
        byte[] byArray = new byte[4096];
        while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    private void handleEntryError(String string, IOException iOException) throws IOException {
        this.m_errorsMap.put(string, new EntryFault(string, iOException));
        if (this.m_errorHandleMode == 0) {
            return;
        }
        this.m_log.println("An error occured while processing entry " + string);
        this.m_log.println(iOException.getMessage());
        if (this.m_verbosity == 2) {
            iOException.printStackTrace(this.m_log);
        }
        if (this.m_errorHandleMode == 2) {
            throw iOException;
        }
    }

    class EntryFault
    extends Exception {
        private String m_entryName;
        private String m_exceptionMessage;

        private EntryFault() {
        }

        public EntryFault(String string, Exception exception) {
            this.m_entryName = string;
            this.m_exceptionMessage = exception.getMessage();
        }

        public String getEntry() {
            return this.m_entryName;
        }

        @Override
        public String getMessage() {
            return this.m_exceptionMessage;
        }
    }

    public static class DeflateFault
    extends Exception {
        DeflateFault(String string) {
            super(string);
        }
    }

    public static class Fault
    extends Exception {
        Fault(String string) {
            super(string);
        }
    }
}

