/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.ArrayList;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.core.queries.CoreMappedKeyMapContainerPolicy;
import org.eclipse.persistence.internal.core.sessions.CoreAbstractSession;
import org.eclipse.persistence.internal.oxm.ContainerValue;
import org.eclipse.persistence.internal.oxm.MappingNodeValue;
import org.eclipse.persistence.internal.oxm.Marshaller;
import org.eclipse.persistence.internal.oxm.NamespacePrefixMapper;
import org.eclipse.persistence.internal.oxm.NamespaceResolver;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.mappings.AnyAttributeMapping;
import org.eclipse.persistence.internal.oxm.record.MarshalContext;
import org.eclipse.persistence.internal.oxm.record.MarshalRecord;
import org.eclipse.persistence.internal.oxm.record.UnmarshalRecord;

public class XMLAnyAttributeMappingNodeValue
extends MappingNodeValue
implements ContainerValue {
    private AnyAttributeMapping xmlAnyAttributeMapping;
    private int index = -1;

    public XMLAnyAttributeMappingNodeValue(AnyAttributeMapping xmlAnyAttributeMapping) {
        this.xmlAnyAttributeMapping = xmlAnyAttributeMapping;
    }

    @Override
    public boolean isOwningNode(XPathFragment xPathFragment) {
        return xPathFragment == null;
    }

    @Override
    public boolean isWrapperAllowedAsCollectionName() {
        return false;
    }

    @Override
    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, CoreAbstractSession session, NamespaceResolver namespaceResolver) {
        Object iter;
        if (this.xmlAnyAttributeMapping.isReadOnly()) {
            return false;
        }
        Object collection = this.xmlAnyAttributeMapping.getAttributeValueFromObject(object);
        if (collection == null) {
            return false;
        }
        CoreMappedKeyMapContainerPolicy cp = this.getContainerPolicy();
        if (!cp.hasNext(iter = cp.iteratorFor(collection))) {
            return false;
        }
        XPathFragment groupingElements = marshalRecord.openStartGroupingElements(namespaceResolver);
        ArrayList<String> extraNamespaces = new ArrayList<String>();
        Object nr = marshalRecord.getNamespaceResolver();
        while (cp.hasNext(iter)) {
            Map.Entry entry = (Map.Entry)cp.nextEntry(iter, session);
            Object key = entry.getKey();
            if (!(key instanceof QName)) continue;
            QName name = (QName)key;
            String value = entry.getValue().toString();
            Object qualifiedName = name.getLocalPart();
            if (nr != null) {
                String prefix = ((NamespaceResolver)nr).resolveNamespaceURI(name.getNamespaceURI());
                if (prefix != null && !prefix.isEmpty()) {
                    qualifiedName = prefix + ":" + (String)qualifiedName;
                } else if (name.getNamespaceURI() != null && !name.getNamespaceURI().isEmpty()) {
                    String customPrefix;
                    String generatedPrefix = ((NamespaceResolver)nr).generatePrefix();
                    if (marshalRecord.hasCustomNamespaceMapper() && (customPrefix = ((NamespacePrefixMapper)((Marshaller)marshalRecord.getMarshaller()).getNamespacePrefixMapper()).getPreferredPrefix(name.getNamespaceURI(), generatedPrefix, true)) != null && !customPrefix.isEmpty()) {
                        generatedPrefix = customPrefix;
                    }
                    qualifiedName = generatedPrefix + ":" + (String)qualifiedName;
                    ((NamespaceResolver)nr).put(generatedPrefix, name.getNamespaceURI());
                    extraNamespaces.add(generatedPrefix);
                    marshalRecord.namespaceDeclaration(generatedPrefix, name.getNamespaceURI());
                }
            }
            if ("http://www.w3.org/2000/xmlns/".equals(name.getNamespaceURI())) {
                marshalRecord.namespaceDeclaration(name.getLocalPart(), name.getNamespaceURI());
                continue;
            }
            marshalRecord.attribute(name.getNamespaceURI(), name.getLocalPart(), (String)qualifiedName, value);
        }
        for (int i = 0; i < extraNamespaces.size(); ++i) {
            ((NamespaceResolver)marshalRecord.getNamespaceResolver()).removeNamespace((String)extraNamespaces.get(i));
        }
        marshalRecord.closeStartGroupingElements(groupingElements);
        return true;
    }

    @Override
    public void attribute(UnmarshalRecord unmarshalRecord, String namespaceURI, String localName, String value) {
        boolean includeAttribute = true;
        if (!this.xmlAnyAttributeMapping.isNamespaceDeclarationIncluded() && "http://www.w3.org/2000/xmlns/".equals(namespaceURI)) {
            includeAttribute = false;
        } else if (!this.xmlAnyAttributeMapping.isSchemaInstanceIncluded() && "http://www.w3.org/2001/XMLSchema-instance".equals(namespaceURI)) {
            includeAttribute = false;
        }
        if (includeAttribute) {
            Object cp = this.xmlAnyAttributeMapping.getContainerPolicy();
            Object containerInstance = unmarshalRecord.getContainerInstance(this);
            QName key = new QName(namespaceURI, localName);
            cp.addInto(key, value, containerInstance, unmarshalRecord.getSession());
        }
    }

    @Override
    public Object getContainerInstance() {
        return this.xmlAnyAttributeMapping.getContainerPolicy().containerInstance();
    }

    @Override
    public void setContainerInstance(Object object, Object container) {
        this.xmlAnyAttributeMapping.setAttributeValueInObject(object, container);
    }

    @Override
    public CoreMappedKeyMapContainerPolicy getContainerPolicy() {
        return (CoreMappedKeyMapContainerPolicy)this.xmlAnyAttributeMapping.getContainerPolicy();
    }

    @Override
    public boolean isContainerValue() {
        return true;
    }

    @Override
    public boolean marshalSingleValue(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, Object value, CoreAbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext) {
        return true;
    }

    @Override
    public AnyAttributeMapping getMapping() {
        return this.xmlAnyAttributeMapping;
    }

    @Override
    public boolean getReuseContainer() {
        return this.getMapping().getReuseContainer();
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public boolean isDefaultEmptyContainer() {
        return this.getMapping().isDefaultEmptyContainer();
    }
}

