/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.jdke;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactoryBuilder;
import javax.naming.spi.NamingManager;

public final class JavaApiGaps {
    private static final SecurityManager SECURITY_MANAGER = System.getSecurityManager();
    private static final String FIELD_INITCTX_FACTORY_BUILDER = "initctx_factory_builder";

    private JavaApiGaps() {
    }

    public static void setInitialContextFactoryBuilder(InitialContextFactoryBuilder builder) throws NamingException {
        NamingAction action = () -> NamingManager.setInitialContextFactoryBuilder(builder);
        if (SECURITY_MANAGER == null) {
            action.execute();
            return;
        }
        JavaApiGaps.doPrivilegedNamingAction(action);
    }

    public static void unsetInitialContextFactoryBuilder() throws NamingException {
        NamingAction action = () -> JavaApiGaps.set(NamingManager.class, FIELD_INITCTX_FACTORY_BUILDER, null);
        if (SECURITY_MANAGER == null) {
            action.execute();
            return;
        }
        JavaApiGaps.doPrivilegedNamingAction(action);
    }

    private static void set(Class<?> type, String fieldName, Object value) {
        try {
            Field field = type.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(null, value);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Reflection to the field " + type.getCanonicalName() + "." + fieldName + " failed.", e);
        }
    }

    private static void doPrivilegedNamingAction(NamingAction action) throws NamingException {
        try {
            AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof NamingException) {
                throw (NamingException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException("Failed to execute privileged naming action.", e);
        }
    }

    @FunctionalInterface
    private static interface NamingAction
    extends PrivilegedExceptionAction<Void> {
        @Override
        default public Void run() throws PrivilegedActionException {
            try {
                this.execute();
                return null;
            }
            catch (Exception e) {
                throw new PrivilegedActionException(e);
            }
        }

        public void execute() throws NamingException;
    }
}

