/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.security;

import java.security.Security;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.LogFacade;
import org.apache.catalina.startup.CatalinaProperties;

public final class SecurityConfig {
    private static volatile SecurityConfig singleton;
    private static final Logger log;
    private static final String PACKAGE_ACCESS = "sun.,org.apache.catalina.,org.glassfish.wasp.,org.glassfish.grizzly.tcp.,org.glassfish.grizzly.";
    private static final String PACKAGE_DEFINITION = "java.,sun.,org.apache.catalina.,org.glassfish.grizzly.tcp.,org.glassfish.grizzly.,org.glassfish.wasp.";
    private String packageDefinition;
    private String packageAccess;

    private SecurityConfig() {
        try {
            this.packageDefinition = CatalinaProperties.getProperty("package.definition");
            this.packageAccess = CatalinaProperties.getProperty("package.access");
        }
        catch (Exception ex) {
            log.log(Level.FINE, "Unable to load properties using CatalinaProperties", ex);
        }
    }

    public static SecurityConfig newInstance() {
        if (singleton == null) {
            singleton = new SecurityConfig();
        }
        return singleton;
    }

    public void setPackageAccess() {
        if (this.packageAccess == null) {
            this.appendSecurityProperty("package.access", PACKAGE_ACCESS);
        } else {
            this.appendSecurityProperty("package.access", this.packageAccess);
        }
    }

    public void setPackageDefinition() {
        if (this.packageDefinition == null) {
            this.appendSecurityProperty("package.definition", PACKAGE_DEFINITION);
        } else {
            this.appendSecurityProperty("package.definition", this.packageDefinition);
        }
    }

    private void appendSecurityProperty(String property, String packages) {
        if (System.getSecurityManager() == null) {
            return;
        }
        log.log(Level.CONFIG, "appendSecurityProperty(property={0}, packageList={1})", new Object[]{property, packages});
        Object definition = Security.getProperty(property);
        if (definition != null && !((String)definition).isEmpty()) {
            definition = (String)definition + ",";
        }
        Security.setProperty(property, (String)definition + packages);
    }

    static {
        log = LogFacade.getLogger();
    }
}

