/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurrent.runtime;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.deployment.types.ConcurrencyContextType;
import com.sun.enterprise.deployment.types.StandardContextType;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.transaction.api.JavaEETransaction;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import com.sun.enterprise.util.Utility;
import jakarta.enterprise.concurrent.ContextService;
import jakarta.enterprise.concurrent.spi.ThreadContextSnapshot;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.concurrent.runtime.ConcurrentRuntime;
import org.glassfish.concurrent.runtime.ContextSetup;
import org.glassfish.concurrent.runtime.InvocationContext;
import org.glassfish.concurrent.runtime.LogFacade;
import org.glassfish.concurrent.runtime.ThreadMgmtData;
import org.glassfish.enterprise.concurrent.spi.ContextHandle;
import org.glassfish.enterprise.concurrent.spi.ContextSetupProvider;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.deployment.Deployment;

public class ContextSetupProviderImpl
implements ContextSetupProvider {
    private static final long serialVersionUID = -2043616384112372091L;
    private static final Logger LOG = LogFacade.getLogger();
    private transient InvocationManager invocationManager;
    private transient Deployment deployment;
    private transient ApplicationRegistry applicationRegistry;
    private transient Applications applications;
    private transient JavaEETransactionManager transactionManager;
    private final ContextSetup setup;

    public ContextSetupProviderImpl(Set<ConcurrencyContextType> propagated, Set<ConcurrencyContextType> cleared, Set<ConcurrencyContextType> unchanged) {
        this.setup = new ContextSetup(propagated, cleared, unchanged);
        ConcurrentRuntime runtime = ConcurrentRuntime.getRuntime();
        this.invocationManager = runtime.getInvocationManager();
        this.deployment = runtime.getDeployment();
        this.applicationRegistry = runtime.getApplicationRegistry();
        this.applications = runtime.getApplications();
        this.transactionManager = runtime.getTransactionManager();
    }

    public ContextSetup getContextSetup() {
        return this.setup;
    }

    public ContextHandle saveContext(ContextService contextService) {
        return this.saveContext(contextService, Map.of());
    }

    public ContextHandle saveContext(ContextService contextService, Map<String, String> executionProperties) {
        LOG.log(Level.FINEST, "saveContext(contextService={0}, executionProperties={1})", new Object[]{contextService, executionProperties});
        ClassLoader classLoader = Utility.getClassLoader();
        this.setup.reloadProviders(classLoader);
        ClassLoader contextClassloader = this.setup.isPropagated(StandardContextType.Classloader) ? classLoader : null;
        Object securityContext = this.setup.isPropagated(StandardContextType.Security) ? SecurityContext.getCurrent() : null;
        return this.createInvocationContext(executionProperties, contextClassloader, (SecurityContext)securityContext);
    }

    public ContextHandle setup(ContextHandle contextHandle) {
        SecurityContext resetSecurityContext;
        LOG.log(Level.FINEST, "setup(contextHandle={0})", contextHandle);
        if (!(contextHandle instanceof InvocationContext)) {
            LOG.log(Level.SEVERE, "AS-CONCURRENT-00002");
            return null;
        }
        InvocationContext invocationCtx = (InvocationContext)contextHandle;
        String appName = null;
        ComponentInvocation invocation = invocationCtx.getInvocation();
        if (invocation != null) {
            appName = invocation.getAppName();
        }
        this.verifyApplicationEnabled(appName);
        ClassLoader resetClassLoader = invocationCtx.getContextClassLoader() != null ? Utility.setContextClassLoader((ClassLoader)invocationCtx.getContextClassLoader()) : null;
        if (invocationCtx.getSecurityContext() == null || this.setup.isUnchanged(StandardContextType.Security)) {
            resetSecurityContext = null;
        } else {
            resetSecurityContext = SecurityContext.getCurrent();
            SecurityContext.setCurrent((SecurityContext)invocationCtx.getSecurityContext());
        }
        if (invocation != null) {
            invocation.setResourceTableKey((Object)new PairKey(invocation.getInstance(), Thread.currentThread()));
            this.invocationManager.preInvoke(invocation);
        }
        if (this.transactionManager != null && this.setup.isClear(StandardContextType.WorkArea)) {
            this.transactionManager.clearThreadTx();
        }
        ThreadMgmtData threadManagement = ThreadMgmtData.createNextGeneration(invocationCtx.getContextData());
        return new InvocationContext(invocation, resetClassLoader, resetSecurityContext, invocationCtx.isUseTransactionOfExecutionThread(), threadManagement);
    }

    public void reset(ContextHandle contextHandle) {
        LOG.log(Level.FINEST, "reset(contextHandle={0})", contextHandle);
        if (!(contextHandle instanceof InvocationContext)) {
            LOG.log(Level.SEVERE, "AS-CONCURRENT-00002");
            return;
        }
        InvocationContext invocationContext = (InvocationContext)contextHandle;
        invocationContext.getContextData().endContext();
        if (invocationContext.getContextClassLoader() != null) {
            Utility.setContextClassLoader((ClassLoader)invocationContext.getContextClassLoader());
        }
        if (invocationContext.getSecurityContext() != null) {
            SecurityContext.setCurrent((SecurityContext)invocationContext.getSecurityContext());
        }
        if (invocationContext.getInvocation() != null && !invocationContext.isUseTransactionOfExecutionThread()) {
            this.invocationManager.postInvoke(invocationContext.getInvocation());
        }
        if (this.setup.isClear(StandardContextType.WorkArea) && this.transactionManager != null) {
            JavaEETransaction transaction = this.transactionManager.getCurrentTransaction();
            if (transaction != null) {
                try {
                    int status = transaction.getStatus();
                    if (status == 0) {
                        this.transactionManager.commit();
                    } else if (status == 1) {
                        this.transactionManager.rollback();
                    }
                }
                catch (Exception ex) {
                    LOG.log(Level.SEVERE, "Cannot commit or rollback the transaction or get it's status.", ex);
                }
            }
            this.transactionManager.clearThreadTx();
        }
    }

    private ContextHandle createInvocationContext(Map<String, String> executionProperties, ClassLoader classloader, SecurityContext securityCtx) {
        boolean useTxOfExecutionThread = this.useTransactionOfExecutionThread(executionProperties);
        List<ThreadContextSnapshot> threadCtxSnapshots = this.setup.getThreadContextSnapshots(executionProperties);
        ComponentInvocation invocation = this.getSavedInvocation();
        ThreadMgmtData threadMgmtData = new ThreadMgmtData(threadCtxSnapshots);
        return new InvocationContext(invocation, classloader, securityCtx, useTxOfExecutionThread, threadMgmtData);
    }

    private boolean useTransactionOfExecutionThread(Map<String, String> executionProperties) {
        return this.transactionManager == null && "USE_TRANSACTION_OF_EXECUTION_THREAD".equals(this.getTransactionExecutionProperty(executionProperties)) || this.setup.isUnchanged(StandardContextType.WorkArea);
    }

    private String getTransactionExecutionProperty(Map<String, String> executionProperties) {
        if (executionProperties == null || executionProperties.isEmpty()) {
            return "SUSPEND";
        }
        return executionProperties.getOrDefault("jakarta.enterprise.concurrent.TRANSACTION", "SUSPEND");
    }

    private ComponentInvocation getSavedInvocation() {
        ComponentInvocation currentInvocation = this.invocationManager.getCurrentInvocation();
        if (currentInvocation != null) {
            if (this.setup.isClear(StandardContextType.JNDI)) {
                return new ComponentInvocation();
            }
            if (this.setup.isPropagated(StandardContextType.JNDI)) {
                return this.cloneComponentInvocation(currentInvocation);
            }
        }
        return null;
    }

    private void verifyApplicationEnabled(String appId) {
        if (appId != null) {
            boolean enabled;
            Application application = this.applications.getApplication(appId);
            if (application != null) {
                enabled = this.deployment.isAppEnabled(application);
            } else {
                boolean bl = enabled = this.applicationRegistry.get(appId) != null;
            }
            if (!enabled) {
                IllegalStateException ex = new IllegalStateException("Module " + appId + " is disabled");
                LOG.log(Level.WARNING, "Context handle not in valid state. Do not run the task. " + ex.getMessage(), ex);
                throw ex;
            }
        }
    }

    private ComponentInvocation cloneComponentInvocation(ComponentInvocation currentInvocation) {
        ComponentInvocation clonedInvocation = currentInvocation.clone();
        clonedInvocation.setResourceTableKey(null);
        clonedInvocation.clearRegistry();
        clonedInvocation.instance = currentInvocation.getInstance();
        return clonedInvocation;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeBoolean(this.transactionManager == null);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        boolean nullTransactionManager = in.readBoolean();
        ConcurrentRuntime concurrentRuntime = ConcurrentRuntime.getRuntime();
        this.invocationManager = concurrentRuntime.getInvocationManager();
        this.applicationRegistry = concurrentRuntime.getApplicationRegistry();
        this.deployment = concurrentRuntime.getDeployment();
        this.applications = concurrentRuntime.getApplications();
        if (!nullTransactionManager) {
            this.transactionManager = concurrentRuntime.getTransactionManager();
        }
    }

    private static class PairKey {
        private final Object instance;
        private final Thread thread;
        int hCode;

        private PairKey(Object inst, Thread thr) {
            this.instance = inst;
            this.thread = thr;
            if (inst != null) {
                this.hCode = 7 * inst.hashCode();
            }
            if (thr != null) {
                this.hCode += thr.hashCode();
            }
        }

        public int hashCode() {
            return this.hCode;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            boolean eq = false;
            if (obj instanceof PairKey) {
                PairKey p = (PairKey)obj;
                if (this.instance != null) {
                    eq = this.instance.equals(p.instance);
                } else {
                    boolean bl = eq = p.instance == null;
                }
                if (eq) {
                    eq = this.thread != null ? this.thread.equals(p.thread) : p.thread == null;
                }
            }
            return eq;
        }
    }
}

