/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.io.FormatableArrayHolder;
import org.apache.derby.iapi.services.io.FormatableIntHolder;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.ExpressionClassBuilderInterface;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizablePredicate;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.BaseJoinStrategy;
import org.apache.derby.impl.sql.compile.BaseTableNumbersVisitor;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.ProjectRestrictNode;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SingleChildResultSetNode;
import org.apache.derby.shared.common.error.StandardException;

class HashJoinStrategy
extends BaseJoinStrategy {
    HashJoinStrategy() {
    }

    @Override
    public boolean feasible(Optimizable optimizable, OptimizablePredicateList optimizablePredicateList, Optimizer optimizer) throws StandardException {
        Object object;
        ConglomerateDescriptor conglomerateDescriptor = null;
        if (!optimizable.isMaterializable()) {
            if (optimizable.optimizerTracingIsOn()) {
                optimizable.getOptimizerTracer().traceSkipUnmaterializableHashJoin();
            }
            return false;
        }
        if (optimizable.isTargetTable()) {
            return false;
        }
        if (optimizablePredicateList != null && optimizablePredicateList.size() > 0 && !(optimizable instanceof FromBaseTable)) {
            object = (FromTable)optimizable;
            JBitSet jBitSet = new JBitSet(((ResultSetNode)object).getReferencedTableMap().size());
            BaseTableNumbersVisitor baseTableNumbersVisitor = new BaseTableNumbersVisitor(jBitSet);
            ((QueryTreeNode)object).accept(baseTableNumbersVisitor);
            JBitSet jBitSet2 = new JBitSet(jBitSet.size());
            for (int i = 0; i < optimizablePredicateList.size(); ++i) {
                Predicate predicate = (Predicate)optimizablePredicateList.getOptPredicate(i);
                if (!predicate.isJoinPredicate()) continue;
                jBitSet2.or(predicate.getReferencedSet());
            }
            jBitSet.and(jBitSet2);
            if (jBitSet.getFirstSetBit() != -1) {
                return false;
            }
        }
        if (optimizable.isBaseTable()) {
            conglomerateDescriptor = optimizable.getCurrentAccessPath().getConglomerateDescriptor();
        }
        return (object = (Object)this.findHashKeyColumns(optimizable, conglomerateDescriptor, optimizablePredicateList)) != null;
    }

    @Override
    public boolean ignoreBulkFetch() {
        return true;
    }

    @Override
    public boolean multiplyBaseCostByOuterRows() {
        return false;
    }

    @Override
    public OptimizablePredicateList getBasePredicates(OptimizablePredicateList optimizablePredicateList, OptimizablePredicateList optimizablePredicateList2, Optimizable optimizable) throws StandardException {
        for (int i = optimizablePredicateList.size() - 1; i >= 0; --i) {
            OptimizablePredicate optimizablePredicate = optimizablePredicateList.getOptPredicate(i);
            if (!optimizable.getReferencedTableMap().contains(optimizablePredicate.getReferencedMap())) continue;
            optimizablePredicateList2.addOptPredicate(optimizablePredicate);
            optimizablePredicateList.removeOptPredicate(i);
        }
        optimizablePredicateList2.classify(optimizable, optimizable.getCurrentAccessPath().getConglomerateDescriptor());
        return optimizablePredicateList2;
    }

    @Override
    public double nonBasePredicateSelectivity(Optimizable optimizable, OptimizablePredicateList optimizablePredicateList) throws StandardException {
        double d = 1.0;
        if (optimizablePredicateList != null) {
            for (int i = 0; i < optimizablePredicateList.size(); ++i) {
                if (optimizablePredicateList.isRedundantPredicate(i)) continue;
                d *= optimizablePredicateList.getOptPredicate(i).selectivity(optimizable);
            }
        }
        return d;
    }

    @Override
    public void putBasePredicates(OptimizablePredicateList optimizablePredicateList, OptimizablePredicateList optimizablePredicateList2) throws StandardException {
        for (int i = optimizablePredicateList2.size() - 1; i >= 0; --i) {
            OptimizablePredicate optimizablePredicate = optimizablePredicateList2.getOptPredicate(i);
            optimizablePredicateList.addOptPredicate(optimizablePredicate);
            optimizablePredicateList2.removeOptPredicate(i);
        }
    }

    @Override
    public void estimateCost(Optimizable optimizable, OptimizablePredicateList optimizablePredicateList, ConglomerateDescriptor conglomerateDescriptor, CostEstimate costEstimate, Optimizer optimizer, CostEstimate costEstimate2) {
    }

    @Override
    public int maxCapacity(int n, int n2, double d) {
        if (n >= 0) {
            return n;
        }
        if ((d += (double)ClassSize.estimateHashEntrySize()) <= 1.0) {
            return n2;
        }
        return (int)((double)n2 / d);
    }

    @Override
    public String getName() {
        return "HASH";
    }

    @Override
    public int scanCostType() {
        return 1;
    }

    @Override
    public String getOperatorSymbol() {
        return "#";
    }

    @Override
    public String resultSetMethodName(boolean bl, boolean bl2, boolean bl3) {
        return "getHashScanResultSet";
    }

    @Override
    public String joinResultSetMethodName() {
        return "getHashJoinResultSet";
    }

    @Override
    public String halfOuterJoinResultSetMethodName() {
        return "getHashLeftOuterJoinResultSet";
    }

    @Override
    public int getScanArgs(TransactionController transactionController, MethodBuilder methodBuilder, Optimizable optimizable, OptimizablePredicateList optimizablePredicateList, OptimizablePredicateList optimizablePredicateList2, ExpressionClassBuilderInterface expressionClassBuilderInterface, int n, int n2, int n3, int n4, int n5, boolean bl, int n6, int n7, boolean bl2) throws StandardException {
        ExpressionClassBuilder expressionClassBuilder = (ExpressionClassBuilder)expressionClassBuilderInterface;
        this.fillInScanArgs1(transactionController, methodBuilder, optimizable, optimizablePredicateList, expressionClassBuilder, n2);
        optimizablePredicateList2.generateQualifiers(expressionClassBuilder, methodBuilder, optimizable, true);
        methodBuilder.push(optimizable.initialCapacity());
        methodBuilder.push(optimizable.loadFactor());
        methodBuilder.push(optimizable.maxCapacity(this, n7));
        int[] nArray = optimizable.hashKeyColumns();
        Object[] objectArray = FormatableIntHolder.getFormatableIntHolders(nArray);
        FormatableArrayHolder formatableArrayHolder = new FormatableArrayHolder(objectArray);
        int n8 = expressionClassBuilder.addItem(formatableArrayHolder);
        methodBuilder.push(n8);
        this.fillInScanArgs2(methodBuilder, optimizable, n, n3, n4, n5, bl, n6);
        return 28;
    }

    @Override
    public void divideUpPredicateLists(Optimizable optimizable, OptimizablePredicateList optimizablePredicateList, OptimizablePredicateList optimizablePredicateList2, OptimizablePredicateList optimizablePredicateList3, OptimizablePredicateList optimizablePredicateList4, DataDictionary dataDictionary) throws StandardException {
        int n;
        Object object;
        int n2;
        optimizablePredicateList.copyPredicatesToOtherList(optimizablePredicateList4);
        ConglomerateDescriptor conglomerateDescriptor = optimizable.getTrulyTheBestAccessPath().getConglomerateDescriptor();
        optimizablePredicateList.transferPredicates(optimizablePredicateList2, optimizable.getReferencedTableMap(), optimizable);
        for (n2 = optimizablePredicateList2.size() - 1; n2 >= 0; --n2) {
            object = (Predicate)optimizablePredicateList2.getOptPredicate(n2);
            if (((Predicate)object).isStoreQualifier() || ((Predicate)object).isStartKey() || ((Predicate)object).isStopKey()) continue;
            optimizablePredicateList2.removeOptPredicate(n2);
        }
        for (n2 = optimizablePredicateList.size() - 1; n2 >= 0; --n2) {
            object = (Predicate)optimizablePredicateList.getOptPredicate(n2);
            if (((Predicate)object).isStoreQualifier()) continue;
            optimizablePredicateList.removeOptPredicate(n2);
        }
        optimizablePredicateList.copyPredicatesToOtherList(optimizablePredicateList3);
        Optimizable optimizable2 = optimizable;
        if (optimizable instanceof ProjectRestrictNode && ((SingleChildResultSetNode)(object = (ProjectRestrictNode)optimizable)).getChildResult() instanceof Optimizable) {
            optimizable2 = (Optimizable)((Object)((SingleChildResultSetNode)object).getChildResult());
        }
        if ((object = (Object)this.findHashKeyColumns(optimizable2, conglomerateDescriptor, optimizablePredicateList3)) == null) {
            String string = conglomerateDescriptor != null && conglomerateDescriptor.isIndex() ? conglomerateDescriptor.getConglomerateName() : optimizable.getBaseTableName();
            throw StandardException.newException("42Y63", string, optimizable.getBaseTableName());
        }
        optimizable.setHashKeyColumns((int[])object);
        optimizablePredicateList3.markAllPredicatesQualifiers();
        int[] nArray = new int[((Object)object).length];
        if (conglomerateDescriptor != null && conglomerateDescriptor.isIndex()) {
            for (n = 0; n < ((Object)object).length; ++n) {
                nArray[n] = conglomerateDescriptor.getIndexDescriptor().baseColumnPositions()[object[n]];
            }
        } else {
            for (n = 0; n < ((Object)object).length; ++n) {
                nArray[n] = (int)(object[n] + true);
            }
        }
        for (n = ((Object)object).length - 1; n >= 0; --n) {
            optimizablePredicateList3.putOptimizableEqualityPredicateFirst(optimizable, nArray[n]);
        }
    }

    @Override
    public boolean isHashJoin() {
        return true;
    }

    @Override
    public boolean doesMaterialization() {
        return true;
    }

    private int[] findHashKeyColumns(Optimizable optimizable, ConglomerateDescriptor conglomerateDescriptor, OptimizablePredicateList optimizablePredicateList) throws StandardException {
        int n;
        int[] nArray;
        if (optimizablePredicateList == null) {
            return null;
        }
        if (conglomerateDescriptor == null) {
            nArray = new int[optimizable.getNumColumnsReturned()];
            for (n = 0; n < nArray.length; ++n) {
                nArray[n] = n + 1;
            }
        } else if (conglomerateDescriptor.isIndex()) {
            nArray = conglomerateDescriptor.getIndexDescriptor().baseColumnPositions();
        } else {
            nArray = new int[optimizable.getTableDescriptor().getNumberOfColumns()];
            for (n = 0; n < nArray.length; ++n) {
                nArray[n] = n + 1;
            }
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < nArray.length; ++i) {
            if (!optimizablePredicateList.hasOptimizableEquijoin(optimizable, nArray[i])) continue;
            arrayList.add(i);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        int[] nArray2 = new int[arrayList.size()];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = (Integer)arrayList.get(i);
        }
        return nArray2;
    }

    public String toString() {
        return this.getName();
    }
}

