/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.epicyro.config.servlet.sam;

import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.AuthStatus;
import jakarta.security.auth.message.MessageInfo;
import jakarta.security.auth.message.MessagePolicy;
import jakarta.security.auth.message.callback.CallerPrincipalCallback;
import jakarta.security.auth.message.callback.GroupPrincipalCallback;
import jakarta.security.auth.message.callback.PasswordValidationCallback;
import jakarta.security.auth.message.module.ServerAuthModule;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import org.glassfish.epicyro.config.helper.Caller;
import org.glassfish.epicyro.config.servlet.sam.AuthenticationData;
import org.glassfish.epicyro.config.servlet.sam.HttpServletRequestDelegator;
import org.glassfish.epicyro.config.servlet.sam.RequestData;
import org.glassfish.epicyro.config.servlet.sam.Utils;

public class FormServerAuthModule
implements ServerAuthModule {
    private static final String IS_MANDATORY = "jakarta.security.auth.message.MessagePolicy.isMandatory";
    public static final String IS_AUTHENTICATION = "org.glassfish.elios.security.message.request.authentication";
    public static final String IS_NEW_AUTHENTICATION = "org.glassfish.elios.security.message.request.new.authentication";
    private static final String ORIGINAL_REQUEST_DATA_SESSION_NAME = "org.glassfish.elios.original.request";
    private static final String AUTHENTICATION_DATA_SESSION_NAME = "org.glassfish.elios.authentication";
    private static final String CALLER_INITIATED_AUTHENTICATION_SESSION_NAME = "org.glassfish.elios.caller_initiated_authentication";
    private CallbackHandler handler;
    private String loginPage = "";
    private String errorPage = "";
    boolean useForwardToLogin = true;

    public Class<?>[] getSupportedMessageTypes() {
        return new Class[]{HttpServletRequest.class, HttpServletResponse.class};
    }

    public void initialize(MessagePolicy requestPolicy, MessagePolicy responsePolicy, CallbackHandler handler, Map options) throws AuthException {
        this.handler = handler;
        this.loginPage = (String)options.get("formLoginPage");
        this.errorPage = (String)options.get("formErrorPage");
    }

    public AuthStatus validateRequest(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws AuthException {
        try {
            return this.validateRequestAutoApplySession(messageInfo, clientSubject, serviceSubject);
        }
        catch (Exception e) {
            AuthException authException = new AuthException();
            authException.initCause((Throwable)e);
            throw authException;
        }
    }

    public AuthStatus secureResponse(MessageInfo messageInfo, Subject serviceSubject) throws AuthException {
        return AuthStatus.SEND_SUCCESS;
    }

    public void cleanSubject(MessageInfo messageInfo, Subject subject) throws AuthException {
    }

    public AuthStatus validateRequestAutoApplySession(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws Exception {
        Principal userPrincipal = this.getPrincipal((HttpServletRequest)messageInfo.getRequestMessage());
        if (userPrincipal != null) {
            this.handler.handle(new Callback[]{new CallerPrincipalCallback(clientSubject, userPrincipal)});
            return AuthStatus.SUCCESS;
        }
        AuthStatus outcome = this.validateRequestLoginToContinue(messageInfo, clientSubject, serviceSubject);
        if (AuthStatus.SUCCESS.equals(outcome)) {
            messageInfo.getMap().put("jakarta.servlet.http.registerSession", Boolean.TRUE.toString());
        }
        return outcome;
    }

    public AuthStatus validateRequestLoginToContinue(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws Exception {
        HttpServletRequest request = (HttpServletRequest)messageInfo.getRequestMessage();
        this.tryClean(messageInfo, request);
        if (this.isCallerInitiatedAuthentication(request)) {
            return this.processCallerInitiatedAuthentication(messageInfo, clientSubject, serviceSubject);
        }
        return this.processContainerInitiatedAuthentication(messageInfo, clientSubject, serviceSubject);
    }

    public AuthStatus validateRequestForm(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws Exception {
        HttpServletRequest request = (HttpServletRequest)messageInfo.getRequestMessage();
        if (!FormServerAuthModule.isValidFormPostback(request)) {
            this.handler.handle(new Callback[]{new CallerPrincipalCallback(clientSubject, (Principal)null)});
            return AuthStatus.SUCCESS;
        }
        PasswordValidationCallback passwordValidation = new PasswordValidationCallback(clientSubject, request.getParameter("j_username"), request.getParameter("j_password").toCharArray());
        this.handler.handle(new Callback[]{passwordValidation});
        if (passwordValidation.getResult()) {
            return AuthStatus.SUCCESS;
        }
        return AuthStatus.SEND_FAILURE;
    }

    private void tryClean(MessageInfo messageInfo, HttpServletRequest request) {
        if (this.isOnProtectedURLWithStaleData(messageInfo, request)) {
            this.removeSavedRequest(request);
            this.removeCallerInitiatedAuthentication(request);
        }
        if (FormServerAuthModule.isNewAuthentication(request)) {
            this.saveCallerInitiatedAuthentication(request);
            this.removeSavedRequest(request);
            this.removeSavedAuthentication(request);
        }
    }

    private AuthStatus processCallerInitiatedAuthentication(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws Exception {
        AuthStatus authstatus;
        HttpServletRequest request = (HttpServletRequest)messageInfo.getRequestMessage();
        try {
            authstatus = this.validateRequestForm(messageInfo, clientSubject, serviceSubject);
        }
        catch (AuthException e) {
            authstatus = AuthStatus.SEND_FAILURE;
        }
        if (authstatus == AuthStatus.SUCCESS) {
            Caller caller = Caller.fromSubject(clientSubject);
            if (caller == null || caller.getCallerPrincipal() == null) {
                return AuthStatus.SUCCESS;
            }
            this.removeCallerInitiatedAuthentication(request);
        }
        return authstatus;
    }

    private AuthStatus processContainerInitiatedAuthentication(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws Exception {
        HttpServletRequest request = (HttpServletRequest)messageInfo.getRequestMessage();
        HttpServletResponse response = (HttpServletResponse)messageInfo.getResponseMessage();
        if (this.isOnInitialProtectedURL(messageInfo, request)) {
            this.saveRequest(request);
            if (this.useForwardToLogin) {
                return FormServerAuthModule.forward(this.loginPage, request, response);
            }
            return FormServerAuthModule.redirect(Utils.getBaseURL(request) + this.loginPage, response);
        }
        if (this.isOnLoginPostback(request)) {
            AuthStatus authstatus;
            try {
                authstatus = this.validateRequestForm(messageInfo, clientSubject, serviceSubject);
            }
            catch (AuthException e) {
                authstatus = AuthStatus.SEND_FAILURE;
            }
            if (authstatus == AuthStatus.SUCCESS) {
                Caller caller = Caller.fromSubject(clientSubject);
                if (caller == null || caller.getCallerPrincipal() == null || caller.getCallerPrincipal().getName() == null) {
                    return AuthStatus.SUCCESS;
                }
                RequestData savedRequest = this.getSavedRequest(request);
                if (!savedRequest.matchesRequest(request)) {
                    this.saveAuthentication(request, new AuthenticationData(caller.getCallerPrincipal(), caller.getGroups()));
                    return FormServerAuthModule.redirect(savedRequest.getFullRequestURL(), response);
                }
            } else {
                if (authstatus == AuthStatus.SEND_FAILURE) {
                    if (Utils.isEmpty(this.errorPage)) {
                        return authstatus;
                    }
                    return FormServerAuthModule.redirect(Utils.getBaseURL(request) + this.errorPage, response);
                }
                return authstatus;
            }
        }
        if (this.isOnOriginalURLAfterAuthenticate(request)) {
            RequestData requestData = this.removeSavedRequest(request);
            AuthenticationData authenticationData = this.removeSavedAuthentication(request);
            messageInfo.setRequestMessage((Object)new HttpServletRequestDelegator(request, requestData));
            this.handler.handle(new Callback[]{new CallerPrincipalCallback(clientSubject, authenticationData.getPrincipal()), new GroupPrincipalCallback(clientSubject, (String[])authenticationData.getGroups().toArray(String[]::new))});
            return AuthStatus.SUCCESS;
        }
        return this.validateRequestForm(messageInfo, clientSubject, serviceSubject);
    }

    private boolean isCallerInitiatedAuthentication(HttpServletRequest request) {
        return Boolean.TRUE.equals(this.getCallerInitiatedAuthentication(request));
    }

    private boolean isOnProtectedURLWithStaleData(MessageInfo messageInfo, HttpServletRequest request) {
        return FormServerAuthModule.isProtected(messageInfo) && !FormServerAuthModule.isAuthenticationRequest(request) && this.getSavedRequest(request) != null && this.getSavedAuthentication(request) == null && !request.getRequestURI().endsWith("j_security_check");
    }

    private boolean isOnInitialProtectedURL(MessageInfo messageInfo, HttpServletRequest request) {
        return FormServerAuthModule.isProtected(messageInfo) && !FormServerAuthModule.isAuthenticationRequest(request) && this.getSavedRequest(request) == null && this.getSavedAuthentication(request) == null && !request.getRequestURI().endsWith("j_security_check");
    }

    private boolean isOnLoginPostback(HttpServletRequest request) {
        return this.getSavedRequest(request) != null && this.getSavedAuthentication(request) == null;
    }

    private boolean isOnOriginalURLAfterAuthenticate(HttpServletRequest request) {
        RequestData savedRequest = this.getSavedRequest(request);
        AuthenticationData authenticationData = this.getSavedAuthentication(request);
        return Utils.notNull(savedRequest, authenticationData) && savedRequest.matchesRequest(request);
    }

    private void saveCallerInitiatedAuthentication(HttpServletRequest request) {
        request.getSession().setAttribute(CALLER_INITIATED_AUTHENTICATION_SESSION_NAME, (Object)Boolean.TRUE);
    }

    private Boolean getCallerInitiatedAuthentication(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return null;
        }
        return (Boolean)session.getAttribute(CALLER_INITIATED_AUTHENTICATION_SESSION_NAME);
    }

    private void removeCallerInitiatedAuthentication(HttpServletRequest request) {
        request.getSession().removeAttribute(CALLER_INITIATED_AUTHENTICATION_SESSION_NAME);
    }

    private void saveRequest(HttpServletRequest request) {
        request.getSession().setAttribute(ORIGINAL_REQUEST_DATA_SESSION_NAME, (Object)RequestData.of(request));
    }

    private RequestData getSavedRequest(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return null;
        }
        return (RequestData)session.getAttribute(ORIGINAL_REQUEST_DATA_SESSION_NAME);
    }

    private RequestData removeSavedRequest(HttpServletRequest request) {
        RequestData requestData = this.getSavedRequest(request);
        request.getSession().removeAttribute(ORIGINAL_REQUEST_DATA_SESSION_NAME);
        return requestData;
    }

    private void saveAuthentication(HttpServletRequest request, AuthenticationData authenticationData) {
        request.getSession().setAttribute(AUTHENTICATION_DATA_SESSION_NAME, (Object)authenticationData);
    }

    private AuthenticationData getSavedAuthentication(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return null;
        }
        return (AuthenticationData)session.getAttribute(AUTHENTICATION_DATA_SESSION_NAME);
    }

    private AuthenticationData removeSavedAuthentication(HttpServletRequest request) {
        AuthenticationData authenticationData = this.getSavedAuthentication(request);
        request.getSession().removeAttribute(AUTHENTICATION_DATA_SESSION_NAME);
        return authenticationData;
    }

    private static boolean isProtected(MessageInfo messageInfo) {
        return Boolean.valueOf((String)messageInfo.getMap().get(IS_MANDATORY));
    }

    private static boolean isAuthenticationRequest(HttpServletRequest request) {
        return Boolean.TRUE.equals(request.getAttribute(IS_AUTHENTICATION));
    }

    private static boolean isNewAuthentication(HttpServletRequest request) {
        return Boolean.TRUE.equals(request.getAttribute(IS_NEW_AUTHENTICATION));
    }

    private static AuthStatus redirect(String location, HttpServletResponse response) {
        Utils.redirect(response, location);
        return AuthStatus.SEND_CONTINUE;
    }

    private static AuthStatus forward(String path, HttpServletRequest request, HttpServletResponse response) {
        try {
            request.getRequestDispatcher(path).forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (ServletException | IOException e) {
            throw new IllegalStateException(e);
        }
        return AuthStatus.SEND_CONTINUE;
    }

    private static boolean isValidFormPostback(HttpServletRequest request) {
        return "POST".equals(request.getMethod()) && request.getRequestURI().endsWith("/j_security_check") && Utils.notNull(request.getParameter("j_username"), request.getParameter("j_password"));
    }

    private Principal getPrincipal(HttpServletRequest request) {
        return request.getUserPrincipal();
    }
}

