/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch.bc;

import com.jcraft.jsch.KEM;
import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMExtractor;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMKeyGenerationParameters;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMKeyPairGenerator;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMParameters;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMPublicKeyParameters;

abstract class MLKEM
implements KEM {
    protected MLKEMParameters params;
    MLKEMExtractor extractor;
    MLKEMPublicKeyParameters publicKey;

    MLKEM() {
    }

    @Override
    public void init() throws Exception {
        MLKEMKeyPairGenerator kpg = new MLKEMKeyPairGenerator();
        kpg.init((KeyGenerationParameters)new MLKEMKeyGenerationParameters(new SecureRandom(), this.params));
        AsymmetricCipherKeyPair kp = kpg.generateKeyPair();
        this.extractor = new MLKEMExtractor((MLKEMPrivateKeyParameters)kp.getPrivate());
        this.publicKey = (MLKEMPublicKeyParameters)kp.getPublic();
    }

    @Override
    public byte[] getPublicKey() throws Exception {
        return this.publicKey.getEncoded();
    }

    @Override
    public byte[] decapsulate(byte[] encapsulation) throws Exception {
        return this.extractor.extractSecret(encapsulation);
    }
}

