/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport;

import com.sun.corba.ee.impl.protocol.InvocationInfo;
import com.sun.corba.ee.impl.transport.ContactInfoListImpl;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.logging.ORBUtilSystemException;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.trace.Transport;
import com.sun.corba.ee.spi.transport.ContactInfo;
import com.sun.corba.ee.spi.transport.ContactInfoList;
import com.sun.corba.ee.spi.transport.ContactInfoListIterator;
import com.sun.corba.ee.spi.transport.IIOPPrimaryToContactInfo;
import com.sun.corba.ee.spi.transport.TcpTimeouts;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.glassfish.pfl.tf.spi.annotation.InfoMethod;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;

@Transport
public class ContactInfoListIteratorImpl
implements ContactInfoListIterator {
    protected static final ORBUtilSystemException wrapper = ORBUtilSystemException.self;
    protected ORB orb;
    protected ContactInfoList contactInfoList;
    protected RuntimeException failureException;
    private boolean usePRLB;
    protected TcpTimeouts tcpTimeouts;
    protected Iterator<ContactInfo> effectiveTargetIORIterator;
    protected ContactInfo previousContactInfo;
    protected boolean isAddrDispositionRetry;
    protected boolean retryWithPreviousContactInfo;
    protected IIOPPrimaryToContactInfo primaryToContactInfo;
    protected ContactInfo primaryContactInfo;
    protected List<ContactInfo> listOfContactInfos;
    protected TcpTimeouts.Waiter waiter;
    protected Set<ContactInfo> failedEndpoints;

    public ContactInfoListIteratorImpl(ORB orb, ContactInfoList corbaContactInfoList, ContactInfo primaryContactInfo, List listOfContactInfos, boolean usePerRequestLoadBalancing) {
        this.orb = orb;
        this.tcpTimeouts = orb.getORBData().getTransportTcpConnectTimeouts();
        this.contactInfoList = corbaContactInfoList;
        this.primaryContactInfo = primaryContactInfo;
        if (listOfContactInfos != null) {
            this.effectiveTargetIORIterator = listOfContactInfos.iterator();
        }
        this.listOfContactInfos = listOfContactInfos;
        this.previousContactInfo = null;
        this.isAddrDispositionRetry = false;
        this.retryWithPreviousContactInfo = false;
        this.failureException = null;
        this.waiter = this.tcpTimeouts.waiter();
        this.failedEndpoints = new HashSet<ContactInfo>();
        this.usePRLB = usePerRequestLoadBalancing;
        this.primaryToContactInfo = usePerRequestLoadBalancing ? null : orb.getORBData().getIIOPPrimaryToContactInfo();
    }

    @InfoMethod
    private void display(String msg) {
    }

    @InfoMethod
    private void display(String msg, Object value) {
    }

    @InfoMethod
    private void display(String msg, long value) {
    }

    @Override
    @Transport
    public boolean hasNext() {
        boolean result = false;
        if (this.retryWithPreviousContactInfo) {
            this.display("backoff before retry previous");
            if (this.waiter.isExpired()) {
                this.display("time to wait for connection exceeded ", this.tcpTimeouts.get_max_time_to_wait());
                this.failureException = wrapper.communicationsRetryTimeout(this.failureException, this.tcpTimeouts.get_max_time_to_wait());
                return false;
            }
            this.waiter.sleepTime();
            this.waiter.advance();
            return true;
        }
        if (this.isAddrDispositionRetry) {
            return true;
        }
        result = this.primaryToContactInfo != null ? this.primaryToContactInfo.hasNext(this.primaryContactInfo, this.previousContactInfo, this.listOfContactInfos) : this.effectiveTargetIORIterator.hasNext();
        if (!result && !this.waiter.isExpired()) {
            this.display("Reached end of ContactInfoList list. Starting at beginning");
            this.previousContactInfo = null;
            if (this.primaryToContactInfo != null) {
                this.primaryToContactInfo.reset(this.primaryContactInfo);
            } else {
                this.effectiveTargetIORIterator = this.listOfContactInfos.iterator();
            }
            result = this.hasNext();
            return result;
        }
        return result;
    }

    @Override
    @Transport
    public ContactInfo next() {
        if (this.retryWithPreviousContactInfo) {
            this.retryWithPreviousContactInfo = false;
            return this.previousContactInfo;
        }
        if (this.isAddrDispositionRetry) {
            this.isAddrDispositionRetry = false;
            return this.previousContactInfo;
        }
        this.previousContactInfo = this.primaryToContactInfo != null ? this.primaryToContactInfo.next(this.primaryContactInfo, this.previousContactInfo, this.listOfContactInfos) : this.effectiveTargetIORIterator.next();
        if (this.failedEndpoints.contains(this.previousContactInfo)) {
            this.failedEndpoints.clear();
            this.waiter.sleepTime();
            this.waiter.advance();
        }
        return this.previousContactInfo;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ContactInfoList getContactInfoList() {
        return this.contactInfoList;
    }

    @Override
    @Transport
    public void reportSuccess(ContactInfo contactInfo) {
        this.display("contactInfo", contactInfo);
        this.failedEndpoints.clear();
        this.waiter.reset();
    }

    @Override
    @Transport
    public boolean reportException(ContactInfo contactInfo, RuntimeException ex) {
        boolean result = false;
        this.display("contactInfo", contactInfo);
        this.failedEndpoints.add(contactInfo);
        this.failureException = ex;
        if (ex instanceof COMM_FAILURE) {
            SystemException se = (SystemException)((Object)ex);
            if (se.minor == ORBUtilSystemException.CONNECTION_REBIND) {
                this.display("COMM_FAILURE(connection rebind): retry with previous contact info", ex);
                this.retryWithPreviousContactInfo = true;
                result = true;
                return result;
            }
            if (se.completed == CompletionStatus.COMPLETED_NO) {
                if (this.hasNext()) {
                    this.display("COMM_FAILURE(COMPLETED_NO, hasNext true): retry with next contact info", ex);
                    result = true;
                    return result;
                }
                if (this.contactInfoList.getEffectiveTargetIOR() != this.contactInfoList.getTargetIOR()) {
                    this.display("COMM_FAILURE(COMPLETED_NO, hasNext false, effective != target): retry with target", ex);
                    this.updateEffectiveTargetIOR(this.contactInfoList.getTargetIOR());
                    result = true;
                    return result;
                }
            }
        } else if (ex instanceof TRANSIENT) {
            this.display("TRANSIENT: retry with previous contact info", ex);
            this.retryWithPreviousContactInfo = true;
            result = true;
            return result;
        }
        result = false;
        this.waiter.reset();
        return result;
    }

    @Override
    public RuntimeException getFailureException() {
        if (this.failureException == null) {
            return wrapper.invalidContactInfoListIteratorFailureException();
        }
        return this.failureException;
    }

    @Override
    @Transport
    public void reportAddrDispositionRetry(ContactInfo contactInfo, short disposition) {
        this.previousContactInfo.setAddressingDisposition(disposition);
        this.isAddrDispositionRetry = true;
        this.waiter.reset();
    }

    @Override
    @Transport
    public void reportRedirect(ContactInfo contactInfo, IOR forwardedIOR) {
        this.updateEffectiveTargetIOR(forwardedIOR);
        this.waiter.reset();
    }

    public void updateEffectiveTargetIOR(IOR newIOR) {
        this.contactInfoList.setEffectiveTargetIOR(newIOR);
        ContactInfoListImpl.setSkipRotate();
        ((InvocationInfo)this.orb.getInvocationInfo()).setContactInfoListIterator(this.contactInfoList.iterator());
    }
}

