/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.ConversationScoped;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.context.SessionScoped;
import jakarta.enterprise.context.spi.Context;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanAttributes;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.weld.contexts.cache.RequestScopedCache;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.collections.ImmutableSet;
import org.jboss.weld.util.reflection.Reflections;

public abstract class ContextualInstanceStrategy<T> {
    public static <T> ContextualInstanceStrategy<T> defaultStrategy() {
        return DefaultContextualInstanceStrategy.INSTANCE;
    }

    public static <T> ContextualInstanceStrategy<T> create(BeanAttributes<T> bean, BeanManagerImpl manager) {
        if (ApplicationScoped.class == bean.getScope() || Singleton.class == bean.getScope()) {
            return new ApplicationScopedContextualInstanceStrategy();
        }
        if (CachingContextualInstanceStrategy.CACHEABLE_SCOPES.contains(bean.getScope())) {
            return new CachingContextualInstanceStrategy();
        }
        return ContextualInstanceStrategy.defaultStrategy();
    }

    ContextualInstanceStrategy() {
    }

    abstract T get(Bean<T> var1, BeanManagerImpl var2, CreationalContext<?> var3);

    abstract T getIfExists(Bean<T> var1, BeanManagerImpl var2);

    abstract void destroy(Bean<T> var1);

    private static class CachingContextualInstanceStrategy<T>
    extends DefaultContextualInstanceStrategy<T> {
        private static final Set<Class<? extends Annotation>> CACHEABLE_SCOPES = ImmutableSet.of(new Class[]{RequestScoped.class, ConversationScoped.class, SessionScoped.class});
        private final ThreadLocal<T> cache = new ThreadLocal();

        private CachingContextualInstanceStrategy() {
        }

        @Override
        T getIfExists(Bean<T> bean, BeanManagerImpl manager) {
            T cached = this.cache.get();
            if (cached != null) {
                return cached;
            }
            cached = super.getIfExists(bean, manager);
            if (cached != null && RequestScopedCache.addItemIfActive(this.cache)) {
                this.cache.set(cached);
            }
            return cached;
        }

        @Override
        T get(Bean<T> bean, BeanManagerImpl manager, CreationalContext<?> ctx) {
            T cached = this.cache.get();
            if (cached != null) {
                return cached;
            }
            cached = super.get(bean, manager, ctx);
            if (RequestScopedCache.addItemIfActive(this.cache)) {
                this.cache.set(cached);
            }
            return cached;
        }
    }

    private static class ApplicationScopedContextualInstanceStrategy<T>
    extends DefaultContextualInstanceStrategy<T> {
        private final Lock lock = new ReentrantLock();
        private volatile T value;

        private ApplicationScopedContextualInstanceStrategy() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        T getIfExists(Bean<T> bean, BeanManagerImpl manager) {
            T instance = this.value;
            if (instance != null) {
                return instance;
            }
            this.lock.lock();
            try {
                if (this.value == null && (instance = super.getIfExists(bean, manager)) != null) {
                    this.value = instance;
                }
                T t = instance;
                return t;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        T get(Bean<T> bean, BeanManagerImpl manager, CreationalContext<?> ctx) {
            T instance = this.value;
            if (instance != null) {
                return instance;
            }
            this.lock.lock();
            try {
                instance = this.value;
                if (instance == null) {
                    this.value = instance = super.get(bean, manager, ctx);
                }
                T t = instance;
                return t;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        void destroy(Bean<T> bean) {
            this.value = null;
        }
    }

    private static class DefaultContextualInstanceStrategy<T>
    extends ContextualInstanceStrategy<T> {
        static final ContextualInstanceStrategy<Object> INSTANCE = new DefaultContextualInstanceStrategy<Object>();

        private DefaultContextualInstanceStrategy() {
        }

        @Override
        T getIfExists(Bean<T> bean, BeanManagerImpl manager) {
            return (T)manager.getContext(bean.getScope()).get(bean);
        }

        @Override
        T get(Bean<T> bean, BeanManagerImpl manager, CreationalContext<?> ctx) {
            Context context = manager.getContext(bean.getScope());
            Object instance = context.get(bean);
            if (instance == null) {
                if (ctx == null) {
                    ctx = manager.createCreationalContext((Contextual)bean);
                }
                instance = context.get(bean, (CreationalContext)Reflections.cast(ctx));
            }
            return (T)instance;
        }

        @Override
        void destroy(Bean<T> bean) {
        }
    }
}

