/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.impl.store;

import java.util.Comparator;
import java.util.TreeSet;
import org.shoal.adapter.store.commands.AbstractSaveCommand;

public class DataStoreEntry<K, V> {
    public static final long MIN_VERSION = -8L;
    private K key;
    private V v;
    private String replicaInstanceName;
    private TreeSet<AbstractSaveCommand<K, V>> pendingUpdates;
    private boolean removed;
    private long lastAccessedAt;
    private long maxIdleTime;
    private long version = -8L;
    private byte[] rawV;
    private boolean isReplicaNode = true;

    public void setKey(K key) {
        this.key = key;
    }

    public K getKey() {
        return this.key;
    }

    V getV() {
        return this.v;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public void setV(V state) {
        this.v = state;
    }

    public byte[] getRawV() {
        return this.rawV;
    }

    public void setRawV(byte[] rawV) {
        this.rawV = rawV;
        this.v = null;
    }

    public String getReplicaInstanceName() {
        return this.replicaInstanceName;
    }

    public String setReplicaInstanceName(String replicaInstanceName) {
        String oldValue = this.replicaInstanceName;
        this.replicaInstanceName = replicaInstanceName;
        this.removed = false;
        return oldValue == null ? null : (oldValue.equals(replicaInstanceName) ? null : oldValue);
    }

    public TreeSet<AbstractSaveCommand<K, V>> getPendingUpdates() {
        return this.pendingUpdates;
    }

    public void clearPendingUpdates() {
        if (this.pendingUpdates != null) {
            this.pendingUpdates.clear();
        }
    }

    public void addPendingUpdate(AbstractSaveCommand<K, V> cmd) {
        if (this.pendingUpdates == null) {
            this.pendingUpdates = new TreeSet(new Comparator<AbstractSaveCommand<K, V>>(){

                @Override
                public int compare(AbstractSaveCommand<K, V> cmd1, AbstractSaveCommand<K, V> cmd2) {
                    return (int)(cmd1.getVersion() - cmd2.getVersion());
                }
            });
        }
        this.pendingUpdates.add(cmd);
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public void markAsRemoved(String reason) {
        this.removed = true;
        this.v = null;
        this.pendingUpdates = null;
    }

    public long getLastAccessedAt() {
        return this.lastAccessedAt;
    }

    public void setLastAccessedAt(long lastAccessedAt) {
        this.lastAccessedAt = lastAccessedAt;
    }

    public long getVersion() {
        return this.version;
    }

    public long incrementAndGetVersion() {
        return ++this.version;
    }

    public long getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public void setMaxIdleTime(long maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    public boolean isReplicaNode() {
        return this.isReplicaNode;
    }

    public void setIsReplicaNode(boolean replicaNode) {
        this.isReplicaNode = replicaNode;
    }
}

