/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.impl.command;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.ha.store.util.KeyTransformer;
import org.shoal.ha.cache.api.DataStoreContext;
import org.shoal.ha.cache.api.DataStoreException;
import org.shoal.ha.cache.impl.command.CommandManager;

public abstract class Command<K, V>
implements Serializable {
    private static final long serialVersionUID = 6608726132108978791L;
    private static final transient Logger _logger = Logger.getLogger("org.shoal.ha.cache.command.save");
    private byte opcode;
    private byte[] rawKey;
    private transient K key;
    protected transient DataStoreContext<K, V> dsc;
    private transient CommandManager<K, V> cm;
    private transient String commandName;
    protected transient String targetInstanceName;

    protected Command(byte opcode) {
        this.opcode = opcode;
    }

    public final void initialize(DataStoreContext<K, V> rs) {
        this.dsc = rs;
        this.cm = rs.getCommandManager();
        this.commandName = this.getClass().getName();
        int index = this.commandName.lastIndexOf(46);
        this.commandName = this.commandName.substring(index + 1);
    }

    protected final void setKey(K k) {
        this.key = k;
    }

    public final K getKey() {
        KeyTransformer kt;
        if (this.key == null && this.rawKey != null && (kt = this.dsc.getKeyTransformer()) != null) {
            this.key = kt.byteArrayToKey(this.rawKey, 0, this.rawKey.length);
        }
        return this.key;
    }

    protected final DataStoreContext<K, V> getDataStoreContext() {
        return this.dsc;
    }

    protected final CommandManager<K, V> getCommandManager() {
        return this.cm;
    }

    public String getTargetName() {
        return this.targetInstanceName;
    }

    public final byte getOpcode() {
        return this.opcode;
    }

    protected void setTargetName(String val) {
        this.targetInstanceName = val;
    }

    public void prepareTransmit(DataStoreContext<K, V> ctx) throws IOException {
        if (!this.beforeTransmit()) {
            _logger.log(Level.FINE, "Aborting command transmission for " + this.getName() + " because beforeTransmit returned false");
        }
    }

    protected static byte[] captureState(Object obj) throws DataStoreException {
        byte[] result = null;
        ByteArrayOutputStream bos = null;
        ObjectOutputStream oos = null;
        try {
            bos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(bos);
            oos.writeObject(obj);
            oos.close();
            result = bos.toByteArray();
        }
        catch (Exception ex) {
            throw new DataStoreException("Error during prepareToTransmit()", ex);
        }
        finally {
            try {
                oos.close();
            }
            catch (Exception exception) {}
            try {
                bos.close();
            }
            catch (Exception exception) {}
        }
        return result;
    }

    public String getKeyMappingInfo() {
        return this.targetInstanceName == null ? "" : this.targetInstanceName;
    }

    public final String getName() {
        return this.commandName + ":" + this.opcode;
    }

    public abstract void execute(String var1) throws DataStoreException;

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeByte(this.opcode);
        this.writeKey(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.opcode = in.readByte();
        this.readKey(in);
    }

    public void onSuccess() {
    }

    public void onFailure() {
    }

    public String toString() {
        return this.getName() + "(" + this.getKey() + ")";
    }

    private void writeKey(ObjectOutputStream out) throws IOException {
        if (this.isArtificialKey()) {
            out.writeObject(this.key);
        } else {
            KeyTransformer kt = this.dsc.getKeyTransformer();
            out.writeBoolean(kt != null);
            if (kt != null) {
                out.writeObject(kt.keyToByteArray(this.key));
            } else {
                out.writeObject(this.key);
            }
        }
    }

    private void readKey(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (this.isArtificialKey()) {
            this.key = in.readObject();
        } else {
            boolean needToTransformKey = in.readBoolean();
            if (!needToTransformKey) {
                this.key = in.readObject();
            } else {
                this.rawKey = (byte[])in.readObject();
            }
        }
    }

    protected boolean isArtificialKey() {
        return false;
    }

    protected abstract boolean beforeTransmit() throws IOException;
}

