/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurrent.runtime;

import com.sun.enterprise.deployment.types.ConcurrencyContextType;
import com.sun.enterprise.deployment.types.CustomContextType;
import com.sun.enterprise.deployment.types.StandardContextType;
import jakarta.enterprise.concurrent.spi.ThreadContextProvider;
import jakarta.enterprise.concurrent.spi.ThreadContextSnapshot;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;

public class ContextSetup
implements Serializable {
    private static final long serialVersionUID = 7817957604183520917L;
    private static final System.Logger LOG = System.getLogger(ContextSetup.class.getName());
    private final Set<ConcurrencyContextType> contextPropagate;
    private final Set<ConcurrencyContextType> contextClear;
    private final Set<ConcurrencyContextType> contextUnchanged;
    private transient Map<CustomContextType, ThreadContextProvider> allThreadContextProviders;

    public ContextSetup(Set<ConcurrencyContextType> propagated, Set<ConcurrencyContextType> cleared, Set<ConcurrencyContextType> unchanged) {
        this.contextPropagate = new HashSet<ConcurrencyContextType>(propagated);
        this.contextClear = new HashSet<ConcurrencyContextType>(cleared);
        this.contextUnchanged = new HashSet<ConcurrencyContextType>(unchanged);
    }

    public void reloadProviders(ClassLoader loader) {
        this.allThreadContextProviders = ContextSetup.loadAllProviders(loader);
        ContextSetup.addRemaining(this.contextPropagate, this.contextClear, this.contextUnchanged, this.allThreadContextProviders);
        LOG.log(System.Logger.Level.DEBUG, "Available contexts: {0}", this);
    }

    public boolean isPropagated(StandardContextType contextType) {
        return this.contextPropagate.contains(contextType);
    }

    public boolean isClear(StandardContextType contextType) {
        return this.contextClear.contains(contextType);
    }

    public boolean isUnchanged(StandardContextType contextType) {
        return this.contextUnchanged.contains(contextType);
    }

    public List<ThreadContextSnapshot> getThreadContextSnapshots(Map<String, String> executionProperties) {
        LOG.log(System.Logger.Level.TRACE, "getThreadContextSnapshots(executionProperties={0})", executionProperties);
        ArrayList<ThreadContextSnapshot> snapshots = new ArrayList<ThreadContextSnapshot>();
        this.contextPropagate.stream().map(this.allThreadContextProviders::get).filter(Objects::nonNull).map(snapshot -> snapshot.currentContext(executionProperties)).forEach(snapshots::add);
        this.contextClear.stream().map(this.allThreadContextProviders::get).filter(Objects::nonNull).map(snapshot -> snapshot.clearedContext(executionProperties)).forEach(snapshots::add);
        return snapshots;
    }

    public String toString() {
        return super.toString() + "[propagated=" + String.valueOf(this.contextPropagate) + ", cleared=" + String.valueOf(this.contextClear) + ", unchanged=" + String.valueOf(this.contextUnchanged) + "]";
    }

    private static Map<CustomContextType, ThreadContextProvider> loadAllProviders(ClassLoader loader) {
        LOG.log(System.Logger.Level.TRACE, "Using classloader: {0}", loader);
        ServiceLoader<ThreadContextProvider> services = ServiceLoader.load(ThreadContextProvider.class, loader);
        HashMap<CustomContextType, ThreadContextProvider> providers = new HashMap<CustomContextType, ThreadContextProvider>();
        for (ThreadContextProvider service : services) {
            CustomContextType ctxType = new CustomContextType(service.getThreadContextType());
            providers.put(ctxType, service);
        }
        LOG.log(System.Logger.Level.DEBUG, "Detected ThreadContextProvider implementations: {0}", providers);
        return providers;
    }

    private static void addRemaining(Set<ConcurrencyContextType> propagated, Set<ConcurrencyContextType> clear, Set<ConcurrencyContextType> unchanged, Map<CustomContextType, ThreadContextProvider> allThreadContextProviders) {
        Set<ConcurrencyContextType> remaining = ContextSetup.chooseSet(propagated, clear, unchanged);
        for (StandardContextType contextType : StandardContextType.values()) {
            if (contextType == StandardContextType.Remaining) continue;
            ContextSetup.addIfNotInAnotherSet((ConcurrencyContextType)contextType, remaining, propagated, clear, unchanged);
        }
        for (CustomContextType ctxType : allThreadContextProviders.keySet()) {
            ContextSetup.addIfNotInAnotherSet((ConcurrencyContextType)ctxType, remaining, propagated, clear, unchanged);
        }
    }

    private static Set<ConcurrencyContextType> chooseSet(Set<ConcurrencyContextType> propagated, Set<ConcurrencyContextType> clear, Set<ConcurrencyContextType> unchanged) {
        if (clear.contains(StandardContextType.Remaining)) {
            return clear;
        }
        if (unchanged.contains(StandardContextType.Remaining)) {
            return unchanged;
        }
        return propagated;
    }

    private static void addIfNotInAnotherSet(ConcurrencyContextType ctxType, Set<ConcurrencyContextType> remaining, Set<ConcurrencyContextType> propagated, Set<ConcurrencyContextType> clear, Set<ConcurrencyContextType> unchanged) {
        if (propagated.contains(ctxType) || clear.contains(ctxType) || unchanged.contains(ctxType)) {
            return;
        }
        remaining.add(ctxType);
    }
}

