/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.util.jmx.stringifier;

import javax.management.MBeanInfo;
import org.glassfish.admin.amx.util.jmx.stringifier.MBeanAttributeInfoStringifier;
import org.glassfish.admin.amx.util.jmx.stringifier.MBeanConstructorInfoStringifier;
import org.glassfish.admin.amx.util.jmx.stringifier.MBeanFeatureInfoStringifier;
import org.glassfish.admin.amx.util.jmx.stringifier.MBeanFeatureInfoStringifierOptions;
import org.glassfish.admin.amx.util.jmx.stringifier.MBeanNotificationInfoStringifier;
import org.glassfish.admin.amx.util.jmx.stringifier.MBeanOperationInfoStringifier;
import org.glassfish.admin.amx.util.stringifier.ArrayStringifier;
import org.glassfish.admin.amx.util.stringifier.Stringifier;

public class MBeanInfoStringifier
extends MBeanFeatureInfoStringifier
implements Stringifier {
    public static final MBeanInfoStringifier DEFAULT = new MBeanInfoStringifier();

    public MBeanInfoStringifier() {
    }

    public MBeanInfoStringifier(MBeanFeatureInfoStringifierOptions options) {
        super(options);
    }

    private String stringifyArray(Object[] a, Stringifier stringifier) {
        Object temp = "";
        if (a.length != 0) {
            temp = "\n" + ArrayStringifier.stringify(a, "\n", stringifier);
        }
        return temp;
    }

    MBeanAttributeInfoStringifier getMBeanAttributeInfoStringifier(MBeanFeatureInfoStringifierOptions options) {
        return new MBeanAttributeInfoStringifier(options);
    }

    MBeanOperationInfoStringifier getMBeanOperationInfoStringifier(MBeanFeatureInfoStringifierOptions options) {
        return new MBeanOperationInfoStringifier(options);
    }

    MBeanConstructorInfoStringifier getMBeanConstructorInfoStringifier(MBeanFeatureInfoStringifierOptions options) {
        return new MBeanConstructorInfoStringifier(options);
    }

    MBeanNotificationInfoStringifier getMBeanNotificationInfoStringifier(MBeanFeatureInfoStringifierOptions options) {
        return new MBeanNotificationInfoStringifier(options);
    }

    @Override
    public String stringify(Object o) {
        Object result = "";
        MBeanInfo info = (MBeanInfo)o;
        Object[] operations = info.getOperations();
        Object[] attributes = info.getAttributes();
        Object[] constructors = info.getConstructors();
        Object[] notifications = info.getNotifications();
        String description = info.getDescription();
        result = "Summary: " + operations.length + " operations, " + attributes.length + " attributes, " + constructors.length + " constructors, " + notifications.length + " notifications" + (String)(description == null ? "" : ", \"" + description + "\"");
        MBeanFeatureInfoStringifierOptions options = new MBeanFeatureInfoStringifierOptions(true, ",");
        result = (String)result + "\n\n- Attributes -" + this.stringifyArray(attributes, this.getMBeanAttributeInfoStringifier(options));
        result = (String)result + "\n\n- Operations -" + this.stringifyArray(operations, this.getMBeanOperationInfoStringifier(options));
        result = (String)result + "\n\n- Constructors -" + this.stringifyArray(constructors, this.getMBeanConstructorInfoStringifier(options));
        result = (String)result + "\n\n- Notifications -" + this.stringifyArray(notifications, this.getMBeanNotificationInfoStringifier(options));
        return result;
    }
}

