/*
 * Decompiled with CFR 0.152.
 */
package com.sun.data.provider.impl;

import com.sun.data.provider.DataProvider;
import com.sun.data.provider.DataProviderException;
import com.sun.data.provider.FieldKey;
import com.sun.data.provider.RowKey;
import com.sun.data.provider.TableDataListener;
import com.sun.data.provider.TableDataProvider;
import com.sun.data.provider.impl.AbstractDataProvider;
import java.io.Serializable;

public class TableRowDataProvider
extends AbstractDataProvider {
    private DataEars dataEars = new DataEars();
    private TableDataProvider provider;
    private RowKey tableRow;

    public TableRowDataProvider() {
    }

    public TableRowDataProvider(TableDataProvider provider) {
        this.setTableDataProvider(provider);
    }

    public TableRowDataProvider(TableDataProvider provider, RowKey tableRow) {
        this.setTableDataProvider(provider);
        this.setTableRow(tableRow);
    }

    public void setTableDataProvider(TableDataProvider provider) {
        if (this.provider != null) {
            this.provider.removeTableDataListener(this.dataEars);
        }
        this.provider = provider;
        if (this.provider != null) {
            this.provider.addTableDataListener(this.dataEars);
        }
        this.fireProviderChanged();
    }

    public TableDataProvider getTableDataProvider() {
        return this.provider;
    }

    public void setTableRow(RowKey tableRow) {
        this.tableRow = tableRow;
        if (this.provider != null) {
            this.fireProviderChanged();
        }
    }

    public RowKey getTableRow() {
        return this.tableRow;
    }

    public FieldKey[] getFieldKeys() throws DataProviderException {
        if (this.provider != null) {
            return this.provider.getFieldKeys();
        }
        return FieldKey.EMPTY_ARRAY;
    }

    public FieldKey getFieldKey(String fieldId) throws DataProviderException {
        if (this.provider != null) {
            return this.provider.getFieldKey(fieldId);
        }
        return null;
    }

    public Class getType(FieldKey fieldKey) throws DataProviderException {
        if (this.provider != null) {
            return this.provider.getType(fieldKey);
        }
        return null;
    }

    public boolean isReadOnly(FieldKey fieldKey) throws DataProviderException {
        if (this.provider != null) {
            return this.provider.isReadOnly(fieldKey);
        }
        return true;
    }

    public Object getValue(FieldKey fieldKey) throws DataProviderException {
        if (this.provider != null) {
            return this.provider.getValue(fieldKey, this.tableRow);
        }
        return null;
    }

    public void setValue(FieldKey fieldKey, Object value) throws DataProviderException {
        this.provider.setValue(fieldKey, this.tableRow, value);
    }

    private class DataEars
    implements TableDataListener,
    Serializable {
        private DataEars() {
        }

        public void valueChanged(TableDataProvider provider, FieldKey fieldKey, RowKey row, Object oldValue, Object newValue) {
            if (row == TableRowDataProvider.this.tableRow || row != null && row.equals(TableRowDataProvider.this.tableRow)) {
                TableRowDataProvider.this.fireValueChanged(fieldKey, oldValue, newValue);
            }
        }

        public void rowAdded(TableDataProvider provider, RowKey row) {
            if (row == TableRowDataProvider.this.tableRow || row != null && row.equals(TableRowDataProvider.this.tableRow)) {
                TableRowDataProvider.this.fireProviderChanged();
            }
        }

        public void rowRemoved(TableDataProvider provider, RowKey row) {
            if (row == TableRowDataProvider.this.tableRow || row != null && row.equals(TableRowDataProvider.this.tableRow)) {
                TableRowDataProvider.this.fireProviderChanged();
            }
        }

        public void valueChanged(DataProvider provider, FieldKey fieldKey, Object oldValue, Object newValue) {
            RowKey row = TableRowDataProvider.this.provider.getCursorRow();
            if (row == TableRowDataProvider.this.tableRow || row != null && row.equals(TableRowDataProvider.this.tableRow)) {
                TableRowDataProvider.this.fireValueChanged(fieldKey, oldValue, newValue);
            }
        }

        public void providerChanged(DataProvider provider) {
            TableRowDataProvider.this.fireProviderChanged();
        }
    }
}

