/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.methodvalidation;

import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import jakarta.validation.groups.Default;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.ValidateConstructorParametersTest;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.constraint.MyCrossParameterConstraint;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.constraint.ValidOrder;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.constraint.ValidOrderService;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.constraint.ValidRetailOrder;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.constraint.ValidRetailOrderService;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.model.Item;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.model.Order;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.service.ExtendedOrderService;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.service.OrderService;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.service.OrderServiceImpl;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.service.OrderServiceWithRedefinedDefaultGroupSequence;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="3.0.0")
public class MethodValidationTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)MethodValidationTest.webArchiveBuilder().withTestClass(ValidateConstructorParametersTest.class)).withPackage(MyCrossParameterConstraint.class.getPackage())).withPackage(ExtendedOrderService.class.getPackage())).withClass(Item.class)).withClass(Order.class)).build();
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-methodconstructorvalidation", id="a")
    public void methodParameterValidationTargetsParameterCrossParameterAndCascadedConstraints() throws Exception {
        String methodName = "placeOrder";
        OrderService object = new OrderService();
        Method method = OrderService.class.getMethod(methodName, String.class, Item.class, Integer.TYPE);
        Object[] parameterValues = new Object[]{null, new Item(""), 0};
        Set violations = this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).parameter("customer", 0)), ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).parameter("item", 1).property("name")), ConstraintViolationAssert.violationOf(Min.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).parameter("quantity", 2)), ConstraintViolationAssert.violationOf(MyCrossParameterConstraint.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).crossParameter()));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-methodconstructorvalidation", id="a")
    public void methodParameterValidationIncludesConstraintsFromSuperClass() throws Exception {
        String methodName = "placeOrder";
        ExtendedOrderService object = new ExtendedOrderService();
        Method method = ExtendedOrderService.class.getMethod(methodName, String.class, Item.class, Integer.TYPE);
        Object[] parameterValues = new Object[]{null, new Item(""), 0};
        Set violations = this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).parameter("customer", 0)), ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).parameter("item", 1).property("name")), ConstraintViolationAssert.violationOf(Min.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).parameter("quantity", 2)), ConstraintViolationAssert.violationOf(MyCrossParameterConstraint.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).crossParameter()));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-methodconstructorvalidation", id="a")
    public void methodParameterValidationIncludesConstraintsFromImplementedInterface() throws Exception {
        String methodName = "placeOrder";
        OrderServiceImpl object = new OrderServiceImpl();
        Method method = OrderServiceImpl.class.getMethod(methodName, String.class, Item.class, Integer.TYPE);
        Object[] parameterValues = new Object[]{null, new Item(""), 0};
        Set violations = this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).parameter("customer", 0)), ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).parameter("item", 1).property("name")), ConstraintViolationAssert.violationOf(Min.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).parameter("quantity", 2)), ConstraintViolationAssert.violationOf(MyCrossParameterConstraint.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).crossParameter()));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-methodconstructorvalidation", id="a")
    public void methodParameterValidationIsAppliedGroupWise() throws Exception {
        String methodName = "placeOrder";
        OrderService object = new OrderService();
        Method method = OrderService.class.getMethod(methodName, String.class, Item.class, Integer.class);
        Object[] parameterValues = new Object[]{null, new Item(""), 0};
        Set violations = this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[]{OrderService.Basic.class});
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).parameter("customer", 0)), ConstraintViolationAssert.violationOf(MyCrossParameterConstraint.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).crossParameter()));
        violations = this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).parameter("item", 1).property("name")), ConstraintViolationAssert.violationOf(Min.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).parameter("quantity", 2)));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-methodconstructorvalidation", id="a")
    public void methodParameterValidationPerformsGroupConversion() throws Exception {
        String methodName = "placeOrder";
        OrderService object = new OrderService();
        Method method = OrderService.class.getMethod(methodName, String.class, Item.class, Long.TYPE);
        Object[] parameterValues = new Object[]{null, new Item(""), 0};
        Set violations = this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[]{OrderService.Basic.class});
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).parameter("item", 1).property("name")));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-methodconstructorvalidation", id="a")
    public void methodParameterValidationValidatesEachConstraintOnlyOnce() throws Exception {
        String methodName = "placeOrder";
        OrderService object = new OrderService();
        Method method = OrderService.class.getMethod(methodName, String.class, Item.class, Short.TYPE);
        Object[] parameterValues = new Object[]{null, new Item(""), (short)0};
        Set violations = this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[]{OrderService.Basic.class, Default.class});
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).parameter("customer", 0)), ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).parameter("item", 1).property("name")), ConstraintViolationAssert.violationOf(Min.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).parameter("quantity", 2)), ConstraintViolationAssert.violationOf(MyCrossParameterConstraint.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).crossParameter()));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-methodconstructorvalidation", id="a")
    public void methodParameterValidationUsingSequence() throws Exception {
        String methodName = "placeOrder";
        OrderService object = new OrderService();
        Method method = OrderService.class.getMethod(methodName, String.class, Item.class, Byte.TYPE);
        Object[] parameterValues = new Object[]{null, new Item(""), (byte)0};
        Set violations = this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[]{OrderService.OrderServiceSequence.class});
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).parameter("customer", 0)), ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).parameter("item", 1).property("name")));
        parameterValues = new Object[]{"Bob", new Item("BV Specification"), (byte)0};
        violations = this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[]{OrderService.OrderServiceSequence.class});
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Min.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).parameter("quantity", 2)), ConstraintViolationAssert.violationOf(MyCrossParameterConstraint.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).crossParameter()));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-methodconstructorvalidation", id="a")
    public void methodParameterValidationWithRedefinedDefaultGroupSequence() throws Exception {
        String methodName = "placeOrder";
        OrderServiceWithRedefinedDefaultGroupSequence object = new OrderServiceWithRedefinedDefaultGroupSequence();
        Method method = OrderServiceWithRedefinedDefaultGroupSequence.class.getMethod(methodName, String.class, Item.class, Byte.TYPE);
        Object[] parameterValues = new Object[]{null, new Item(""), (byte)0};
        Set violations = this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).parameter("customer", 0)), ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).parameter("item", 1).property("name")));
        parameterValues = new Object[]{"Bob", new Item(""), (byte)0};
        violations = this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).parameter("item", 1).property("name")), ConstraintViolationAssert.violationOf(Min.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).parameter("quantity", 2)), ConstraintViolationAssert.violationOf(MyCrossParameterConstraint.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).crossParameter()));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-methodconstructorvalidation", id="a")
    public void constructorParameterValidationTargetsParameterCrossParameterAndCascadedConstraints() throws Exception {
        Constructor constructor = OrderService.class.getConstructor(String.class, Item.class, Integer.TYPE);
        Object[] parameterValues = new Object[]{null, new Item(""), 0};
        Set violations = this.getExecutableValidator().validateConstructorParameters(constructor, parameterValues, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(OrderService.class).parameter("customer", 0)), ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(OrderService.class).parameter("item", 1).property("name")), ConstraintViolationAssert.violationOf(Min.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(OrderService.class).parameter("quantity", 2)), ConstraintViolationAssert.violationOf(MyCrossParameterConstraint.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(OrderService.class).crossParameter()));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-methodconstructorvalidation", id="a")
    public void constructorParameterValidationDoesNotIncludeConstraintsFromSuperClass() throws Exception {
        Constructor constructor = ExtendedOrderService.class.getConstructor(String.class, Item.class, Integer.TYPE);
        Object[] parameterValues = new Object[]{null, new Item(""), 0};
        Set violations = this.getExecutableValidator().validateConstructorParameters(constructor, parameterValues, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(violations);
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-methodconstructorvalidation", id="a")
    public void constructorParameterValidationIsAppliedGroupWise() throws Exception {
        Constructor constructor = OrderService.class.getConstructor(String.class, Item.class, Integer.class);
        Object[] parameterValues = new Object[]{null, new Item(""), 0};
        Set violations = this.getExecutableValidator().validateConstructorParameters(constructor, parameterValues, new Class[]{OrderService.Basic.class});
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(OrderService.class).parameter("customer", 0)), ConstraintViolationAssert.violationOf(MyCrossParameterConstraint.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(OrderService.class).crossParameter()));
        violations = this.getExecutableValidator().validateConstructorParameters(constructor, parameterValues, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(OrderService.class).parameter("item", 1).property("name")), ConstraintViolationAssert.violationOf(Min.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(OrderService.class).parameter("quantity", 2)));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-methodconstructorvalidation", id="a")
    public void constructorParameterValidationPerformsGroupConversion() throws Exception {
        Constructor constructor = OrderService.class.getConstructor(String.class, Item.class, Long.TYPE);
        Object[] parameterValues = new Object[]{null, new Item(""), 0};
        Set violations = this.getExecutableValidator().validateConstructorParameters(constructor, parameterValues, new Class[]{OrderService.Basic.class});
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(OrderService.class).parameter("item", 1).property("name")));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-methodconstructorvalidation", id="a")
    public void constructorParameterValidationValidatesEachConstraintOnlyOnce() throws Exception {
        Constructor constructor = OrderService.class.getConstructor(String.class, Item.class, Short.TYPE);
        Object[] parameterValues = new Object[]{null, new Item(""), (short)0};
        Set violations = this.getExecutableValidator().validateConstructorParameters(constructor, parameterValues, new Class[]{OrderService.Basic.class, Default.class});
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(OrderService.class).parameter("customer", 0)), ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(OrderService.class).parameter("item", 1).property("name")), ConstraintViolationAssert.violationOf(Min.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(OrderService.class).parameter("quantity", 2)), ConstraintViolationAssert.violationOf(MyCrossParameterConstraint.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(OrderService.class).crossParameter()));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-methodconstructorvalidation", id="a")
    public void constructorParameterValidationUsingSequence() throws Exception {
        Constructor constructor = OrderService.class.getConstructor(String.class, Item.class, Byte.TYPE);
        Object[] parameterValues = new Object[]{null, new Item(""), (byte)0};
        Set violations = this.getExecutableValidator().validateConstructorParameters(constructor, parameterValues, new Class[]{OrderService.OrderServiceSequence.class});
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(OrderService.class).parameter("customer", 0)), ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(OrderService.class).parameter("item", 1).property("name")));
        parameterValues = new Object[]{"Bob", new Item("BV Specification"), (byte)0};
        violations = this.getExecutableValidator().validateConstructorParameters(constructor, parameterValues, new Class[]{OrderService.OrderServiceSequence.class});
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Min.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(OrderService.class).parameter("quantity", 2)), ConstraintViolationAssert.violationOf(MyCrossParameterConstraint.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(OrderService.class).crossParameter()));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-methodconstructorvalidation", id="a")
    public void constructorParameterValidationWithRedefinedDefaultGroupSequence() throws Exception {
        Constructor constructor = OrderServiceWithRedefinedDefaultGroupSequence.class.getConstructor(String.class, Item.class, Byte.TYPE);
        Object[] parameterValues = new Object[]{null, new Item(""), (byte)0};
        Set violations = this.getExecutableValidator().validateConstructorParameters(constructor, parameterValues, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(OrderServiceWithRedefinedDefaultGroupSequence.class).parameter("customer", 0)), ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(OrderServiceWithRedefinedDefaultGroupSequence.class).parameter("item", 1).property("name")));
        parameterValues = new Object[]{"Bob", new Item(""), (byte)0};
        violations = this.getExecutableValidator().validateConstructorParameters(constructor, parameterValues, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(OrderServiceWithRedefinedDefaultGroupSequence.class).parameter("item", 1).property("name")), ConstraintViolationAssert.violationOf(Min.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(OrderServiceWithRedefinedDefaultGroupSequence.class).parameter("quantity", 2)), ConstraintViolationAssert.violationOf(MyCrossParameterConstraint.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(OrderServiceWithRedefinedDefaultGroupSequence.class).crossParameter()));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-methodconstructorvalidation", id="b")
    public void methodReturnValueValidationTargetsReturnValueAndCascadedConstraints() throws Exception {
        String methodName = "placeOrder";
        OrderService object = new OrderService();
        Method method = OrderService.class.getMethod(methodName, String.class, Item.class, Integer.TYPE);
        Order returnValue = new Order("");
        Set violations = this.getExecutableValidator().validateReturnValue((Object)object, method, (Object)returnValue, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).returnValue().property("name")), ConstraintViolationAssert.violationOf(ValidOrder.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).returnValue()));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-methodconstructorvalidation", id="b")
    public void methodReturnValueValidationIncludesConstraintsFromSuperClass() throws Exception {
        String methodName = "placeOrder";
        ExtendedOrderService object = new ExtendedOrderService();
        Method method = ExtendedOrderService.class.getMethod(methodName, String.class, Item.class, Integer.TYPE);
        Order returnValue = new Order("");
        Set violations = this.getExecutableValidator().validateReturnValue((Object)object, method, (Object)returnValue, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).returnValue().property("name")), ConstraintViolationAssert.violationOf(ValidOrder.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).returnValue()), ConstraintViolationAssert.violationOf(ValidRetailOrder.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).returnValue()));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-methodconstructorvalidation", id="b")
    public void methodReturnValueValidationIncludesConstraintsFromImplementedInterface() throws Exception {
        String methodName = "placeOrder";
        OrderServiceImpl object = new OrderServiceImpl();
        Method method = OrderServiceImpl.class.getMethod(methodName, String.class, Item.class, Integer.TYPE);
        Order returnValue = new Order("");
        Set violations = this.getExecutableValidator().validateReturnValue((Object)object, method, (Object)returnValue, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).returnValue().property("name")), ConstraintViolationAssert.violationOf(ValidOrder.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).returnValue()), ConstraintViolationAssert.violationOf(ValidRetailOrder.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).returnValue()));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-methodconstructorvalidation", id="b")
    public void methodReturnValueValidationIsAppliedGroupWise() throws Exception {
        String methodName = "placeOrder";
        OrderService object = new OrderService();
        Method method = OrderService.class.getMethod(methodName, String.class, Item.class, Integer.class);
        Order returnValue = new Order("");
        Set violations = this.getExecutableValidator().validateReturnValue((Object)object, method, (Object)returnValue, new Class[]{OrderService.Basic.class});
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(ValidRetailOrder.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).returnValue()));
        violations = this.getExecutableValidator().validateReturnValue((Object)object, method, (Object)returnValue, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).returnValue().property("name")), ConstraintViolationAssert.violationOf(ValidOrder.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).returnValue()));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-methodconstructorvalidation", id="b")
    public void methodReturnValueValidationPerformsGroupConversion() throws Exception {
        String methodName = "placeOrder";
        OrderService object = new OrderService();
        Method method = OrderService.class.getMethod(methodName, String.class, Item.class, Long.TYPE);
        Order returnValue = new Order("");
        Set violations = this.getExecutableValidator().validateReturnValue((Object)object, method, (Object)returnValue, new Class[]{OrderService.Basic.class});
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).returnValue().property("name")));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-methodconstructorvalidation", id="b")
    public void methodReturnValueValidationValidatesEachConstraintOnlyOnce() throws Exception {
        String methodName = "placeOrder";
        OrderService object = new OrderService();
        Method method = OrderService.class.getMethod(methodName, String.class, Item.class, Short.TYPE);
        Order returnValue = new Order("");
        Set violations = this.getExecutableValidator().validateReturnValue((Object)object, method, (Object)returnValue, new Class[]{OrderService.Basic.class, Default.class});
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(ValidOrder.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).returnValue()));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-methodconstructorvalidation", id="b")
    public void methodReturnValueValidationUsingSequence() throws Exception {
        String methodName = "placeOrder";
        OrderService object = new OrderService();
        Method method = OrderService.class.getMethod(methodName, String.class, Item.class, Byte.TYPE);
        Order returnValue = new Order("");
        Set violations = this.getExecutableValidator().validateReturnValue((Object)object, method, (Object)returnValue, new Class[]{OrderService.OrderServiceSequence.class});
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).returnValue().property("name")), ConstraintViolationAssert.violationOf(ValidOrder.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).returnValue()));
        returnValue = new Order("BV Specification");
        violations = this.getExecutableValidator().validateReturnValue((Object)object, method, (Object)returnValue, new Class[]{OrderService.OrderServiceSequence.class});
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(ValidRetailOrder.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).returnValue()));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-methodconstructorvalidation", id="b")
    public void methodReturnValueValidationWithRedefinedDefaultGroupSequence() throws Exception {
        String methodName = "placeOrder";
        OrderServiceWithRedefinedDefaultGroupSequence object = new OrderServiceWithRedefinedDefaultGroupSequence();
        Method method = OrderServiceWithRedefinedDefaultGroupSequence.class.getMethod(methodName, String.class, Item.class, Byte.TYPE);
        Order returnValue = new Order("");
        Set violations = this.getExecutableValidator().validateReturnValue((Object)object, method, (Object)returnValue, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).returnValue().property("name")), ConstraintViolationAssert.violationOf(ValidOrder.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).returnValue()));
        returnValue = new Order("valid");
        violations = this.getExecutableValidator().validateReturnValue((Object)object, method, (Object)returnValue, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).returnValue().property("name")), ConstraintViolationAssert.violationOf(ValidRetailOrder.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).returnValue()));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-methodconstructorvalidation", id="b")
    public void constructorReturnValueValidationTargetsReturnValueAndCascadedConstraints() throws Exception {
        Constructor constructor = OrderService.class.getConstructor(String.class, Item.class, Integer.TYPE);
        OrderService returnValue = new OrderService("");
        Set violations = this.getExecutableValidator().validateConstructorReturnValue(constructor, (Object)returnValue, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(OrderService.class).returnValue().property("name")), ConstraintViolationAssert.violationOf(ValidOrderService.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(OrderService.class).returnValue()));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-methodconstructorvalidation", id="b")
    public void constructorReturnValueValidationDoesNotIncludeConstraintsFromSuperClass() throws Exception {
        Constructor constructor = ExtendedOrderService.class.getConstructor(String.class, Item.class, Integer.TYPE);
        ExtendedOrderService returnValue = new ExtendedOrderService();
        Set violations = this.getExecutableValidator().validateConstructorReturnValue(constructor, (Object)returnValue, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(ValidRetailOrderService.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(ExtendedOrderService.class).returnValue()));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-methodconstructorvalidation", id="b")
    public void constructorReturnValueValidationIsAppliedGroupWise() throws Exception {
        Constructor constructor = OrderService.class.getConstructor(String.class, Item.class, Integer.class);
        OrderService returnValue = new OrderService("");
        Set violations = this.getExecutableValidator().validateConstructorReturnValue(constructor, (Object)returnValue, new Class[]{OrderService.Basic.class});
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(ValidRetailOrderService.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(OrderService.class).returnValue()));
        violations = this.getExecutableValidator().validateConstructorReturnValue(constructor, (Object)returnValue, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(ValidOrderService.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(OrderService.class).returnValue()), ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(OrderService.class).returnValue().property("name")));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-methodconstructorvalidation", id="b")
    public void constructorReturnValueValidationPerformsGroupConversion() throws Exception {
        Constructor constructor = OrderService.class.getConstructor(String.class, Item.class, Long.TYPE);
        OrderService returnValue = new OrderService("");
        Set violations = this.getExecutableValidator().validateConstructorReturnValue(constructor, (Object)returnValue, new Class[]{OrderService.Basic.class});
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(OrderService.class).returnValue().property("name")));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-methodconstructorvalidation", id="b")
    public void constructorReturnValueValidationValidatesEachConstraintOnlyOnce() throws Exception {
        Constructor constructor = OrderService.class.getConstructor(String.class, Item.class, Short.TYPE);
        OrderService returnValue = new OrderService("");
        Set violations = this.getExecutableValidator().validateConstructorReturnValue(constructor, (Object)returnValue, new Class[]{OrderService.Basic.class, Default.class});
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(ValidOrderService.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(OrderService.class).returnValue()));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-methodconstructorvalidation", id="b")
    public void constructorReturnValueValidationUsingSequence() throws Exception {
        Constructor constructor = OrderService.class.getConstructor(String.class, Item.class, Byte.TYPE);
        OrderService returnValue = new OrderService("");
        Set violations = this.getExecutableValidator().validateConstructorReturnValue(constructor, (Object)returnValue, new Class[]{OrderService.OrderServiceSequence.class});
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(ValidOrderService.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(OrderService.class).returnValue()), ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(OrderService.class).returnValue().property("name")));
        returnValue = new OrderService("valid order service");
        violations = this.getExecutableValidator().validateConstructorReturnValue(constructor, (Object)returnValue, new Class[]{OrderService.OrderServiceSequence.class});
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(ValidRetailOrderService.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(OrderService.class).returnValue()));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-methodconstructorvalidation", id="b")
    public void constructorReturnValueValidationWithRedefinedDefaultGroupSequence() throws Exception {
        Constructor constructor = OrderServiceWithRedefinedDefaultGroupSequence.class.getConstructor(String.class, Item.class, Byte.TYPE);
        OrderServiceWithRedefinedDefaultGroupSequence returnValue = new OrderServiceWithRedefinedDefaultGroupSequence("");
        Set violations = this.getExecutableValidator().validateConstructorReturnValue(constructor, (Object)returnValue, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(ValidOrderService.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(OrderServiceWithRedefinedDefaultGroupSequence.class).returnValue()), ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(OrderServiceWithRedefinedDefaultGroupSequence.class).returnValue().property("name")));
        returnValue = new OrderServiceWithRedefinedDefaultGroupSequence("valid");
        violations = this.getExecutableValidator().validateConstructorReturnValue(constructor, (Object)returnValue, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(ValidRetailOrderService.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(OrderServiceWithRedefinedDefaultGroupSequence.class).returnValue()), ConstraintViolationAssert.violationOf(Pattern.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(OrderServiceWithRedefinedDefaultGroupSequence.class).returnValue().property("name")));
    }
}

