/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import java.util.Map;
import java.util.function.Consumer;
import org.assertj.core.api.AbstractMapSizeAssert;
import org.assertj.core.api.AbstractObjectArrayAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.Condition;
import org.assertj.core.api.EnumerableAssert;
import org.assertj.core.api.MapSizeAssert;
import org.assertj.core.data.MapEntry;
import org.assertj.core.description.Description;
import org.assertj.core.internal.Maps;
import org.assertj.core.util.Arrays;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractMapAssert<SELF extends AbstractMapAssert<SELF, ACTUAL, K, V>, ACTUAL extends Map<K, V>, K, V>
extends AbstractObjectAssert<SELF, ACTUAL>
implements EnumerableAssert<SELF, Map.Entry<? extends K, ? extends V>> {
    @VisibleForTesting
    Maps maps = Maps.instance();

    public AbstractMapAssert(ACTUAL actual, Class<?> selfType) {
        super(actual, selfType);
    }

    @Override
    public void isNullOrEmpty() {
        this.maps.assertNullOrEmpty(this.info, (Map)this.actual);
    }

    @Override
    public void isEmpty() {
        this.maps.assertEmpty(this.info, (Map)this.actual);
    }

    @Override
    public SELF isNotEmpty() {
        this.maps.assertNotEmpty(this.info, (Map)this.actual);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    @Override
    public SELF hasSize(int expected) {
        this.maps.assertHasSize(this.info, (Map)this.actual, expected);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    @Override
    public SELF hasSameSizeAs(Object other) {
        this.maps.assertHasSameSizeAs((AssertionInfo)this.info, (Map)this.actual, other);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    @Override
    public SELF hasSameSizeAs(Iterable<?> other) {
        this.maps.assertHasSameSizeAs((AssertionInfo)this.info, (Map)this.actual, other);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF hasSameSizeAs(Map<?, ?> other) {
        this.maps.assertHasSameSizeAs((AssertionInfo)this.info, (Map)this.actual, other);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF contains(Map.Entry<? extends K, ? extends V> ... entries) {
        this.maps.assertContains(this.info, (Map)this.actual, entries);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF containsAnyOf(Map.Entry<? extends K, ? extends V> ... entries) {
        this.maps.assertContainsAnyOf(this.info, (Map)this.actual, entries);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF containsAllEntriesOf(Map<? extends K, ? extends V> other) {
        Map.Entry[] entries = other.entrySet().toArray(new Map.Entry[other.size()]);
        this.maps.assertContains(this.info, (Map)this.actual, entries);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF containsEntry(K key, V value) {
        this.maps.assertContains(this.info, (Map)this.actual, Arrays.array(MapEntry.entry(key, value)));
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF hasEntrySatisfying(K key, Condition<? super V> valueCondition) {
        this.maps.assertHasEntrySatisfying((AssertionInfo)this.info, (Map)this.actual, key, valueCondition);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF hasEntrySatisfying(K key, Consumer<? super V> valueRequirements) {
        this.maps.assertHasEntrySatisfying((AssertionInfo)this.info, (Map)this.actual, key, valueRequirements);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF hasEntrySatisfying(Condition<? super Map.Entry<K, V>> entryCondition) {
        this.maps.assertHasEntrySatisfying(this.info, (Map)this.actual, entryCondition);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF hasEntrySatisfying(Condition<? super K> keyCondition, Condition<? super V> valueCondition) {
        this.maps.assertHasEntrySatisfyingConditions(this.info, (Map)this.actual, keyCondition, valueCondition);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF hasKeySatisfying(Condition<? super K> keyCondition) {
        this.maps.assertHasKeySatisfying(this.info, (Map)this.actual, keyCondition);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF hasValueSatisfying(Condition<? super V> valueCondition) {
        this.maps.assertHasValueSatisfying(this.info, (Map)this.actual, valueCondition);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF doesNotContain(Map.Entry<? extends K, ? extends V> ... entries) {
        this.maps.assertDoesNotContain(this.info, (Map)this.actual, entries);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF doesNotContainEntry(K key, V value) {
        this.maps.assertDoesNotContain(this.info, (Map)this.actual, Arrays.array(MapEntry.entry(key, value)));
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF containsKey(K key) {
        return this.containsKeys(key);
    }

    public SELF containsKeys(K ... keys) {
        this.maps.assertContainsKeys(this.info, (Map)this.actual, keys);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF doesNotContainKey(K key) {
        return this.doesNotContainKeys(key);
    }

    public SELF doesNotContainKeys(K ... keys) {
        this.maps.assertDoesNotContainKeys(this.info, (Map)this.actual, keys);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF containsOnlyKeys(K ... keys) {
        this.maps.assertContainsOnlyKeys(this.info, (Map)this.actual, keys);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF containsValue(V value) {
        this.maps.assertContainsValue(this.info, (Map)this.actual, value);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF containsValues(V ... values) {
        this.maps.assertContainsValues(this.info, (Map)this.actual, values);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF doesNotContainValue(V value) {
        this.maps.assertDoesNotContainValue(this.info, (Map)this.actual, value);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF containsOnly(Map.Entry<? extends K, ? extends V> ... entries) {
        this.maps.assertContainsOnly(this.info, (Map)this.actual, entries);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF containsExactly(Map.Entry<? extends K, ? extends V> ... entries) {
        this.maps.assertContainsExactly(this.info, (Map)this.actual, entries);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    @Override
    @Deprecated
    public SELF usingElementComparator(Comparator<? super Map.Entry<? extends K, ? extends V>> customComparator) {
        throw new UnsupportedOperationException("custom element Comparator is not supported for MapEntry comparison");
    }

    @Override
    @Deprecated
    public SELF usingDefaultElementComparator() {
        throw new UnsupportedOperationException("custom element Comparator is not supported for MapEntry comparison");
    }

    @Override
    @CheckReturnValue
    public SELF as(String description, Object ... args) {
        return (SELF)((AbstractMapAssert)super.as(description, args));
    }

    @Override
    @CheckReturnValue
    public SELF as(Description description) {
        return (SELF)((AbstractMapAssert)super.as(description));
    }

    @Override
    @CheckReturnValue
    public SELF describedAs(Description description) {
        return (SELF)((AbstractMapAssert)super.describedAs(description));
    }

    @Override
    @CheckReturnValue
    public SELF describedAs(String description, Object ... args) {
        return (SELF)((AbstractMapAssert)super.describedAs(description, args));
    }

    @Override
    public SELF doesNotHave(Condition<? super ACTUAL> condition) {
        return (SELF)((AbstractMapAssert)super.doesNotHave((Condition)condition));
    }

    @Override
    public SELF doesNotHaveSameClassAs(Object other) {
        return (SELF)((AbstractMapAssert)super.doesNotHaveSameClassAs(other));
    }

    @Override
    public SELF has(Condition<? super ACTUAL> condition) {
        return (SELF)((AbstractMapAssert)super.has((Condition)condition));
    }

    @Override
    public SELF hasSameClassAs(Object other) {
        return (SELF)((AbstractMapAssert)super.hasSameClassAs(other));
    }

    @Override
    public SELF hasToString(String expectedToString) {
        return (SELF)((AbstractMapAssert)super.hasToString(expectedToString));
    }

    @Override
    public SELF is(Condition<? super ACTUAL> condition) {
        return (SELF)((AbstractMapAssert)super.is((Condition)condition));
    }

    @Override
    public SELF isEqualTo(Object expected) {
        return (SELF)((AbstractMapAssert)super.isEqualTo(expected));
    }

    @Override
    public SELF isExactlyInstanceOf(Class<?> type) {
        return (SELF)((AbstractMapAssert)super.isExactlyInstanceOf((Class)type));
    }

    @Override
    public SELF isIn(Iterable<?> values) {
        return (SELF)((AbstractMapAssert)super.isIn((Iterable)values));
    }

    @Override
    public SELF isIn(Object ... values) {
        return (SELF)((AbstractMapAssert)super.isIn(values));
    }

    @Override
    public SELF isInstanceOf(Class<?> type) {
        return (SELF)((AbstractMapAssert)super.isInstanceOf((Class)type));
    }

    @Override
    public SELF isInstanceOfAny(Class<?> ... types) {
        return (SELF)((AbstractMapAssert)super.isInstanceOfAny((Class[])types));
    }

    @Override
    public SELF isNot(Condition<? super ACTUAL> condition) {
        return (SELF)((AbstractMapAssert)super.isNot((Condition)condition));
    }

    @Override
    public SELF isNotEqualTo(Object other) {
        return (SELF)((AbstractMapAssert)super.isNotEqualTo(other));
    }

    @Override
    public SELF isNotExactlyInstanceOf(Class<?> type) {
        return (SELF)((AbstractMapAssert)super.isNotExactlyInstanceOf((Class)type));
    }

    @Override
    public SELF isNotIn(Iterable<?> values) {
        return (SELF)((AbstractMapAssert)super.isNotIn((Iterable)values));
    }

    @Override
    public SELF isNotIn(Object ... values) {
        return (SELF)((AbstractMapAssert)super.isNotIn(values));
    }

    @Override
    public SELF isNotInstanceOf(Class<?> type) {
        return (SELF)((AbstractMapAssert)super.isNotInstanceOf((Class)type));
    }

    @Override
    public SELF isNotInstanceOfAny(Class<?> ... types) {
        return (SELF)((AbstractMapAssert)super.isNotInstanceOfAny((Class[])types));
    }

    @Override
    public SELF isNotOfAnyClassIn(Class<?> ... types) {
        return (SELF)((AbstractMapAssert)super.isNotOfAnyClassIn((Class[])types));
    }

    @Override
    public SELF isNotNull() {
        return (SELF)((AbstractMapAssert)super.isNotNull());
    }

    @Override
    public SELF isNotSameAs(Object other) {
        return (SELF)((AbstractMapAssert)super.isNotSameAs(other));
    }

    @Override
    public SELF isOfAnyClassIn(Class<?> ... types) {
        return (SELF)((AbstractMapAssert)super.isOfAnyClassIn((Class[])types));
    }

    @Override
    public SELF isSameAs(Object expected) {
        return (SELF)((AbstractMapAssert)super.isSameAs(expected));
    }

    @Override
    @CheckReturnValue
    public SELF overridingErrorMessage(String newErrorMessage, Object ... args) {
        return (SELF)((AbstractMapAssert)super.overridingErrorMessage(newErrorMessage, args));
    }

    @Override
    @CheckReturnValue
    public SELF usingDefaultComparator() {
        return (SELF)((AbstractMapAssert)super.usingDefaultComparator());
    }

    @Override
    @CheckReturnValue
    public SELF usingComparator(Comparator<? super ACTUAL> customComparator) {
        return (SELF)((AbstractMapAssert)super.usingComparator((Comparator)customComparator));
    }

    @Override
    @CheckReturnValue
    public SELF withFailMessage(String newErrorMessage, Object ... args) {
        return (SELF)((AbstractMapAssert)super.withFailMessage(newErrorMessage, args));
    }

    @Override
    @CheckReturnValue
    public SELF withThreadDumpOnError() {
        return (SELF)((AbstractMapAssert)super.withThreadDumpOnError());
    }

    @CheckReturnValue
    public AbstractMapSizeAssert<SELF, ACTUAL, K, V> size() {
        Preconditions.checkNotNull(this.actual, "Can not perform assertions on the size of a null map.");
        return new MapSizeAssert(this, ((Map)this.actual).size());
    }

    @Override
    @CheckReturnValue
    public AbstractObjectArrayAssert<?, Object> extracting(String ... keys) {
        return super.extracting(keys);
    }
}

