/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.containerelement;

import jakarta.validation.constraints.Size;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="3.0.0")
public class SameElementContainedSeveralTimesInCollectionTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)SameElementContainedSeveralTimesInCollectionTest.webArchiveBuilder().withTestClass(SameElementContainedSeveralTimesInCollectionTest.class)).build();
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="c")
    public void sameInvalidInstanceInListShouldBeReportedWithAllPaths() {
        ListContainer listContainer = new ListContainer(Arrays.asList("", "A", ""));
        Set constraintViolations = this.getValidator().validate((Object)listContainer, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("values").containerElement("<list element>", true, null, 0, List.class, 0)), ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("values").containerElement("<list element>", true, null, 2, List.class, 0)));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="c")
    public void sameInvalidInstanceInMapShouldBeReportedWithAllPaths() {
        List emptyList = Collections.emptyList();
        List<String> nonEmptyList = Arrays.asList("A");
        HashMap<String, List<String>> values = new HashMap<String, List<String>>();
        values.put("NON_EMPTY", nonEmptyList);
        values.put("EMPTY_1", emptyList);
        values.put("EMPTY_2", emptyList);
        MapContainer withMap = new MapContainer(values);
        Set constraintViolations = this.getValidator().validate((Object)withMap, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("values").containerElement("<map value>", true, "EMPTY_1", null, Map.class, 1)), ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("values").containerElement("<map value>", true, "EMPTY_2", null, Map.class, 1)));
    }

    private static class MapContainer {
        public Map<String, @Size(min=1) List<String>> values;

        public MapContainer(Map<String, List<String>> values) {
            this.values = values;
        }
    }

    private static class ListContainer {
        public List<@Size(min=1) String> values;

        public ListContainer(List<String> values) {
            this.values = values;
        }
    }
}

