/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.mobile;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.dirigible.repository.api.IEntity;
import org.eclipse.dirigible.runtime.mobile.MobileExecutor;
import org.eclipse.dirigible.runtime.registry.PathUtils;
import org.eclipse.dirigible.runtime.registry.RegistryServlet;
import org.eclipse.dirigible.runtime.repository.RepositoryFacade;
import org.eclipse.dirigible.runtime.scripting.IScriptExecutor;

public class MobileRegistryServlet
extends RegistryServlet {
    private static final long serialVersionUID = -491670839750494628L;
    private static final String CONTENT_FOLDER = "/MobileApplications";

    protected String extractRepositoryPath(HttpServletRequest request) throws IllegalArgumentException {
        String requestPath = PathUtils.extractPath((HttpServletRequest)request);
        if (request.getAttribute("sandbox") != null && ((Boolean)request.getAttribute("sandbox")).booleanValue()) {
            return "/db/dirigible/sandbox/" + RepositoryFacade.getUser((HttpServletRequest)request) + this.getContentFolder() + requestPath;
        }
        return "/db/dirigible/registry/public" + this.getContentFolder() + requestPath;
    }

    protected String getWebRegistryPath(HttpServletRequest request) throws IllegalArgumentException {
        if (request.getAttribute("sandbox") != null && ((Boolean)request.getAttribute("sandbox")).booleanValue()) {
            return "/db/dirigible/sandbox/" + RepositoryFacade.getUser((HttpServletRequest)request) + this.getContentFolder();
        }
        return "/db/dirigible/registry/public" + this.getContentFolder();
    }

    protected String getContentFolder() {
        return CONTENT_FOLDER;
    }

    protected byte[] preprocessContent(byte[] rawContent, IEntity entity) throws IOException {
        return rawContent;
    }

    public IScriptExecutor createExecutor(HttpServletRequest request) throws IOException {
        return new MobileExecutor(this.getRepository(request), this.getWebRegistryPath(request), "/db/dirigible/registry/public" + this.getContentFolder());
    }
}

