/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.content;

import java.io.IOException;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.dirigible.repository.api.ICollection;
import org.eclipse.dirigible.repository.api.IEntity;
import org.eclipse.dirigible.repository.api.IMasterRepository;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.api.IResource;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.content.ContentPostImportUpdater;
import org.eclipse.dirigible.runtime.repository.RepositoryFacade;
import org.eclipse.dirigible.runtime.task.IRunnableTask;
import org.eclipse.dirigible.runtime.task.TaskManagerShort;

public class MasterRepositorySynchronizerServlet
extends HttpServlet {
    private static final long serialVersionUID = 6468050094756163896L;
    private static final Logger logger = Logger.getLogger(MasterRepositorySynchronizerServlet.class);

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    public void registerInitRegister() {
        TaskManagerShort.getInstance().registerRunnableTask((IRunnableTask)new MasterRepositorySynchronizerRegister(this));
        logger.info("Master Repository Synchronizer Register has been registered");
    }

    private void synchronizeMasterRepository(HttpServletRequest request) throws ServletException {
        try {
            IRepository repository = RepositoryFacade.getInstance().getRepository(request);
            IMasterRepository masterRepository = RepositoryFacade.getInstance().getMasterRepository(request);
            if (masterRepository != null) {
                this.copyRepository(masterRepository, repository);
                this.postImport(repository);
            } else {
                logger.info("Master Repository is not used in this instance");
            }
        }
        catch (Exception e) {
            throw new ServletException("Initializing local database for Repository use failed", (Throwable)e);
        }
    }

    private void copyRepository(IMasterRepository sourceRepository, IRepository targetRepository) throws IOException {
        ICollection root = sourceRepository.getRoot();
        this.copyCollection(root, targetRepository);
    }

    private void copyCollection(ICollection parent, IRepository targetRepository) throws IOException {
        List entities = parent.getChildren();
        for (IEntity entity : entities) {
            if (entity instanceof ICollection) {
                ICollection collection = (ICollection)entity;
                this.copyCollection(collection, targetRepository);
                continue;
            }
            IResource resource = (IResource)entity;
            try {
                targetRepository.createResource(resource.getPath(), resource.getContent(), resource.isBinary(), resource.getContentType(), true);
                logger.info(String.format("Initial copy from the Mater Repository of the Resource: %s", resource.getPath()));
            }
            catch (Exception e) {
                logger.info(String.format("Failed initial copy from the Mater Repository of the Resource: %s", resource.getPath()));
                logger.error(e.getMessage());
            }
        }
    }

    private void postImport(IRepository repository) throws IOException, Exception {
        ContentPostImportUpdater contentPostImportUpdater = new ContentPostImportUpdater(repository);
        contentPostImportUpdater.update(null);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.synchronizeMasterRepository(req);
    }

    class MasterRepositorySynchronizerRegister
    implements IRunnableTask {
        MasterRepositorySynchronizerServlet contentInitializerServlet;

        MasterRepositorySynchronizerRegister(MasterRepositorySynchronizerServlet contentInitializerServlet) {
            this.contentInitializerServlet = contentInitializerServlet;
        }

        public String getName() {
            return "Master Repository Synchronizer Register";
        }

        public void start() {
            boolean ok = true;
            try {
                MasterRepositorySynchronizerServlet.this.synchronizeMasterRepository(null);
            }
            catch (ServletException e) {
                logger.error(e.getMessage(), (Throwable)e);
                ok = false;
            }
            if (ok) {
                TaskManagerShort.getInstance().unregisterRunnableTask((IRunnableTask)this);
                logger.info("Master Repository Synchronizer Register has been un-registered");
            }
        }
    }
}

