/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.wiki;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.dirigible.repository.api.IEntity;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.registry.PathUtils;
import org.eclipse.dirigible.runtime.repository.RepositoryFacade;
import org.eclipse.dirigible.runtime.scripting.IScriptExecutor;
import org.eclipse.dirigible.runtime.web.WebRegistryServlet;
import org.eclipse.dirigible.runtime.wiki.WikiExecutor;
import org.eclipse.dirigible.runtime.wiki.WikiProcessor;

public class WikiRegistryServlet
extends WebRegistryServlet {
    private static final Logger logger = Logger.getLogger(WikiRegistryServlet.class);
    private static final String WIKI_CONTENT = "/WikiContent";
    private static final long serialVersionUID = -1484072696377972535L;

    protected String extractRepositoryPath(HttpServletRequest request) throws IllegalArgumentException {
        String requestPath = PathUtils.extractPath((HttpServletRequest)request);
        if (request.getAttribute("sandbox") != null && ((Boolean)request.getAttribute("sandbox")).booleanValue()) {
            return "/db/dirigible/sandbox/" + RepositoryFacade.getUser((HttpServletRequest)request) + WIKI_CONTENT + requestPath;
        }
        return "/db/dirigible/registry/public/WikiContent" + requestPath;
    }

    protected byte[] preprocessContent(byte[] rawContent, IEntity entity) throws IOException {
        return WikiProcessor.processContent(rawContent, entity);
    }

    protected String getContentFolder() {
        return WIKI_CONTENT;
    }

    public IScriptExecutor createExecutor(HttpServletRequest request) throws IOException {
        WikiExecutor executor = new WikiExecutor(this.getRepository(request), this.getWebRegistryPath(request), "/db/dirigible/registry/public/WikiContent");
        return executor;
    }
}

