/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.workspace.ui.viewer;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.dirigible.ide.workspace.dual.CustomResourceChangeListener;
import org.eclipse.dirigible.ide.workspace.dual.ICustomResourceChangeListenerCallback;
import org.eclipse.dirigible.ide.workspace.dual.WorkspaceLocator;
import org.eclipse.dirigible.ide.workspace.ui.viewer.WorkspaceContentProvider;
import org.eclipse.dirigible.ide.workspace.ui.viewer.WorkspaceLabelProvider;
import org.eclipse.dirigible.ide.workspace.ui.viewer.WorkspaceSorter;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class WorkspaceViewer
implements ICustomResourceChangeListenerCallback {
    public static final Logger logger = Logger.getLogger((String)WorkspaceViewer.class.getCanonicalName());
    private static final String WORKSPACE_MENU = "Workspace Menu";
    private final TreeViewer viewer;
    private final MenuManager menuManager;
    private IResourceChangeListener changeListener;

    public WorkspaceViewer(Composite parent, int style) {
        this(parent, style, WorkspaceLocator.getWorkspace());
    }

    private WorkspaceViewer(Composite parent, int style, IWorkspace workspace) {
        PatternFilter filter = new PatternFilter();
        FilteredTree tree = new FilteredTree(parent, 770, filter, true);
        this.viewer = tree.getViewer();
        this.viewer.setContentProvider((IContentProvider)new WorkspaceContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new WorkspaceLabelProvider());
        this.viewer.setSorter((ViewerSorter)new WorkspaceSorter());
        this.viewer.getControl().addDisposeListener(new DisposeListener(){
            private static final long serialVersionUID = 2504065180094207979L;

            public void widgetDisposed(DisposeEvent event) {
                WorkspaceViewer.this.releaseData();
            }
        });
        this.menuManager = new MenuManager(WORKSPACE_MENU, "sample.MenuManager");
        this.menuManager.add((IContributionItem)new GroupMarker("additions"));
        Menu menu = this.menuManager.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.changeListener = new CustomResourceChangeListener((StructuredViewer)this.viewer, (ICustomResourceChangeListenerCallback)this);
        if (workspace != null) {
            this.setInput((IContainer)workspace.getRoot());
        } else {
            this.setInput(null);
        }
    }

    public MenuManager getMenuManager() {
        return this.menuManager;
    }

    public ISelectionProvider getSelectionProvider() {
        return this.viewer;
    }

    public Control getControl() {
        return this.viewer != null ? this.viewer.getControl() : null;
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public void setInput(IContainer container) {
        IContainer currentInput = this.getInput();
        if (!this.areEqual(currentInput, container)) {
            this.changeInput(currentInput, container);
        }
    }

    public IContainer getInput() {
        return (IContainer)this.viewer.getInput();
    }

    public void refresh() {
        Object[] elements = this.viewer.getExpandedElements();
        this.viewer.refresh();
        this.viewer.setExpandedElements(elements);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void dispose() {
        this.viewer.getControl().dispose();
    }

    private void changeInput(IContainer oldInput, IContainer newInput) {
        IWorkspace newWorkspace;
        IWorkspace oldWorkspace = oldInput != null ? oldInput.getWorkspace() : null;
        IWorkspace iWorkspace = newWorkspace = newInput != null ? newInput.getWorkspace() : null;
        if (!this.areEqual(oldWorkspace, newWorkspace)) {
            this.changeWorkspace(oldWorkspace, newWorkspace);
        }
        this.viewer.setInput((Object)newInput);
    }

    private void changeWorkspace(IWorkspace oldWorkspace, IWorkspace newWorkspace) {
        if (oldWorkspace != null) {
            oldWorkspace.removeResourceChangeListener(this.changeListener);
        }
        if (newWorkspace != null) {
            newWorkspace.addResourceChangeListener(this.changeListener);
        }
    }

    private boolean areEqual(Object a, Object b) {
        if (a != null) {
            return a.equals(b);
        }
        return b == null;
    }

    private void releaseData() {
        IContainer input = this.getInput();
        if (input != null) {
            input.getWorkspace().removeResourceChangeListener(this.changeListener);
        }
    }

    public void callback() {
        this.refresh();
    }
}

