/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.workspace.ui.shared;

import org.eclipse.dirigible.ide.workspace.ui.shared.IValidationStatus;

public class ValidationStatus
implements IValidationStatus {
    private final Type type;
    private final String message;

    private ValidationStatus(Type type, String message) {
        this.type = type;
        this.message = message;
    }

    @Override
    public boolean isOK() {
        return this.type == Type.OK;
    }

    @Override
    public boolean hasErrors() {
        return this.type == Type.ERROR;
    }

    @Override
    public boolean hasWarnings() {
        return this.type == Type.WARNING;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public static ValidationStatus createOk() {
        return new ValidationStatus(Type.OK, null);
    }

    public static ValidationStatus createWarning(String message) {
        return new ValidationStatus(Type.WARNING, message);
    }

    public static ValidationStatus createError(String message) {
        return new ValidationStatus(Type.ERROR, message);
    }

    private static enum Type {
        OK,
        ERROR,
        WARNING;

    }
}

