/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.template.ui.html.wizard;

import org.eclipse.core.resources.IResource;
import org.eclipse.dirigible.ide.common.status.StatusLineManagerUtil;
import org.eclipse.dirigible.ide.template.ui.common.GenerationModel;
import org.eclipse.dirigible.ide.template.ui.common.TemplateGenerator;
import org.eclipse.dirigible.ide.template.ui.common.TemplateWizard;
import org.eclipse.dirigible.ide.template.ui.html.wizard.HtmlTemplateGenerator;
import org.eclipse.dirigible.ide.template.ui.html.wizard.HtmlTemplateModel;
import org.eclipse.dirigible.ide.template.ui.html.wizard.HtmlTemplateTargetLocationPage;
import org.eclipse.dirigible.ide.template.ui.html.wizard.HtmlTemplateTitlePage;
import org.eclipse.dirigible.ide.template.ui.html.wizard.HtmlTemplateTypePage;
import org.eclipse.dirigible.ide.template.ui.html.wizard.Messages;
import org.eclipse.jface.wizard.IWizardPage;

public class HtmlTemplateWizard
extends TemplateWizard {
    private static final String CREATE_USER_INTERFACE = Messages.HtmlTemplateWizard_CREATE_USER_INTERFACE;
    private final HtmlTemplateModel model;
    private final HtmlTemplateTypePage typesPage;
    private final HtmlTemplateTargetLocationPage targetLocationPage;
    private final HtmlTemplateTitlePage titlePage;

    public HtmlTemplateWizard(IResource resource) {
        this.setWindowTitle(CREATE_USER_INTERFACE);
        this.model = new HtmlTemplateModel();
        this.model.setSourceResource(resource);
        this.typesPage = new HtmlTemplateTypePage(this.model);
        this.targetLocationPage = new HtmlTemplateTargetLocationPage(this.model);
        this.titlePage = new HtmlTemplateTitlePage(this.model);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.typesPage);
        this.addPage((IWizardPage)this.targetLocationPage);
        this.addPage((IWizardPage)this.titlePage);
    }

    public TemplateGenerator getTemplateGenerator() {
        HtmlTemplateGenerator generator = new HtmlTemplateGenerator(this.model);
        return generator;
    }

    protected GenerationModel getModel() {
        return this.model;
    }

    public boolean performFinish() {
        boolean result = super.performFinish();
        if (result) {
            StatusLineManagerUtil.setInfoMessage((String)String.format(StatusLineManagerUtil.ARTIFACT_HAS_BEEN_CREATED, this.model.getFileName()));
        }
        return result;
    }
}

