/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.editor.text.editor;

import org.eclipse.dirigible.ide.editor.text.editor.AbstractTextEditor;
import org.eclipse.dirigible.ide.editor.text.editor.ContentProviderException;
import org.eclipse.dirigible.ide.editor.text.editor.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;

public class TextEditor
extends AbstractTextEditor {
    public static final String ID = "org.eclipse.dirigible.ide.editor.text.editor.TextEditor";
    private static final String CANNOT_LOAD_DOCUMENT = Messages.TextEditor_CANNOT_LOAD_DOCUMENT;
    private static final String ERROR = Messages.TextEditor_ERROR;
    private static final String EDITOR_INPUT_CANNOT_BE_NULL = Messages.TextEditor_EDITOR_INPUT_CANNOT_BE_NULL;
    private Text text = null;

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (input == null) {
            throw new PartInitException(EDITOR_INPUT_CANNOT_BE_NULL);
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setPartName(input.getName());
        this.setDirty(false);
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        final TextEditor textEditor = this;
        this.text = this.createTextControl(parent);
        this.text.setLayoutData((Object)new GridData(4, 4, true, true));
        try {
            IEditorInput input = this.getEditorInput();
            String content = this.getContentProvider(input).getContent(input);
            this.text.setText(content);
        }
        catch (ContentProviderException contentProviderException) {
            MessageDialog.openError(null, (String)ERROR, (String)CANNOT_LOAD_DOCUMENT);
        }
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                textEditor.setDirty(true);
            }
        });
    }

    protected Text createTextControl(Composite parent) {
        return new Text(parent, 770);
    }

    public void dispose() {
        this.text = null;
        super.dispose();
    }

    @Override
    protected String getEditorContents() {
        return this.text.getText();
    }

    @Override
    protected Control getEditorControl() {
        return this.text;
    }

    public void setPartName(String partName) {
        super.setPartName(partName);
    }
}

