/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.workspace.ui.view;

import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.dirigible.ide.common.CommonParameters;
import org.eclipse.dirigible.ide.common.image.ImageUtils;
import org.eclipse.dirigible.ide.common.status.StatusLineManagerUtil;
import org.eclipse.dirigible.ide.publish.PublishException;
import org.eclipse.dirigible.ide.publish.PublishManager;
import org.eclipse.dirigible.ide.workspace.ui.view.Messages;
import org.eclipse.dirigible.ide.workspace.ui.view.NewMenuItemViewProvider;
import org.eclipse.dirigible.ide.workspace.ui.view.WebViewerView;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class ToolBarMenuViewProvider {
    private static final Logger logger = Logger.getLogger(ToolBarMenuViewProvider.class);
    private static final String EMPTY = "";
    private static final String SAVE = Messages.WorkspaceExplorerView_SAVE;
    private static final String SAVE_ALL = Messages.WorkspaceExplorerView_SAVE_ALL;
    private static final String NEW = Messages.WorkspaceExplorerView_NEW;
    private static final String PUBLISH_TOOL_TIP_TEXT = Messages.WorkspaceExplorerView_PUBLISH;
    private static final String ACTIVATE_TOOL_TIP_TEXT = Messages.WorkspaceExplorerView_ACTIVATE;
    private static final String PUBLISH_FAILED = Messages.WorkspaceExplorerView_PUBLISH_FAILED;
    private static final String ACTIVATION_FAILED = Messages.WorkspaceExplorerView_ACTIVATION_FAILED;
    private static final Image SAVE_ICON = ImageUtils.createImage((URL)ImageUtils.getIconURL((String)"org.eclipse.dirigible.ide.workspace.ui", (String)"/resources/icons/", (String)"save.png"));
    private static final Image SAVE_ALL_ICON = ImageUtils.createImage((URL)ImageUtils.getIconURL((String)"org.eclipse.dirigible.ide.workspace.ui", (String)"/resources/icons/", (String)"save_all.png"));
    private static final Image PUBLISH_ICON = ImageUtils.createImage((URL)ImageUtils.getIconURL((String)"org.eclipse.dirigible.ide.publish.ui", (String)"/resources/icons/", (String)"publish.png"));
    private static final Image ACTIVATE_ICON = ImageUtils.createImage((URL)ImageUtils.getIconURL((String)"org.eclipse.dirigible.ide.publish.ui", (String)"/resources/icons/", (String)"activate.png"));

    public static void createToolBarMenu(Composite parent, Shell shell) {
        if (CommonParameters.isRAP()) {
            int style = 8521800;
            ToolBar toolBar = new ToolBar(parent, style);
            ToolBarMenuViewProvider.createActivateToolItem(toolBar, shell);
            ToolBarMenuViewProvider.createSeparator(toolBar);
            ToolBarMenuViewProvider.createPublishToolItem(toolBar, shell);
            ToolBarMenuViewProvider.createSeparator(toolBar);
            ToolBarMenuViewProvider.createSaveToolItem(toolBar);
            ToolBarMenuViewProvider.createSeparator(toolBar);
            ToolBarMenuViewProvider.createSaveAllToolItem(toolBar);
            ToolBarMenuViewProvider.createSeparator(toolBar);
            ToolBarMenuViewProvider.createNewToolItem(parent, toolBar);
        }
    }

    private static ToolItem createSeparator(ToolBar toolBar) {
        return new ToolItem(toolBar, 2);
    }

    private static ToolItem createActivateToolItem(ToolBar toolBar, final Shell shell) {
        ToolItem toolItem = ToolBarMenuViewProvider.createToolItem(toolBar, EMPTY, ACTIVATE_TOOL_TIP_TEXT, ACTIVATE_ICON);
        toolItem.addSelectionListener(new SelectionListener(){
            private static final long serialVersionUID = 2364528684607846153L;

            public void widgetSelected(SelectionEvent e) {
                StatusLineManagerUtil.getDefaultStatusLineManager().removeAll();
                try {
                    ToolBarMenuViewProvider.activate();
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                    StatusLineManagerUtil.setErrorMessage((String)ex.getMessage());
                    MessageDialog.openError((Shell)shell, (String)PUBLISH_FAILED, (String)ex.getMessage());
                }
                WebViewerView.refreshWebViewerViewIfVisible();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return toolItem;
    }

    private static ToolItem createPublishToolItem(ToolBar toolBar, final Shell shell) {
        ToolItem toolItem = ToolBarMenuViewProvider.createToolItem(toolBar, EMPTY, PUBLISH_TOOL_TIP_TEXT, PUBLISH_ICON);
        toolItem.addSelectionListener(new SelectionListener(){
            private static final long serialVersionUID = 3334607710375924130L;

            public void widgetSelected(SelectionEvent e) {
                StatusLineManagerUtil.getDefaultStatusLineManager().removeAll();
                try {
                    ToolBarMenuViewProvider.publish();
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                    StatusLineManagerUtil.setErrorMessage((String)ex.getMessage());
                    MessageDialog.openError((Shell)shell, (String)ACTIVATION_FAILED, (String)ex.getMessage());
                }
                WebViewerView.refreshWebViewerViewIfVisible();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return toolItem;
    }

    private static ToolItem createNewToolItem(Composite parent, final ToolBar toolBar) {
        final Menu menu = NewMenuItemViewProvider.createMenu(parent);
        final ToolItem toolItem = ToolBarMenuViewProvider.createToolItem(toolBar, NEW, NEW, null, 4);
        toolItem.addSelectionListener(new SelectionListener(){
            private static final long serialVersionUID = -2281618627759204367L;

            public void widgetSelected(SelectionEvent e) {
                if (e.detail == 4) {
                    Rectangle rect = toolItem.getBounds();
                    Point pt = new Point(rect.x, rect.y + rect.height);
                    pt = toolBar.toDisplay(pt);
                    menu.setLocation(pt.x, pt.y);
                    menu.setVisible(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return toolItem;
    }

    private static ToolItem createSaveToolItem(ToolBar toolBar) {
        ToolItem toolItem = ToolBarMenuViewProvider.createToolItem(toolBar, EMPTY, SAVE, SAVE_ICON);
        toolItem.addSelectionListener(new SelectionListener(){
            private static final long serialVersionUID = -8381124396267155406L;

            public void widgetSelected(SelectionEvent e) {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                IPageListener saveAction = (IPageListener)ActionFactory.SAVE.create(window);
                saveAction.pageActivated(window.getActivePage());
                ((ActionFactory.IWorkbenchAction)saveAction).run();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return toolItem;
    }

    private static ToolItem createSaveAllToolItem(ToolBar toolBar) {
        ToolItem toolItem = ToolBarMenuViewProvider.createToolItem(toolBar, EMPTY, SAVE_ALL, SAVE_ALL_ICON);
        toolItem.addSelectionListener(new SelectionListener(){
            private static final long serialVersionUID = 6845514748708051108L;

            public void widgetSelected(SelectionEvent e) {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                ActionFactory.SAVE_ALL.create(window).run();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return toolItem;
    }

    private static ToolItem createToolItem(ToolBar toolBar, String text, String toolTipText, Image image) {
        return ToolBarMenuViewProvider.createToolItem(toolBar, text, toolTipText, image, 8);
    }

    private static ToolItem createToolItem(ToolBar toolBar, String text, String toolTipText, Image image, int style) {
        ToolItem toolItem = new ToolItem(toolBar, style);
        toolItem.setText(text);
        toolItem.setToolTipText(toolTipText);
        toolItem.setImage(image);
        return toolItem;
    }

    private static void publish() throws PublishException {
        IProject[] iProjectArray = PublishManager.getProjects((ISelection)ToolBarMenuViewProvider.getSelection());
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            PublishManager.publishProject((IProject)project);
            ++n2;
        }
    }

    private static void activate() throws PublishException {
        IProject[] iProjectArray = PublishManager.getProjects((ISelection)ToolBarMenuViewProvider.getSelection());
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            PublishManager.activateProject((IProject)project);
            ++n2;
        }
    }

    private static ISelection getSelection() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
        ISelectionService selectionService = workbenchWindow.getSelectionService();
        ISelection selection = selectionService.getSelection();
        return selection;
    }
}

