/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.List;
import java.util.Objects;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.server.ProcessStreamConnectionProvider;

public abstract class ProcessOverSocketStreamConnectionProvider
extends ProcessStreamConnectionProvider {
    private int port;
    private Socket socket;
    private InputStream inputStream;
    private OutputStream outputStream;

    public ProcessOverSocketStreamConnectionProvider(List<String> commands, String workingDir, int port) {
        super(commands, workingDir);
        this.port = port;
    }

    @Override
    public void start() throws IOException {
        ServerSocket serverSocket = new ServerSocket(this.port);
        Thread socketThread = new Thread(() -> {
            try {
                try {
                    this.socket = serverSocket.accept();
                }
                catch (IOException e) {
                    LanguageServerPlugin.logError(e);
                    try {
                        serverSocket.close();
                    }
                    catch (IOException e2) {
                        LanguageServerPlugin.logError(e2);
                    }
                }
            }
            finally {
                try {
                    serverSocket.close();
                }
                catch (IOException e) {
                    LanguageServerPlugin.logError(e);
                }
            }
        });
        socketThread.start();
        super.start();
        try {
            socketThread.join();
        }
        catch (InterruptedException e) {
            LanguageServerPlugin.logError(e);
            Thread.currentThread().interrupt();
        }
        if (this.socket == null) {
            throw new IOException("Unable to make socket connection: " + this.toString());
        }
        this.inputStream = this.socket.getInputStream();
        this.outputStream = this.socket.getOutputStream();
    }

    @Override
    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public void stop() {
        super.stop();
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                LanguageServerPlugin.logError(e);
            }
        }
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result ^ Objects.hashCode(this.port);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProcessOverSocketStreamConnectionProvider)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        ProcessOverSocketStreamConnectionProvider other = (ProcessOverSocketStreamConnectionProvider)obj;
        return Objects.equals(this.getCommands(), other.getCommands()) && Objects.equals(this.getWorkingDirectory(), other.getWorkingDirectory()) && Objects.equals(this.socket, other.socket);
    }
}

